program Grau3;

{
  Eingabe: .3 - Dateien, die mit dem Programm "KUCKUCK" erzeugt wurden
           (Taste "g")

  Ausgabe: .BMP - Dateien mit 4 Bit Farbinformation

  aus .3 Dateien, die 3 Belichtungen enthalten,
  wird eine Bitmap-Datei erzeugt, die 4 Graustufen hat;
  Abmessungen sind gleich wie Eingabe (128*128 oder 128*256);
  4 Bit/Pixel

  Version 1.2
  25. 6.1992
}

{$I video.inc}


var fn1,fn2,                           {Namen der Ein- und Ausgabedatei}
    s         : String;
    f1,f2     : file;                  {Ein- und Ausgabedatei}
    Ergebnis  : array[0..2] of feld;   {Eingabe : 3 Belichtungen}
    grau      : grauinfo;              {Ausgabe : Bitmapinformation}
    Nummer    : Word;                  {Zhler fr Ein/Ausgabedateien}

    res       : word;

    halb      : boolean;

function ja : boolean;
var c : char;
begin
   repeat c := upcase(readkey)
   until c in ['J','N'];
   write(c);
   delay(300);
   ja := c = 'J'
end;

procedure finde_geeigneten_Dateinamen(var fn : string);
var ueber : boolean;
    f : file;
begin
   ueber := false;
   assign(f,PFAD + fn + '00.BMP');
   {$I-} reset(f,1); {$I+}
   while (ioresult = 0) and (not ueber) do
   begin
      writeln(fn + 'nn.BMP existiert bereits.');
      write('berschreiben ? ');
      ueber := ja;
      if not ueber then
      begin write('Dateiname : ');
            readln(fn);
            assign(f,PFAD + fn + '00.BMP');
            {$I-} reset(f,1); {$I+}
      end;
   end;
end;

procedure init;
var i : integer;
    f : file;
    Graphdriver,
    GraphMode : integer;
begin
   clrscr;
   writeln('Generierung von Bitmap-Dateien aus .3 - Files');
   writeln('zur Weiterbearbeitung.');
   writeln;
   write('von welchen Dateien (NAME ohne Nummer): ');
   readln(fn1);

   fn2 := fn1;

   finde_geeigneten_Dateinamen(fn2);

   assign(f,PFAD + fn1 + '00.3');
   reset(f,1);
   halb := filesize(f) = 6144;

   GraphDriver:=Detect;
   InitGraph (GraphDriver, GraphMode, '');
   cleardevice;

   if halb then for i := 0 to  8095 do grau[i] := 0
           else for i := 0 to 16383 do grau[i] := 0;
end;

procedure umwandlung(halb : boolean);
{
  Umwandlung der drei Einzelbelichtungen in Bitmap-Format
}
var max,i,j,z : word;
    h0,h1,h2,h,sch : byte;
begin
   if halb then max := 2047
           else max := 4095;

   z := 0;                           { Zhler fr GrauInfo }
   sch := 4;
   h := 0;

   for i := 0 to max do              { alle Bytes der E-Felder }
   begin
      h0 := ergebnis[0,i];
      h1 := ergebnis[1,i];
      h2 := ergebnis[2,i];
      for j := 0 to 7 do
      begin
         if h0 and 128 = 128
            then h := h or 15
            else if h1 and 128 = 128
                    then h := h or 8
                    else if h2 and 128 = 128 then h := h or 7;   {!!}

         h0 := (h0 and 127) shl 1;
         h1 := (h1 and 127) shl 1;
         h2 := (h2 and 127) shl 1;

         h := h shl sch;
         sch := sch xor 4;
         if sch = 4 then
         begin
            grau[z] := h;
            h := 0;
            z := succ(z);
         end;
      end;
   end;
end; {umwandlung}


BEGIN  {main}

   init;
   nummer := 0;
   str(nummer,s);
   if length(s) = 1 then s := '0'+s;
   repeat
      schnell_lesen(fn1 + s + '.3',Ergebnis,res,halb,3);

      umwandlung(halb);
      Grau_speichern(Grau,fn2+s,halb);

      Anzeige(15,addr(Ergebnis[0]),halb,0);
      Anzeige(15,addr(Ergebnis[1]),halb,16);
      Anzeige(15,addr(Ergebnis[2]),halb,32);

      inc(nummer);
      str(nummer,s);
      if length(s) = 1 then s := '0'+s;
   until not exist(fn1+s+'.3');
   sound(1000);
   delay(20);
   nosound;
   outtextxy(440,300,'Return drcken');
   readln;
   closegraph
end.
