; Initram initialisiert das an den Druckerausgang
; angeschlossene DRAM mit logisch "0". Es wird nur eine
; Hlfte des DRAM benutzt



;Drucker-Daten auf Port  03BCH / 0278H  -> Adresseingang DRAM
;Drucker: Bit    7  6  5  4  3  2  1  0
;DRAM  Adr.-Bit  7  0  5  4  3  2  1  6


;Drucker-Status auf Port  03BDH / 0279H <- Dout DRAM
; benutzt: Bit 5
; Drucker: PE
; DRAM:    Dout



;Drucker-Steuersignale auf Port  03BEH / 027AH   -> Steuersignale DRAM
;      Bit:             3        2        1        0
;     .................................................
; Pin Drucker        SLCTIN   RESET   Autofeed  Strobe
; Pin DRAM            nCAS     RAS       nWE      nDin    (n->Negation)




DATA SEGMENT WORD PUBLIC 'DATA'
DATA ENDS

CODE SEGMENT BYTE PUBLIC 'CODE'
     ASSUME  CS:CODE,DS:DATA
             PUBLIC  initRAM

DRUCK_LO     EQU    078H         ; niederwertiges Byte Druckportadresse
DRUCK_HI     EQU    02H          ; hherwertiges

initRAM      PROC   NEAR
             PUSH   BP
             MOV    BP,SP
             PUSH   DS
             MOV    DH,DRUCK_HI
             MOV    CH,00H       ; Zeilenzhler initialisieren


LOOP1:       MOV    CL,080H      ; Spaltenzhler initialisieren

LOOP:        MOV    AL,CL        ; Spaltenadresse
             ADD    AL,63        ; wir benutzen nur
                                 ; die mittleren 128 Bits

; erster Schritt: Spaltenadresse an DRAM ausgeben
             MOV    DL,DRUCK_LO  ;
             OUT    DX,AL        ;

; zweiter Schritt: Kontrollbits DRAM setzen:
;  RAS = 0, CAS = 1, WE = 0, Din = 0
             MOV    AL,03H   ;02
             MOV    DL,DRUCK_LO+2
             OUT    DX,AL         ; DRAM bernimmt Spaltenadresse

; dritter Schritt: Zeilenadresse ausgeben
             MOV    AL,CH
             MOV    DL,DRUCK_LO
             OUT    DX,AL

; vierter Schritt: Kontrollbits an DRAM ausgeben:
;  RAS = 0, CAS = 0, WE = 0, Din = 0
;  alle Bits mit logisch 0 initialisieren
             MOV    AL,0BH
             MOV    DL,DRUCK_LO+2
             OUT    DX,AL         ; DRAM bernimmt Zeilenadresse und
                                  ; logische 0 an Din

; fnfter Schritt:  Kontrollbits zurcksetzen:
;  RAS = 1, CAS = 1, WE = 1, Din = 1
             MOV    AL,04H
             OUT    DX,AL

             DEC    CL            ; Spaltenzhler luft rckwrts
             JNZ    LOOP

             INC    CH            ; Zeilenzhler luft vorwrts
             JNZ    LOOP1

WEITER:      POP    DS
             POP    BP            ; DS und BP wiederherstellen
             RET                  ; Rcksprung

initRAM      ENDP
CODE         ENDS
             END

