program kuckuck;
{
  Programm zur Verwendung mit einer Selbstbau-Videokamera.

  Von der Kamera fotografierte Bilder werden auf dem Monitor
  dargestellt und knnen abgespeichert werden.

  Bilder werden im Voll- oder Halbformat aufgenommen
  (128*256 bzw 128*128 Pixel)

  Die Menuepunkte sind selbsterklrend (hoffe ich), nur die
  Punkte

    <k> : Kontrastfaktor vermindern
    <K> : Kontrastfaktor erhhen

  sind vielleicht etwas unklar.
  Bei Mehrfachbelichtungen ("g" und "9") werden 3 bzw 9 Aufnahmen
  mit unterschiedlichen Belichtungszeiten gemacht, dabei ergibt
  sich die krzeste Zeit als

    aktuelle Zeit / Kontrastfaktor und die lngste Zeit zu
    aktuelle Zeit * Kontrastfaktor

  Einfache Aufnahmen werden im Bitmap-Format gespeichert, der
  Dateinamen ist der

    angegebene Namen + zweistellige Nummer + '.BMP'

  Mehrfachbelichtungen werden gespeichert als

    angegebene Namen + zweistellige Nummer + '.4'  bzw
    angegebene Namen + zweistellige Nummer + '.9'

  und haben noch kein Bitmap-Format (siehe GRAU3 und DITHER)

  Version 1.2
  25. 6.1992
}

{$I video.inc}


var Nummer,
    GNummer  : integer;  {Nummer der Datei; Standardbelichtung, Mehrfachbel.}
    fn,                  {Dateiname}
    hs,
    ks       : string;
    Ergebnis : feld;     {hierher kommen die zurckgelesenen Daten}
    GrauErg  : Feld3;    {fr die Dreifachbelichtung}
    zeit     : real;     {Belichtungszeit}
    halb,                {Halbformat-Flag}
    auto,                {Automatik-Flag}
    ende      : boolean; {'E' wurde gedrckt}
    kontrast  : real;

procedure init;
var Graphdriver,GraphMode:integer;
    c : char;
begin
   write('Datei (max. 5 Zeichen) .: ');readln(fn);
   if fn = '' then fn := 'bild';
   repeat
     write('(H)alb- oder (V)ollbild : ');
     readln(c);
   until upcase(c) in ['H','V'];
   halb := upcase(c) = 'H';

   GraphDriver:=Detect;
   InitGraph (GraphDriver, GraphMode, '');

   zeit     := 100.0;
   Nummer   := 0;
   GNummer  := 0;
   auto     := false;
   kontrast := 1.4;
   ende     := false;

   setcolor(15);
   outtextxy(230, 35,'Tastenbelegung');
   outtextxy(230, 50,' <Q> : Belichtungszeit verlngern (grob)');
   outtextxy(230, 60,' <A> :       "         verkrzen');
   outtextxy(230, 70,' <q> : Belichtungszeit verlngern (fein)');
   outtextxy(230, 80,' <a> :       "         verkrzen');
   outtextxy(230, 90,' < > : Einzelaufnahme');
   outtextxy(230,100,' <g> : 3 Aufnahmen mit verschiedenen');
   outtextxy(230,110,'       Belichtungszeiten (fr 4 Graustufen)');
   outtextxy(230,120,' <9> : 9 Aufnahmen mit verschiedenen');
   outtextxy(230,130,'       Belichtungszeiten (fr Dither)');
   outtextxy(230,140,' <> : Automatik ein (es werden laufend');
   outtextxy(230,150,'       Einzelbilder aufgenommen)');
   outtextxy(230,160,' <> : Automatik aus');
   outtextxy(230,170,' <v> : Selbstauslser (3 Aufnahmen)');
   outtextxy(230,180,' <K> : Kontrastfaktor erhhen');
   outtextxy(230,190,' <k> : Kontrastfaktor vermindern');
   outtextxy(230,200,' <E> : Programmende');

   outtextxy(230,220,'aktuelle Belichtungszeit :');
   str(kontrast:5:3,ks);
   outtextxy(230,230,'Kontrastfaktor ');
   setcolor(yellow);
   outtextxy(250,230,'               '+ks);
end; {init}

procedure AufPlatte(var Ergebnis : feld; var Nummer : integer);
{
  Ein Einzelbild wird im Bitmap-Format auf Platte gespeichert,
  Die Dateinummer wird erhht.
  Das erste Bild hat die Nummer 0.
}
var h,s:string;
begin
   str(Nummer,s);
   if length (s)=1 then s:='0'+s;
   h:= fn + s;
   speichern(Ergebnis, h, halb);
   Nummer:=succ(Nummer);
   sound(50);
   delay(45);
   nosound;
end; {AufPlatte}

procedure Neun(var GNummer : integer);
{
  9-fach-Belichtung mit Speicherung der Einzelbelichtungen
  in der Datei fn + 2-stellige Nummer + '.9'.
  Weiterbearbeitung mit Programm 'DITHER'
}
var h,s,s2,s3:string;
    c : char;
    i,t : word;
    h1,h2 : real;
    f : file;
begin
   str(GNummer,s);
   if length(s)=1 then s:='0'+s;
   h:= fn + s;

   assign (f,PFAD+h+'.9');
   rewrite (f,1);

   s2 := 'Belichtung Nr ';
   setcolor(15);
   outtextxy(250,250,s2);

   s3 := '';
   for i := 0 to 8 do
   begin
      setcolor(0);
      outtextxy(250,250,'              '+s3);
      setcolor(red);
      str(i,s3);
      outtextxy(250,250,'              '+s3);
      h1 := ln(kontrast);
      h2 := (i-4.0)*0.25;
      t := trunc(zeit*exp(h1*h2));
      belichte(Ergebnis,t,halb);
      speichern_kurz(Ergebnis, f, halb);
      Anzeige (15,addr(Ergebnis), halb,0);
      Anzeige_Dateinamen(h);
   end;

   close(f);

   setcolor(0);
   outtextxy(250,250,s2 + '8');

   GNummer:=succ(GNummer);

   sound(50);
   delay(45);
   nosound;
end; {Neun}

procedure Grau(var GNummer : integer);
{
  3-fach-Belichtung mit Speicherung der Einzelbelichtungen
  in der Datei fn + 2-stellige Nummer + '.3'.
  Weiterbearbeitung mit den Programmen
    'GRAU3' : Umwandlung in .BMP - Format  und
    'GRAU4' : Umwandlung in .4 - Format zur Verwendung mit FilmAb
}
var h,s,s2:string;
    c : char;
    f : file;
begin
   GrauErg[1] := Ergebnis;
   setcolor(15);
   s2 := 'Belichtung Nr ';
   outtextxy(250,250,s2);
   setcolor(red);
   outtextxy(250,250,'              2');
   belichte(GrauErg[0],trunc(zeit/kontrast),halb);

   setcolor(0);
   outtextxy(250,250,'              2');
   setcolor(red);
   outtextxy(250,250,'              3');
   belichte(GrauErg[2],trunc(zeit*kontrast),halb);
   setcolor(0);
   outtextxy(250,250,s2 + '3');

   Anzeige_Grau(GrauErg[0],GrauErg[1],GrauErg[2],halb);

   setcolor(15);
   outtextxy(250,250,'Speichern (J/N)');

   repeat c := upcase(readkey)
   until c in ['J','N'];

   setcolor(0);
   outtextxy(250,250,'Speichern (J/N)');

   if c ='J' then
   begin
      str(GNummer,s);
      if length (s)=1 then s:='0'+s;
      h:= fn + s;

      assign (f,PFAD+h+'.3');
      rewrite (f,1);

      speichern_kurz(GrauErg[0], f, halb);
      speichern_kurz(GrauErg[1], f, halb);
      speichern_kurz(GrauErg[2], f, halb);

      close(f);

      Anzeige_Dateinamen(h+'.3');

      GNummer:=succ(GNummer);
      sound(50);
      delay(45);
      nosound;
   end;
end; {Grau}

procedure Einstellung;
var c : char;
BEGIN
  if keypressed then
  begin
     c := readkey;
     case c of
        'q' : zeit:= zeit * 1.03;
        'a' : zeit:= zeit * 0.97;
        'Q' : zeit:= zeit * 1.53;
        'A' : zeit:= zeit * 0.6;
        ' ' : AufPlatte(Ergebnis, Nummer);
        'g' : Grau(GNummer);
        '9' : Neun(GNummer);
        '' : auto := true;
        '' : auto := false;
        'k','K' : begin
                     if c = 'k' then kontrast := kontrast/1.03
                                else kontrast := kontrast*1.03;
                     setcolor(0);
                     outtextxy(250,230,'               '+ks);
                     str(kontrast:5:3,ks);
                     setcolor(yellow);
                     outtextxy(250,230,'               '+ks);
                  end;
        'E' : ende := true;
        'v' : begin delay(6000);
                    Grau(GNummer);
              end;
     end;
  end;
  if auto then AufPlatte(Ergebnis, Nummer);

  setcolor(0);
  outtextxy(440,220,hs);
  str(trunc(zeit):5,hs);
  setcolor(2);
  outtextxy(440,220,hs);
end;  {Einstellung}

BEGIN  {main}
   init;

   while (not ende) do
   begin
      belichte(Ergebnis, trunc(zeit), halb);
      Einstellung;
      Anzeige (15,addr(Ergebnis), halb,0);
   end;

   sound(1000);
   delay(20);
   nosound;
   outtextxy(440,300,'Return drcken');
   readln;
   closegraph
end. {main}
