;Drucker-Daten   -> Adresseingang DRAM
;Drucker: Bit    7  6  5  4  3  2  1  0
;DRAM  Adr.-Bit  7  0  5  4  3  1  2  6


;Drucker-Status  <- Dout DRAM
; benutzt: Bit 5
; Drucker: PE
; DRAM:    Dout



;Drucker-Steuersignale -> Steuersignale DRAM
;      Bit:             3        2        1        0
;     .................................................
; Pin Drucker        SLCTIN   RESET   Autofeed  Strobe
; Pin DRAM            nCAS     RAS       nWE      nDIN

; ("n" bedeutet, da das Bit invertiert wird)




DATA SEGMENT WORD PUBLIC 'DATA'
DATA ENDS

CODE SEGMENT BYTE PUBLIC 'CODE'
     ASSUME  CS:CODE,DS:DATA
     PUBLIC  leseRAM2                ; Name der Routine

DRUCK_LO     EQU    78H             ; Adresse Druckerport Lowbyte
DRUCK_HI     EQU    02H             ; Adresse Druckerport Highbyte

ZEIGER       EQU    DWORD   PTR [BP+4]  ; Pointer auf Ergebnisfeld

;  Leseram liest die einzelnen Bits des DRAMs in das Ergebnisfeld,
;  auf das ZEIGER zeigt,
;  Die Bildinformation liegt nach dem Lesen in BMP-Format vor.

leseRAM2     PROC   NEAR
             PUSH   BP              ; BP sichern
             MOV    BP,SP
             PUSH   DS              ; DS sichern

             LES    DI,ZEIGER       ; Zeiger auf Ergebnisfeld holen

             CLD                    ; Flags lschen
             MOV    DH,DRUCK_HI     ; fr OUT-Befehle
             MOV    CH,40H          ;
             MOV    BL,08           ; Bit-Zhler

LOOP1:       MOV    CL,080H         ; 128 Spalten


LOOP2:       MOV    AL,CL           ; CL ist der Spaltenzhler
             ADD    AL,63           ; AL:Adresse der Spalte
             TEST   AL,4
             JZ     WW              ; nach WW, falls Bit 4 gesetzt
             XOR    AL,3            ; sonst Spaltenadresse korrigieren


; erster Schritt: die Spaltenadresse wird an das DRAM gelegt
WW:          MOV    DL,DRUCK_LO     ; die Spaltenadresse wird auf
             OUT    DX,AL           ; den Druckerport ausgegeben

; zweiter Schritt: Kontrollsignale am DRAM:
; CAS=1 , RAS=0, WE=1 : Spaltenadresse wird von DRAM bernommen
             MOV    AL,0
             MOV    DL,DRUCK_LO + 2 ; Kontrollport Drucker
             OUT    DX,AL           ; Kontrollbits ausgeben

             MOV    AL,CH
             TEST   AL,2
             JNZ    WW1
             XOR    AL,1            ; evtl. Zeilenadresse korrigieren

; dritter Schritt: Zeilenadresse an DRAM ausgeben
WW1:         MOV    DL,DRUCK_LO
             OUT    DX,AL           ; Zeilenadresse an DRAM anlegen

; vierter Schritt: Kontrollsignale am DRAM:
; CAS=0 , RAS=0 ,WE=1 : Zeilenadresse wird von DRAM bernommen
             MOV    AL,08H
             MOV    DL,DRUCK_LO + 2
             OUT    DX,AL           ; Kontrollbits ausgeben

; fnfter Schritt: Einlesen des adressierten Bits
             DEC    DX              ; DX zeigt jetzt auf Druckerstatus
             IN     AL,DX           ; Einlesen
             SHL    AL,1            ; gelesenes Bit ins CARRY
             SHL    AL,1
             SHL    AL,1

             RCL    BH,1            ;uns interessiert nur Bit 5

;sechster Schritt: Rcksetzen der Kontrollsignale am DRAM
; CAS=1 , RAS =1 , WE=1
             INC    DX              ; DX auf Kontrollport
             MOV    AL,04H
             OUT    DX,AL           ; DRAM-Zyklus beendet

             DEC    BL              ; 8 Durchlufe

             JZ     ABSPEICH        ; 8 Bit gelesen

             DEC    CL              ; Spaltenzhler luft rckwrts
             JNZ    LOOP2           ; 127 mal

             INC    CH              ; Zeilenzhler luft vorwrts
             CMP    CH,0C0H
             JNZ    LOOP1           ;

             JMP    FERTIG

ABSPEICH:    MOV    AL,BH           ; 8 Bits wurden in BH gesammelt
             STOSB                  ; gelesenes Byte in Ergebnisfeld
             DEC    CL              ; Spaltenzhler luft rckwrts
             MOV    BL,08           ; Bitzhler wieder setzen
             JNZ    LOOP2
             INC    CH
             CMP    CH,0C0H
             JNZ    LOOP1

FERTIG:      POP    DS
             POP    BP              ; DS, BP wiederherstellen
             RET    4               ; Rcksprung

leseRAM2     ENDP
CODE         ENDS
             END

