{
  Include-File, das von den anderen Programmen genutzt wird.

  Version 1.2
  25. 6.1992
}


{
  Einbinden der Assemblerroutinen
}

{$L INITRAM}
{$L LESERAM}
{$L INITRAM2}
{$L LESERAM2}
{$L ANZEIGE}

uses graph,crt;

const PFAD = '..\bilder\';     { In diesem Directory werden die
                                 Bilder abgespeichert.
                               }

type
     feld         = array[0..4095] of byte;    {eine Belichtung}
     feld3        = array[0..2] of feld;       {Dreifachbelichtung}
     grosses_feld = array[0..36863] of byte;   {Neunfachbelichtung}
     grauinfo     = array[0..16383] of byte;   {4-Farb-Bitmap-Info}


     e_feld = array[0..38399] of byte;

     farbinfo = array[0..3] of Byte;           {Fr .BMP-Kopf}

     kopftype =                                {Kopf einer .BMP-Datei}
              record
                   bfType        : Word;       {hier steht $4d42 fr 'BM'}
                   bfSize        : LongInt;    {Bildinformation + Kopf}
                   bfReserved1   : Word;       {nicht verwendet}
                   bfReserved2   : Word;       {      "        }
                   bfOffBits     : LongInt;    {Lnge des Kopfes}

                   biSize        : LongInt;
                   biWidth       : LongInt;    {Breite in Pixel}
                   biHeigth      : LongInt;    {Hhe in Pixel}
                   biPlanes      : Word;       {Anzahl der Bitplanes}
                   biBitCount    : Word;       {Bit / Pixel}
                   biCompression : array[1..6] of longint;
                                               {verwendete Kompression}

                   farbe         : array[0..15] of farbinfo;
                                               {Zuordnung von Farbe}
              end;
     zeile = array[0..79] of byte;

const VollFormatKopf : kopftype =
                   (bfType        : 19778;     {'BM'}
                    bfSize        : 4158;
                    bfReserved1   : 0;
                    bfReserved2   : 0;
                    bfOffBits     : 62;
                    biSize        : 40;
                    biWidth       : 128;
                    biHeigth      : 256;
                    biPlanes      : 1;
                    biBitCount    : 1;
                    biCompression : (0,0,0,0,0,0);   {keine}
                    farbe         : ((0,0,0,0),(255,255,255,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0)
                                    )
                   );

const HalbFormatKopf : kopftype =
                   (bfType        : 19778;
                    bfSize        : 2110;
                    bfReserved1   : 0;
                    bfReserved2   : 0;
                    bfOffBits     : 62;
                    biSize        : 40;
                    biWidth       : 128;
                    biHeigth      : 128;
                    biPlanes      : 1;
                    biBitCount    : 1;
                    biCompression : (0,0,0,0,0,0);
                    farbe         : ((0,0,0,0),(255,255,255,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0),
                                     (0,0,0,0),(0,0,0,0)
                                    )
                   );

const VGrauKopf : kopftype =
                   (bfType        : 19778;
                    bfSize        : 16502;
                    bfReserved1   : 0;
                    bfReserved2   : 0;
                    bfOffBits     : 118;
                    biSize        : 40;
                    biWidth       : 128;
                    biHeigth      : 256;
                    biPlanes      : 1;
                    biBitCount    : 4;
                    biCompression : (0,0,0,0,0,0);
                    farbe         : (($00,$00,$00,$00),($00,$00,$80,$00),
                                     ($00,$80,$00,$00),($00,$80,$80,$00),
                                     ($80,$00,$00,$00),($80,$00,$80,$00),
                                     ($80,$80,$00,$00),($80,$80,$80,$00),
                                     ($c0,$c0,$c0,$00),($00,$00,$ff,$00),
                                     ($00,$ff,$00,$00),($00,$ff,$ff,$00),
                                     ($ff,$00,$00,$00),($ff,$00,$ff,$00),
                                     ($ff,$ff,$00,$00),($ff,$ff,$ff,$00)
                                    )
                   );

const HGrauKopf : kopftype =
                   (bfType        : 19778;
                    bfSize        : 8310;
                    bfReserved1   : 0;
                    bfReserved2   : 0;
                    bfOffBits     : 118;
                    biSize        : 40;
                    biWidth       : 128;
                    biHeigth      : 128;
                    biPlanes      : 1;
                    biBitCount    : 4;
                    biCompression : (0,0,0,0,0,0);
                    farbe         : (($00,$00,$00,$00),($00,$00,$80,$00),
                                     ($00,$80,$00,$00),($00,$80,$80,$00),
                                     ($80,$00,$00,$00),($80,$00,$80,$00),
                                     ($80,$80,$00,$00),($80,$80,$80,$00),
                                     ($c0,$c0,$c0,$00),($00,$00,$ff,$00),
                                     ($00,$ff,$00,$00),($00,$ff,$ff,$00),
                                     ($ff,$00,$00,$00),($ff,$00,$ff,$00),
                                     ($ff,$ff,$00,$00),($ff,$ff,$ff,$00)
                                    )
                   );

var tmp_kopf : kopftype;

{
  Die Assemblerroutinen werden deklariert
}

procedure initram ;external;

procedure leseRAM (P : Pointer);external;

procedure initram2 ;external;

procedure leseRAM2 (P : Pointer);external;

procedure Anzeige (farbe : byte;           {0..15, Es werden die Bitplanes
                                            0..3 ausgewhlt,
                                            (1111b = wei, 0001b = blau ...)
                                           }
                   Ergebnis : Pointer;
                   halb : boolean;
                   plus : word);
                                external;

function exist(fn : String) : boolean;
var f : file;
    iores : boolean;
begin
   assign(f,PFAD + fn);
   {$I-} reset(f,1); {$I+}
   iores := ioresult = 0;
   if iores then close(f);

   exist := iores;
end;

procedure korrekt(var ergebnis : feld; halb : boolean);
{
  Korrekturroutine fr den von uns verwendeten DRAM;
  es werden unterschiedliche Empfindlichkeiten einzelner Speicherzellen
  ausgeglichen. Diese Routine mu fr andere Chips natrlich angepasst
  werden. Wenn alle Speicherzellen gleiche Empfindlichkeiten haben kann
  auf diese Routine verzichtet werden.
}
var i,j,z,max : word;
begin
   if halb then max := 127 else max := 255;
   for z := 0 to max do
   begin
      i := 16*z or 7;
      {xxx00xxx --> xxxxxx00}
      if (ergebnis[i] and 24) = 0  then ergebnis[i] := ergebnis[i] and 252;
      i := succ(i);
      {xxx00xxx --> 00xxxxxx}
      if (ergebnis[i] and 24) = 0  then ergebnis[i] := ergebnis[i] and 63;
   end;
end; {korrekt}


procedure korrekt2(var ergebnis : feld; halb : boolean);
{
  In dieser Prozedur wird das Bild um 5 Pixel auseinandergezogen,
  um die Chipgeometrie zu bercksichtigen.
  Die enstehende Lcke wird wieder gefllt, wobei die Informationen
  links und rechts des Zwischenraums bercksichtigt werden.
  (Die Routine funktioniert allerdings nicht besonders gut, Das Ergebnis
  sieht ohne die Korrektur oft besser aus).
  Fr andere Chips mssen natrlich andere Algorithmen gefunden werden.
}
var z,max,i1,i2 : word;
    h,h2 : byte;
begin

   { Matrizen um 5 Pixel auseinanderziehen }

   if halb then max := 127 else max := 255;
   for z := 0 to max do
   begin
      h2 := 0;
      for i1 := 8 to 15 do
      begin
         h := ergebnis[z*16 + i1] and 31;
         ergebnis[z*16 + i1] := (ergebnis[z*16 + i1] shr 5) or (h2 shl 3);
         h2 := h;
      end;
   end;

   { Zwischenraum auffllen }

   for z := 0 to max do
   begin
      i1 := z*16 or 7;
      i2 := succ(i1);
      if (Ergebnis[i1] and 1 = 1) and (Ergebnis[i2] and 4 = 4)
         then h := 248
         else
      if (Ergebnis[i1] and 1 = 0) and (Ergebnis[i2] and 4 = 0)
         then h := 0
         else
      if (Ergebnis[i1] and 1 = 1) and (Ergebnis[i2] and 4 = 0)
         then begin h := 192 or (random(2) shl 5);
              end
         else
      if (Ergebnis[i1] and 1 = 0) and (Ergebnis[i2] and 4 = 4)
         then begin h := 24 or (random(2) shl 5);
              end;
      Ergebnis[i2] := Ergebnis[i2] or h;
   end;
end; {korrekt2}


procedure belichte(var Ergebnis : feld; zeit : word;halb : boolean);
begin
   if halb then
   begin
      initram2;                  {im Halbformat 128*128}
      delay (zeit);
      leseram2(addr(Ergebnis));
   end else
   begin                         {Vollformat 128*256}
      initram;                   {Speicherzellen laden}
      delay (zeit);              {belichten}
      leseram(addr(Ergebnis));   {Bildinformation lesen}
   end;
                                 {Ergebnis korrigieren}
   korrekt(Ergebnis, halb);      {unterschiedliche Empfindlichkeiten}
   korrekt2(Ergebnis, halb);     {Anordnung der Speichermatrizen}
end;

procedure Anzeige_Dateinamen(fn:String);
var y : integer;
begin
   setcolor(0);
   for y := 270 to 278 do line (230,y, 350,y);
   setcolor(15);
   outtextxy(230,270,fn);
end;

procedure speichern_kurz(var Ergebnis : feld; var f : file; halb : boolean);
{
  Speichert Bild ohne Header
}
var res : word;
begin
   if halb then blockwrite(f,Ergebnis,2048)
           else blockwrite(f,Ergebnis,4096);

   setcolor(0);
end;

procedure speichern(var Ergebnis : feld; fn : String; halb : boolean);
{
  Speichern einer 2-Farb-Bitmap-Datei
}
var f:file ;
    res,y : word;
begin
   assign (f,PFAD+fn+'.BMP');
   rewrite (f,1);

   if halb then blockwrite(f,HalbformatKopf,62)
           else blockwrite(f,VollFormatKopf,62);
   if halb then blockwrite(f,Ergebnis,2048)
           else blockwrite(f,Ergebnis,4096);
   close (f);

   setcolor(0);
   Anzeige_Dateinamen(fn);
end;

procedure Grau_speichern(var Ergebnis : GrauInfo; fn : String; halb : boolean);
{
  Speichern einer 4-Farb-Bitmap-Datei
}
var f:file ;
    res,y : word;
begin
   assign (f,PFAD+fn+'.BMP');
   rewrite (f,1);

   if halb then blockwrite(f,HGrauKopf,118)
           else blockwrite(f,VGrauKopf,118);
   if halb then blockwrite(f,Ergebnis,8192)
           else blockwrite(f,Ergebnis,16384);
   close (f);

   setcolor(0);
   Anzeige_Dateinamen(fn);
end;


procedure auszeile(y:word; var azeile: zeile;bpz,fa:byte);
var i,j,x:word;
    h : byte;
begin
   setcolor(fa);
   for i := 0 to bpz do
   begin
      h := azeile[i];
      for j := 7 downto 0 do
      begin
         if (h and 1) = 1 then putpixel(i*8+j,y,fa);
         h := h shr 1;
      end;
   end;
end;

(*  Pascal - Version von Anzeige
procedure ZeigeAn(var Ergebnis:e_feld; Breite, Hoehe, Tiefe, Size : word);
type zeilentyp = array[0..79] of byte;
var ep : word;
    bd8, hz1,hz2,hz4,hz8,ai,ah : byte;
    zeile1,zeile2,zeile4,zeile8 : zeilentyp;
    x,y,yy,xmax,ymax, bpz:word;
    maske : byte;
    pp,p,j,h1,h2 : byte;
    i,gbpz : word;
    azeile : zeile;
begin
  ymax := pred(Hoehe);
  if Tiefe = 1
  then
  begin
    maske := 255 xor (255 shr (Breite and 7));
    if maske = 0 then maske := 255;
    bpz := Size div Hoehe;
    bpz := (succ(pred(breite) shr 5)) shl 2;

    xmax := pred(Breite) div 8;

    for y:=0 to ymax do
    begin
      for x:=0 to pred(xmax) do
        mem[$A000:x + y*80] := Ergebnis[y * bpz + x];
      mem[$A000:xmax + y*80] := Ergebnis[y * bpz + xmax] and maske;
    end
  end
  else
    begin
       gbpz := succ(breite) shr 1;
       bpz := 4 + ((pred(breite) div 2) and 252);     {*}

       bd8 := breite shr 3;
       y := hoehe;
       yy := 0;
       i := bpz;
       repeat
          dec(y);
          ah := 0;
          ai := 0;
          zeile1[ai] := 0; zeile2[ai] := 0; zeile4[ai] := 0; zeile8[ai] := 0;

          ep := 0;
          repeat
             h1 := Ergebnis[y*bpz + ep];

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile8[ai] := (zeile8[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile4[ai] := (zeile4[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile2[ai] := (zeile2[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile1[ai] := (zeile1[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile8[ai] := (zeile8[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile4[ai] := (zeile4[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile2[ai] := (zeile2[ai] shl 1) or h2;

             h2 := (h1 and 128) shr 7;
             h1 := (h1 and 127) shl 1;
             zeile1[ai] := (zeile1[ai] shl 1) or h2;

             ah := succ(ah) and 3;
             if ah=0 then
             begin
                inc(ai);
                zeile1[ai] := 0; zeile2[ai] := 0;
                zeile4[ai] := 0; zeile8[ai] := 0;
             end;
             inc(ep);
          until ep = bpz;

          port[$3c4] := 2;
          port[$3c5] := 1;
          for ai := 0 to bd8 do mem[$A000:yy*80 + ai] := zeile1[ai];

          port[$3c4] := 2;
          port[$3c5] := 2;
          for ai := 0 to bd8 do mem[$A000:yy*80 + ai] := zeile2[ai];

          port[$3c4] := 2;
          port[$3c5] := 4;
          for ai := 0 to bd8 do mem[$A000:yy*80 + ai] := zeile4[ai];

          port[$3c4] := 2;
          port[$3c5] := 8;
          for ai := 0 to bd8 do mem[$A000:yy*80 + ai] := zeile8[ai];

          inc(yy);
       until y=0;
    end;
END;  {ZeigeAn}
*)

procedure schnell_lesen(fn : String;
                        var a;
                        var res : word;
                        halb : boolean;
                        n : integer);
{
  Liest 3 oder 9 Belichtungen in Puffer a
}
var e : array[1..9] of feld absolute a;
var h : integer;
    f : file;
begin
   res := 0;
   assign(f,PFAD+fn);
   {$I-} reset(f,1); {$I+}
   if ioresult = 0
   then begin
           for h := 1 to n do
              if halb then blockread(f,e[h],2048, res)
                      else blockread(f,e[h],4096, res);
           close(f);
        end
   else res := 0;
end;

procedure lesen(fn : String;
                var Ergebnis : feld;
                var res : word;
                halb : boolean);
{
  Liest eine 2-Farb-Bitmap
}
var h : integer;
    kopf : array[1..62] of byte;
    f : file;
begin
   res := 0;
   assign(f,PFAD+fn + '.BMP');
   {$I-} reset(f,1); {$I+}
   if ioresult = 0
   then begin
           blockread(f,kopf,62,res);
           if halb then blockread(f,ergebnis,2048, res)
                   else blockread(f,ergebnis,4096, res);
           close(f);
        end
   else res := 0;
end;


procedure lesekopf(fn : String; var kopf : kopftype);
{
  Liest den Kopf einer Bitmap-Datei
}
var f : file;
begin
   assign(f,PFAD+fn+'.BMP');
   reset(f,1);
   blockread(f,kopf,SizeOf(kopf));
   close(f);
end;

procedure leseBitMap(fn       : String;
                     var kopf : kopftype;
                     var Ergebnis : e_feld;
                     emax     : word;
                     var res  : word);
var f : file;
    s : longint;
begin
   lesekopf(fn,kopf);
   res := 0;
   assign(f,'C:\WINDOWS\video\'+fn+'.BMP');
   reset(f,1);
   blockread(f,kopf,kopf.bfOffBits);
   s := kopf.bfSize - kopf.bfOffBits;
   if s <= emax
     then blockread(f,ergebnis, s, res);
   close(f);
   if res <> s then res := 0;
end;

procedure schreibeBitMap(fn       : String;
                         var kopf : kopftype;
                         var Ergebnis : e_feld;
                         emax     : word;
                         var res  : word);
var f : file;
    s : longint;
begin
   assign(f,'C:\WINDOWS\video\'+fn+'.BMP');
   rewrite(f,1);
   blockwrite(f,kopf,kopf.bfOffBits);
   s := kopf.bfSize - kopf.bfOffBits;
   blockwrite(f,ergebnis, s, res);
   close(f);
   if res <> s then res := 0;
end;

function ist_halb(fn:string):boolean;
{
  Testen, ob eine zweifarbige Bitmap Halb- oder Vollformat hat
}
begin
   lesekopf(fn,tmp_kopf);
   ist_halb := tmp_kopf.bfSize = (2048 + 62);
end;

procedure Anzeige_Grau(var E0,E1,E2 : feld; halb : boolean);
{
  3 Einzelbelichtungen werden als 4-farbiges Bild
  (schwarz, dunkelgrau, hellgrau und wei) angezeigt;
  relativ langsam, da die Farbe jedes Pixels einzeln berechnet
  werden mu.
}
var zeile,x,xx,max,i,xh : word;
    p : array[0..3,0..15] of byte;
    h0,h1,h2,pl : byte;
begin
   if halb then max := 2047
           else max := 4095;

   zeile := 160*239;

   if halb then zeile := 160*128;

   for x := 0 to max do
   begin

      h0 := E0[x];
      h1 := E1[x];
      h2 := E2[x];

      xh := x and 15;

      p[0,xh] := 0;
      p[1,xh] := 0;
      p[2,xh] := 0;
      p[3,xh] := 0;

      for xx := 0 to 7 do                    { jedes Pixel }
      begin
         p[0,xh] := p[0,xh] shl 1;
         p[1,xh] := p[1,xh] shl 1;
         p[2,xh] := p[2,xh] shl 1;
         p[3,xh] := p[3,xh] shl 1;

         if h0 and 128 = 128                 { wei }
         then begin p[0,xh] := p[0,xh] or 1;
                    p[1,xh] := p[1,xh] or 1;
                    p[2,xh] := p[2,xh] or 1;
                    p[3,xh] := p[3,xh] or 1
              end
         else if h1 and 128 = 128            { hell }
              then begin p[0,xh] := p[0,xh] or 1;
                         p[1,xh] := p[1,xh] or 1;
                         p[2,xh] := p[2,xh] or 1
                   end
              else if h2 and 128 = 128       { dunkel }
                   then p[3,xh] := p[3,xh] or 1;

         h0 := (h0 and 127) shl 1;
         h1 := (h1 and 127) shl 1;
         h2 := (h2 and 127) shl 1;
      end;

      if succ(xh) mod 16 = 0 then
      begin
         pl := 1;
         for i := 0 to 3 do
         begin
            port[$3c4] := 2;
            port[$3c5] := pl;
            for xh := 0 to 15 do mem[$A000:0000 + zeile + xh] := p[i,xh];
            for xh := 0 to 15 do mem[$A000:0000 + zeile + xh + 80] := p[i,xh];
            pl := pl shl 1;
         end;
         dec(zeile,160);
      end;
   end;
end; {Anzeige_Grau}

procedure Anzeige_Farbe(var E : e_feld; halb : boolean; plus : word);
var max,i,ii,j : word;
begin
   if halb then max := 127
           else max := 239;

   for i := 0 to max do
   begin
      ii := i*64;
      for j := 0 to 127 do
        putpixel(plus + j,max - i, E[ii + j shr 1] shr ((succ(j) mod 2) shl 2))
   end;
end;

(*
procedure Anzeige_Graualt(var E0,E1,E2 : feld; halb : boolean);
var x,xx,y,max,i : word;
    p : array[0..3,0..15] of byte;
    h0,h1,h2,pl : byte;
begin
   if halb then max := 127
           else max := 239;

   for y := 0 to max do                         { alle Zeilen }
   begin

      for x := 0 to 15 do                       { jedes Byte der E }
      begin
         h0 := E0[y*16 + x];
         h1 := E1[y*16 + x];
         h2 := E2[y*16 + x];

         p[0,x] := 0;
         p[1,x] := 0;
         p[2,x] := 0;
         p[3,x] := 0;

         for xx := 0 to 7 do                    { jedes Pixel }
         begin
            p[0,x] := p[0,x] shl 1;
            p[1,x] := p[1,x] shl 1;
            p[2,x] := p[2,x] shl 1;
            p[3,x] := p[3,x] shl 1;

            if h0 and 128 = 128                 { wei }
            then begin p[0,x] := p[0,x] or 1;
                       p[1,x] := p[1,x] or 1;
                       p[2,x] := p[2,x] or 1;
                       p[3,x] := p[3,x] or 1
                 end
            else if h1 and 128 = 128            { hell }
                 then begin p[0,x] := p[0,x] or 1;
                            p[1,x] := p[1,x] or 1;
                            p[2,x] := p[2,x] or 1
                      end
                 else if h2 and 128 = 128       { dunkel }
                      then p[3,x] := p[3,x] or 1;

            h0 := (h0 and 127) shl 1;
            h1 := (h1 and 127) shl 1;
            h2 := (h2 and 127) shl 1;
         end
      end;

      pl := 1;
      for i := 0 to 3 do
      begin
         port[$3c4] := 2;
         port[$3c5] := pl;
         for x := 0 to 15 do mem[$A000:0000 + y*160 + x] := p[i,x];
         pl := pl shl 1;
      end;
   end;
end;
*)