/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			18.01.2022
 Latest version generated:	11.03.2022
 Filename:					Block.h
 Description:    			Include file for Block.c
 Processor:					ATmega8
 ********************************************************/
#ifndef _BLOCK
#define _BLOCK
/*
** Enums for block occupied or free.
*/
enum BLOCK_OCCU
	{
	BLOCK_IS_FREE,				// Defines Block is free
	BLOCK_IS_OCCU,				// Defines Block is occupied
	};
/*
** Enums for the Block parts.
*/
enum BLOCK_PART
	{
	BLOCK_A,				// Defines Block A Part
	BLOCK_B,				// Defines Block B Part
	};
/*
** Enums for block power status values.
*/
enum BLOCK_POWER_STATUS
	{
	BLOCK_DRIVE_POWER,		// Defines Block Drive, Relay without power	--> Bahnstrom
	BLOCK_BRAKE_POWER,		// Defines Block Brake, Relay with power	--> Bremsstrom
	};
/*
** Enums for train drive direction in block.
*/
enum BLOCK_TRAIN_DRIVE_DIRECTION
	{
	BLOCK_TRAIN_DRIVE_DIR_A2B,	// Defines Block Drive direction from block A to B
	BLOCK_TRAIN_DRIVE_DIR_B2A,	// Defines Block Drive direction from block B to A
	BLOCK_TRAIN_DRIVE_DIR_VOID,	// Defines Block Drive direction is not valid
	};
/*
** Enums for block state machine.
** The sequence of this enum list MUST be identical with the one in the PC-Program.
*/
enum BLOCK_STATE
	{
	STATE_INIT,				// Initiation state after power ON
	STATE_FREE,				// No train in the Block A or B so far
	STATE_OCCUPIED,			// The train has entered either Block A or Block B,
	STATE_SHORTCUT,			// The train is driving over the sectioning point between Block A & B
							// and measures the time of crossing the sectioning point,
							// which gives a value of the actual train speed
	STATE_BRAKE_DELAY,		// A delay is introduced before we apply the Bremsspannung to the block
	STATE_BRAKE_STOP,		// The train is braking or has already stopped at the Signal
	STATE_DRIVE_THROUGH,	// The train shall drive though the block, when the Signal is not red
	STATE_LEAVING_BLOCK,	// The train is leaving the Block A or B (dependent on the drive direction),
							// because the signal was set by the user from red to green or green/yellow
	STATE_ERROR,			// Both blocks (A & B) are occupied, which shall not happen
	};
/*
** Public Functions Declaration.
*/
void Block_Init (void);
void Block_Processor (void);
void Block_UpdateOccupiedStatus (void);
uint8_t Block_GetOccupiedStatus (uint8_t iBlock);
void Block_SetPower (uint8_t iBlock, uint8_t iPower);
uint8_t Block_GetPower (uint8_t iBlock);
uint8_t Block_GetState (void);
uint8_t Block_GetDriveDirection (void);
uint8_t Block_GetShortCut (void);
void Block_SetState (uint8_t iState);
void Block_SetBrakeDelay (uint8_t iBlock, uint8_t iDelay);
uint8_t Block_GetBrakeDelay (uint8_t iBlock);
uint16_t Block_ComputeDelayOverflowCounts (uint16_t iNs);

#endif

