/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			22.01.2022
 Latest version generated:	27.05.2022
 Processor:					ATmega8
 Filename:					EEMEM.h
 Description:				To read and write EEMEM
  *******************************************************/
#ifndef _EEMEM
#define _EEMEM

#define MAX_EBCU_ADDRESS	31		// The maximum allowed EBCU I2C slave address

/*
** Public Function Prototypes.
*/
void EEMEM_Configure (void);
void EEMEM_ReadSlaveAddress (uint8_t *Byte);
void EEMEM_WriteSlaveAddress (uint8_t Byte);
void EEMEM_ReadBrakeDelayBlockA2B (volatile uint8_t *Byte);
void EEMEM_WriteBrakeDelayBlockA2B (uint8_t Byte);
void EEMEM_ReadBrakeDelayBlockB2A (volatile uint8_t *Byte);
void EEMEM_WriteBrakeDelayBlockB2A (uint8_t Byte);
void EEMEM_GetDefaultSlaveAddress (uint8_t *iValue);

#endif