/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			13.12.2021
 Latest version generated:	13.12.2021
 Filename:					General.h
 Description:    			General definitions used in all files of the project
 Processor:					ATmega8
 ********************************************************/
#ifndef _GENERAL
#define _GENERAL

#include "my_xprintf.h"
#define printf xprintf
/*
** To exclude all debugging printf() statements in release version, use "#define RELEASE"
*/
//#define RELEASE
#ifdef RELEASE
#define printf(...)
#endif
/*
** Here are some definitions, used in all files of the project
*/
#define	TRUE	1
#define	FALSE	0
/*
** Defines the used clock crystal frequency.
*/
#define SYSCLOCK		16000000	// Crystal Frequency in Hz
#define F_CPU			SYSCLOCK	// Crystal Frequency in Hz
/*
** Examples:
**
	SET_BIT (PORTB, 1);			// will set output port B1 to high level
	CLEAR_BIT (TIMSK, TOIE2);	// will set the TOIE2 bit in TIMSK register to 0
	TOGGLE_BIT (TCCR1A, WGM10);	// will toggle the WGM10 bit in register TCCR1A
*/
#define SET_BIT(PORT, BITNUM)	((PORT) |= (1<<(BITNUM)))
#define CLEAR_BIT(PORT, BITNUM) ((PORT) &= ~(1<<(BITNUM)))
#define TOOGLE_BIT(PORT,BITNUM) ((PORT) ^= (1<<(BITNUM)))
/*
** Example for using SBIT directive:
**
	#define AUXI1_PORT		SBIT (PORTB, 1)
	AUXI1_PORT = 1;		// will set output port B1 to high level
	AUXI1_PORT = 0;		// will set output port B1 to low level
*/
struct BitsOfByte
	{
	uint8_t b0:1;
	uint8_t b1:1;
	uint8_t b2:1;
	uint8_t b3:1;
	uint8_t b4:1;
	uint8_t b5:1;
	uint8_t b6:1;
	uint8_t b7:1;
	} __attribute__((__packed__));

#define SBIT(port,pin) ((*(volatile struct BitsOfByte*)&port).b##pin)

#endif
