/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			25.03.2007
 Latest version generated:	07.06.2022
 Filename:					RS232.c
 Description:    			Implementation of RS232 Interface
 *******************************************************/
#include <stdio.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>

#include "General.h"
#include "RS232.h"
/*
** Baud Rate fr die Serielle Schnittstelle
*/
#define BAUD_RATE	9600
/*
** Define a stream for the printf() function, using the UART
*/
//FILE uart_str = FDEV_SETUP_STREAM(RS232_putchar, NULL, _FDEV_SETUP_RW);

/*******************************************************
 Function: RS232_Init

 Purpose: Initialise the RS232 serial link

 Input Parameter: None

 Return Value: None
*******************************************************/
void RS232_Init (void)
	{
/*
** Enable TXEN in register UCSRB.
*/
	UCSRB |= (1 << TXEN);
/*
** Set transmission type, Asynchron 8N1.
*/
	UCSRC |= (1 << URSEL)|(3<<UCSZ0);
/*
** Set baud rate
*/
    UBRRH = (uint8_t) ((F_CPU / (BAUD_RATE * 16L) - 1)>>8);
    UBRRL = (uint8_t) (F_CPU / (BAUD_RATE * 16L) - 1);
/*
** Open a channel for printf.
*/
	//stdout = &uart_str;
	}
/*******************************************************
 Function: RS232_putchar

 Purpose: Function to perform "printf "

 Input Parameter: char buffer

 Return Value:
 	Value = 0
*******************************************************/
int RS232_putchar (char c, FILE *stream)
	{
/*
** Check on NEWLINE.
** If yes, send CR character (\r) before we are sending LF (\n) character.
*/
	if (c == '\n')
		{
		loop_until_bit_is_set (UCSRA, UDRE);
		UDR = 0x0D;		// is '\r'
		}
/*
** Wait until previous character is sent
*/
	loop_until_bit_is_set (UCSRA, UDRE);
/*
** Send character to UART.
*/
	UDR = c;

	return 0;
	}
/*******************************************************
 Function: PUTC

 Purpose: Function to perform a character print
			as used by xprintf()

 Input Parameter: char

 Return Value: void
*******************************************************/
void PUTC (char c)
	{
/*
** Check on NEWLINE.
** If yes, send CR character (\r) before we are sending LF (\n) character.
*/
	if (c == '\n')
		{
		loop_until_bit_is_set (UCSRA, UDRE);
		UDR = 0x0D;		// is '\r'
		}
/*
** Wait until previous character is sent.
*/
	loop_until_bit_is_set (UCSRA, UDRE);
/*
** Send character to UART.
*/
	UDR = c;
	return;
	}
/*******************************************************
 Function: PUTS

 Purpose: Function to perform a string print
			as used by xprintf()

 Input Parameter: pointer to char

 Return Value: void
*******************************************************/
void PUTS (char *c)
	{
	while (*c != 0)
		{
		PUTC (*c);
		c++;
		}
	return;
	}




