/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann@t-online.de
 Begin of project:			18.01.2022
 Latest version generated:	20.05.2022
 Filename:					Signal.c
 Description:				Signal functions
 *******************************************************/
#include <stdio.h>
#include <string.h>
#include <avr/io.h>

#include "General.h"
#include "Delay.h"
#include "RS232.h"
#include "Signal.h"
#include "Block.h"
/*
** Defines for 2 Signals (A and B) the output lines.
*/
#define SIGA_R_DDR	SBIT (DDRB, 3)		// Signal A Red
#define SIGA_G_DDR	SBIT (DDRD, 5)		// Signal A Green
#define SIGA_Y_DDR	SBIT (DDRB, 4)		// Signal A Yellow

#define SIGA_R_PORT	SBIT (PORTB, 3)		// Signal A Red
#define SIGA_G_PORT	SBIT (PORTD, 5)		// Signal A Green
#define SIGA_Y_PORT	SBIT (PORTB, 4)		// Signal A Yellow

#define SIGB_R_DDR	SBIT (DDRD, 7)		// Signal B Red
#define SIGB_G_DDR	SBIT (DDRB, 2)		// Signal B Green
#define SIGB_Y_DDR	SBIT (DDRD, 6)		// Signal B Yellow

#define SIGB_R_PORT	SBIT (PORTD, 7)		// Signal B Red
#define SIGB_G_PORT	SBIT (PORTB, 2)		// Signal B Green
#define SIGB_Y_PORT	SBIT (PORTD, 6)		// Signal B Yellow
/*
** Global variables.
*/
volatile uint8_t	SignalStatusA;	// status of signal A
volatile uint8_t	SignalStatusB;	// status of signal B

/*******************************************************
 Function: Signal_Init

 Purpose:
	Init the Signal functionality.

 Input parameters: void

 Return value: void
 *******************************************************/
void Signal_Init (void)
	{
/*
** Set signal ports to output.
*/
	SIGA_R_DDR = 1;
	SIGA_G_DDR = 1;
	SIGA_Y_DDR = 1;

	SIGB_R_DDR = 1;
	SIGB_G_DDR = 1;
	SIGB_Y_DDR = 1;
/*
** Set both signals to red.
*/
	Signal_Set (SIG_A, SIG_RED);
	Signal_Set (SIG_B, SIG_RED);

	return;
	}
/*******************************************************
 Function: Signal_Set

 Purpose:
	Set the Signal.
	The function also applies either Bahnstrom or Bremsspannung.

	This function shall only be called, if it has been checked,
	that the subsequent block (in drive direction) is free !
	This check has to be performed by the TrainController software.

	On wrong input parameters the function does nothing.

 Input parameters:
	uint8_t iSig		Element of {SIG_A, SIG_B}
	uint8_t iSigColor	Element of {SIG_RED, SIG_GREEN,	SIG_GREEN_YELLOW, SIG_TEST}

 Return value: void
 *******************************************************/
void Signal_Set (uint8_t iSig, uint8_t iSigColor)
	{
/*
** Check on correct input values.
*/
	if (iSig > SIG_B) return;
	if (iSigColor > SIG_TEST) return;
/*
** Set all LEDs of concerned signal to OFF (Reset).
** Save new signal status.
** Set the specified signal to the specified colors.
** In case of SIG_GREEN_YELLOW set green and yellow LEDs to ON.
** In case of SIG_TEST set all LEDs to ON.
*/
	if (iSig == SIG_A)
		{
		SignalStatusA = iSigColor;
		Signal_Reset (SIG_A);
		if (iSigColor == SIG_RED)			{SIGA_R_PORT = 1; return;}
		if (iSigColor == SIG_GREEN)			{SIGA_G_PORT = 1; return;}
		if (iSigColor == SIG_GREEN_YELLOW)	{SIGA_G_PORT = 1; SIGA_Y_PORT = 1; return;}
		if (iSigColor == SIG_TEST)			{SIGA_R_PORT = 1; SIGA_G_PORT = 1; SIGA_Y_PORT = 1;}
		return;
		}

	if (iSig == SIG_B)
		{
		SignalStatusB = iSigColor;
		Signal_Reset (SIG_B);
		if (iSigColor == SIG_RED)			{SIGB_R_PORT = 1; return;}
		if (iSigColor == SIG_GREEN)			{SIGB_G_PORT = 1; return;}
		if (iSigColor == SIG_GREEN_YELLOW)	{SIGB_G_PORT = 1; SIGB_Y_PORT = 1; return;}
		if (iSigColor == SIG_TEST)			{SIGB_R_PORT = 1; SIGB_G_PORT = 1; SIGB_Y_PORT = 1;}
		}

	return;
	}
/*******************************************************
 Function: Signal_Get

 Purpose:
	Get the current signal status.
	On wrong iSig parameter, the function returns the status of signal A.

 Input parameters:
	uint8_t iSig		Element of {SIG_A, SIG_B}

 Return value: uint8_t
	Element of {SIG_RED, ... , SIG_YELLOW}
 *******************************************************/
uint8_t Signal_Get (uint8_t iSig)
	{
	if (iSig == SIG_B) return SignalStatusB;
	return SignalStatusA;
	}
/*******************************************************
 Function: Signal_Reset

 Purpose:
	Reset the Signal -> all LEDs to OFF.
	On wrong iSig parameter, the function does nothing.

 Input parameters:
	uint8_t iSig		Element of {SIG_A, SIG_B}

 Return value: void
 *******************************************************/
void Signal_Reset (uint8_t iSig)
	{
	if (iSig == SIG_A)
		{
		SIGA_R_PORT = 0;
		SIGA_G_PORT	= 0;
		SIGA_Y_PORT = 0;
		return;
		}

	if (iSig == SIG_B)
		{
		SIGB_R_PORT = 0;
		SIGB_G_PORT	= 0;
		SIGB_Y_PORT = 0;
		}
	return;
	}
