/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			18.01.2022
 Latest version generated:	11.03.2022
 Filename:					Weiche.h
 Description:    			Include file for Weiche.c
 Processor:					ATmega8
 ********************************************************/
#ifndef _WEICHE
#define _WEICHE
/*
** Enums for Weichen values.
** For a 3-way Weiche, both are used, i.e. W1 and W2.
*/
enum WEICHE_NUMBER
	{
	WEI1,			// Weiche 1
	WEI2,			// Weiche 2
	};

enum WEICHE_DIRECTION
	{
	W_GERADE,		// straight ahead
	W_ABZWEIG,		// turnout
	W_LEFT,			// for 3-way Weiche only
	W_MID,			// for 3-way Weiche only
	W_RIGHT,		// for 3-way Weiche only
	};

/*
** Public Functions Declaration.
*/
void Weiche_Init (void);
void Weiche_Processor (void);
void Weiche_Set (uint8_t iWeiche, uint8_t iDirection);
uint8_t Weiche_Get (uint8_t iWeiche);

#endif

