/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann ät t-online.de
 Begin of project:			18.01.2022
 Latest version generated:	03.06.2022
 Filename:					main.c
 Description:				Main routine for Electronic Block Control Unit, EBCU
 Microprocessor:			ATmega8

 Used Hardware:
 ==============


 Software:
 =========

 Some words to my Language Mess (Kuddelmuddel):
 ==============================================
 German			English
 -----------------------------------------------
 Weiche			Turnout
 Gerade			Straight ahead on a turnout
 Abzweig		Use the turnout of the turnout
 Bahnstrom		The nominal train power (incl. digital signal) which comes from the Booster
 Bremsspannung	-18V power to the rail, which activates the brake function within the locomotive decoder
 Schleifer		The power and signal pick-up shoe at the bottom of the locomotive


 User Timers:
 ============
	TIMER0					in Block.c		1. Measuring the duration of the shortcut of Bremsspannung and Bahnstrom
											2. Performing a delay before switching ON the Bremsspanung
	TIMER1					in Weiche.c		Performing a Weichen pulse
	TIMER2					in AuxiDim.c	Perform a Auxi output port Dimming by PWM

 Used Interrupts:
 ================
	ISR (TIMER0_OVF_vect)	in Block.c		1. Measuring the duration of the shortcut
											2. Performing a delay before switching ON the Bremsspanung
	ISR (TIMER1_OVF_vect)	in Weiche.c		Performing a Weichen pulse
	ISR (TIMER2_OVF_vect)	in AuxiDim.c	Perform the two Auxi output ports Dimming by PWM
 ********************************************************/
#include <stdio.h>
#include <avr/io.h>
#include <avr/interrupt.h>

#include "General.h"
#include "RS232.h"
#include "Delay.h"
#include "Auxi.h"
#include "Weiche.h"
#include "Block.h"
#include "Coms.h"
#include "AuxiDim.h"
#include "EEMEM.h"

/********************************************************
  Main Function
*********************************************************/
int main (void)
	{
/*
** Do not allow any interrupt during boot procedure.
*/
	cli ();
	Delay_ms (50);
/*
** Init RS232 interface with 9600 baud (8N1) for printf() debug functionality.
** To allow printf() for debugging, comment out "#define RELEASE" in General.h
*/
	RS232_Init ();
	printf ("Electronic Block Control Unit, %s %s\n", __DATE__, __TIME__);
/*
** Read and if necessary, configure the ATmega8 internal EEMEM, holding:
**	- the I2C address of this slave controller
**	- the two brake delay values
**	- the EEMEM valid data byte
*/
	EEMEM_Configure ();
/*
** Init the functionalities for Signal, Weichen, Auxi, Block and the TWI interface.
** Note:
**	- The function Signal_Init() is done within function Block_Init()
**	- The function AuxiDim_Init() is done within function Auxi_Init()
**	- The function TWIS_Init() is done within function Coms_Init()
*/
	sei ();				// Enable globally the interrupts
	Weiche_Init ();		// Init 2 Weichen and sets them to direction "gerade" = straight ahead
	Auxi_Init ();		// Init 2 AUXI output ports and sets the two Auxi output ports to OFF
	Coms_Init ();		// Init Coms with TWI interface to Master controller
	Block_Init ();		// Init the block processor, running a state machine

	//Test_AUXI_DIM ();
/*
** Perform the endless Loop.
*/
	while (TRUE)
		{
		Coms_Processor ();		// Performs commands as received from the TWI Master
		Weiche_Processor ();	// Performs the Weichen Pulses, if required
		Block_Processor ();		// Performs the Block logic by a state machine
		}
	}

