/*
 * File:   xprintf.h
 *
 * Snafu (Gast)
 * Created on 5. Februar 2019, 10:16
 https://www.mikrocontroller.net/topic/497784#new
 */

#ifndef _XPRINTF_H
#define _XPRINTF_H

#include <stdint.h>
#include <stdarg.h>

// compile options, comment/uncomment
//******************************************************************************
#define XPRINTF_32 // enable int32/uint32 support

#ifdef XPRINTF_32
    #define xprintf_t uint32_t // max=4294967296
#else
    #define xprintf_t uint16_t // max=65535
#endif

// functions
//******************************************************************************
void xprintDec (xprintf_t x);
void xprintHex (uint8_t data);
void xprintf (char *format, ...);

#endif
