 -- FPGA / VHDL
 -- Project
 -- Digital Clock 
 
library ieee; 
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity watch is 
	port (CLK		:	IN	STD_LOGIC;
			Reset		:	IN	STD_LOGIC;
			sec		:	out std_logic;
			Min0		:	out std_logic_vector(6 downto 0);
			Min1		:	out std_logic_vector(6 downto 0);
			Hr0		:	out std_logic_vector(6 downto 0);
			Hr1		: 	out std_logic_vector(6 downto 0)
			);
End watch;

--------------------------------------------------------------------
--                 Architecture of Digital Clock
--------------------------------------------------------------------

architecture beh_watch of watch is							-- Counter = Entity Name
	signal Divider : std_logic_vector (27 downto 0);	-- Clock Divider Signal für 1 Hz
	signal CLK_ena	: std_logic;
begin

			------------------- Counter ------------------------
	process(clk,reset)											-- Prozess für 1 Hz clock, Prozess wird mit jeder -
	begin																-- Änderung von CLK oder Reset ausgeführt
		if rising_edge(clk) then								--	synchroner Prozess
				divider <= divider + '1';						-- inkrementiere Counter (am Ende des Prozesses!)
			if reset = '1' then									-- falls Reset = 1
				divider <= (others => '0');					-- Divider = 0	
			end if;
				if Divider = 50e6 then 			
					CLK_ena <= '1';
				else
					CLK_ena <=	'0';
			end if;
		end if;
		end process;

			------------------- Taktgeber -----------------------
	--process(divider(50e6), reset)								-- Prozess mit 1 Hz clock für 1 Sekunde (kann gelöscht werden)
	process(clk, reset)	
		variable countsec:	integer	range 0 to 60:=0;	-- Sekunden Zähler bis 60
		variable countmin0:	integer	range 0 to 10:=0;	-- Minute Zähler bis 10
		variable countmin1:	integer	range 0 to 6:=0;	-- Minuten Zähler bis 6
		variable	counthr0:	integer	range 0 to 10:=0;	-- Stunden Zähler bis 10
		variable counthr1:	integer	range 0 to 2:=0;	-- Stunden Zähler bis 2
		
	begin	
		if rising_edge(clk)then       --(divider(23))
		--if divider = 25e6 then	
			if CLK_ena = '1' then
			countsec := countsec + 1;
			if countsec = 60 then
				countsec := 0;
				countmin0 := countmin0 + 1;
				if countmin0 = 10 then
					countmin0 := 0;
					countmin1 := countmin1 + 1;
					if countmin1 = 6 then
						countmin1 := 0;
						counthr0 := counthr0 + 1;
						if counthr0 = 10 then
							counthr0 := 0;
							counthr1 := counthr1 + 1;
							if counthr1 = 3 then
								countmin0	:= 0;
								countmin1	:= 0;
								counthr0		:= 0;
								counthr1		:= 0;
							end if;
						end if;
					end if;
				end if;	
			end if;
		end if;
		--end if;
		end if;
		if reset = '1' then 	--Reset
			countsec	:=0;
			countmin0:=0;
			countmin1:=0;
			counthr0	:=0;
			counthr1	:=0;
		end if;		
		
			
			
	--Code für 7-Segment Anzeige

	--Für Sekunde
		if countsec mod 2 = 0 then
			sec <= '0'; --Zahl 0
			else sec <= '1';
			end if;
	
	
	--Für Minuten an Position 0
		case countmin0 is
			when 0 => min0 <= "1000000"; --Zahl 0
			when 1 => min0 <= "1111001"; --Zahl 1
			when 2 => min0 <= "0100100"; --Zahl 2
			when 3 => min0 <= "0110000"; --Zahl 3
			when 4 => min0 <= "0011001"; --Zahl 4
			when 5 => min0 <= "0010010"; --Zahl 5
			when 6 => min0 <= "0000010"; --Zahl 6
			when 7 => min0 <= "1111000"; --Zahl 7
			when 8 => min0 <= "0000000"; --Zahl 8
			when 9 => min0 <= "0010000"; --Zahl 9
			when others => min0 <= "1111111";
			end case;
			
	--Für Minuten an Position 1
		case countmin1 is
			when 0 => min1 <= "1000000"; --Zahl 0
			when 1 => min1 <= "1111001"; --Zahl 1
			when 2 => min1 <= "0100100"; --Zahl 2
			when 3 => min1 <= "0110000"; --Zahl 3
			when 4 => min1 <= "0011001"; --Zahl 4
			when 5 => min1 <= "0010010"; --Zahl 5
			when 6 => min1 <= "0000010"; --Zahl 6
			when others => min1 <= "1111111";
			end case;
			
	--Für Stunden an Position 0
		case counthr0 is
			when 0 => hr0 <= "1000000"; --Zahl 0
			when 1 => hr0 <= "1111001"; --Zahl 1
			when 2 => hr0 <= "0100100"; --Zahl 2
			when 3 => hr0 <= "0110000"; --Zahl 3
			when 4 => hr0 <= "0011001"; --Zahl 4
			when 5 => hr0 <= "0010010"; --Zahl 5
			when 6 => hr0 <= "0000010"; --Zahl 6
			when 7 => hr0 <= "1111000"; --Zahl 7
			when 8 => hr0 <= "0000000"; --Zahl 8
			when 9 => hr0 <= "0010000"; --Zahl 9
			when others => hr0 <= "1111111";
			end case;
	
	--Für Stunden an Position 1
		case counthr1 is
			when 0 => hr1 <= "1000000"; --Zahl 0
			when 1 => hr1 <= "1111001"; --Zahl 1
			when 2 => hr1 <= "0100100"; --Zahl 2
			when others => hr1 <= "1111111";
		end case;
		
	end process;
end beh_watch;
	