* VRTX32 header file

VRTX       EQU   $00   * VRTX32 trap number

* VRTX32 task-level function codes

SCFTCREATE   EQU $0000   * create task
SCFTDELETE   EQU $0001   * delete task
SCFTSUSPEND  EQU $0002   * suspend task
SCFTRESUME   EQU $0003   * resume task
SCFTPRIORITY EQU $0004   * change task priority
SCFTINQUIRY  EQU $0005   * task status inquiry
SCFGBLOCK    EQU $0006   * get memory block
SCFRBLOCK    EQU $0007   * release memory block
SCFPOST      EQU $0008   * post message to mailbox
SCFPEND      EQU $0009   * pend for message from mailbox
SCFGTIME     EQU $000A   * get time
SCFSTIME     EQU $000B   * set time
SCFTDELAY    EQU $000C   * task delay
SCFGETC      EQU $000D   * get character
SCFPUTC      EQU $000E   * put character
SCFWAITC     EQU $000F   * wait for special character
SCFTSLICE    EQU $0015   * enable round-robin scheduling
SCFFCREATE   EQU $0017   * create event flag group
SCFFDELETE   EQU $0018   * delete event flag group
SCFFPEND     EQU $0019   * pend on event flag group
SCFFPOST     EQU $001A   * post event to event flag group
SCFFCLEAR    EQU $001B   * clear event
SCFFINQUIRY  EQU $001C   * event flag group inquiry
SCFQJAM      EQU $001E   * jam message to queue
SCFQECREATE  EQU $001F   * create FIFO message queue
SCFLOCK      EQU $0020   * disable task rescheduling
SCFUNLOCK    EQU $0021   * enable task rescheduling
SCFPCREATE   EQU $0022   * create memory partition
SCFPEXTEND   EQU $0023   * extend memory partition
SCFACCEPT    EQU $0025   * accept message from mailbox
SCFQPOST     EQU $0026   * post message to queue
SCFQPEND     EQU $0027   * pend for message from queue
SCFQACCEPT   EQU $0028   * accept message from queue
SCFQCREATE   EQU $0029   * create message queue
SCFQINQUIRY  EQU $002A   * queue status inquiry
SCFSCREATE   EQU $002B   * create semaphore
SCFSDELETE   EQU $002C   * delete semaphore
SCFSPEND     EQU $002D   * pend on semaphore
SCFSPOST     EQU $002E   * post unit to semaphore
SCFSINQUIRY  EQU $002F   * semaphore inquiry

* VRTX32 interrupt-level function codes

UIFEXIT    EQU $0011   * exit interrupt handler
UIFTIMER   EQU $0012   * announce timer interrupt
UIFRXCHR   EQU $0013   * received-character interrupt
UIFTXRDY   EQU $0014   * transmit-ready interrupt
UIFENTER   EQU $0016   * enter interrupt handler

* VRTX32 initialization function codes

VRTXFINIT  EQU $0030   * initialize VRTX32
VRTXFGO    EQU $0031   * start application execution

* System-wide error codes

RET_OK     EQU $0000   * successful return

* VRTX32 error codes

ER_TID     EQU $0001   * task ID error
ER_TCB     EQU $0002   * no TCBs available
ER_MEM     EQU $0003   * no memory available
ER_NMB     EQU $0004   * not a memory block
ER_MIU     EQU $0005   * mailbox in use
ER_ZMW     EQU $0006   * zero message
ER_BUF     EQU $0007   * buffer full
ER_WTC     EQU $0008   * WAITC in progress
ER_ISC     EQU $0009   * invalid system call
ER_TMO     EQU $000A   * timeout
ER_NMP     EQU $000B   * no message present
ER_QID     EQU $000C   * queue ID error
ER_QFL     EQU $000D   * queue full
ER_PID     EQU $000E   * partition ID error
ER_INI     EQU $000F   * fatal initialization error
ER_NCP     EQU $0010   * no character present
ER_ICP     EQU $0011   * invalid config parameter during INIT
ER_IIP     EQU $0012   * invalid input parameter, PCREATE/PEXTEND
ER_CVT     EQU $0020   * component vector table not present
ER_COM     EQU $0021   * undefined component
ER_OPC     EQU $0022   * undefined opcode for component
ER_NOCB    EQU $0030   * no control blocks available
ER_ID      EQU $0031   * event flag group or semaphore ID error
ER_PND     EQU $0032   * tasks pending on ev flag group/semaphore
ER_DEL     EQU $0033   * event flag group or semaphore is deleted
ER_OVF     EQU $0034   * event flag already set or semaphore overflow

* TCB -- Task Control Block

           OFFSET  0
TBNEXT	   DS.L    1   * $00 reserved
TBLINK     DS.L    1   * $04 reserved
TBEXT      DS.L    1   * $08 pointer to user's TCB extension
TBPRI      DS.B    1   * $0C priority
TBID       DS.B    1   * $0D task ID number
TBSTAT     DS.W    1   * $0E status
TBD0       DS.L    1   * $10 saved D0
TBD1       DS.L    1   * $14 saved D1
TBD2       DS.L    1   * $18 saved D2
TBD3       DS.L    1   * $1C saved D3
TBD4       DS.L    1   * $20 saved D4
TBD5       DS.L    1   * $24 saved D5
TBA0       DS.L    1   * $28 saved A0
TBA1       DS.L    1   * $2C saved A1
TBA2       DS.L    1   * $30 saved A2
TBA3       DS.L    1   * $34 saved A3
TBSSP      DS.L    1   * $38 supervisor-mode stack pointer
TBUSP      DS.L    1   * $3C user-mode stack pointer
TBSTACK    DS.L    1   * $40 reserved (original stack pointer)
TBFLAGS    DS.W    1   * $44 reserved
TBDELAY    DS.L    1   * $46 reserved
TBQID      DS.W    1   * $4A reserved
TBRSV	   DS.L    1   * $4C reserved
TCBB       EQU   $50   * total size in bytes

* TBSTAT task status flags

TBSSUSP    EQU $0001   * explicitly suspended
TBSSUSPT   EQU     0
TBSMBOX    EQU $0002   * suspended for mailbox message
TBSMBOXT   EQU     1
TBSGETC    EQU $0004   * suspended for character input
TBSGETCT   EQU     2
TBSPUTC    EQU $0008   * suspended for character output
TBSPUTCT   EQU     3
TBSWAITC   EQU $0010   * suspended for special character
TBSWAITCT  EQU     4
TBSDELAY   EQU $0020   * suspended for task delay/timeout
TBSDELAYT  EQU     5
TBSQUEUE   EQU $0040   * suspended for queue message
TBSQUEUET  EQU     6
TBSRSV1    EQU $0080   * reserved
TBSRSV1T   EQU     7
TBSIDLE    EQU $0100   * idle task
TBSIDLET   EQU     8
TBSFLAG    EQU $0200   * suspended for event
TBSFLAGT   EQU     9
TBSSEMA    EQU $0400   * suspended for semaphore unit
TBSSEMAT   EQU    10

* CFTBL -- Configuration Table

           OFFSET  0
CFWSADDR   DS.L    1   * $00 VRTX32 workspace pointer
CFWSSIZE   DS.L    1   * $04 VRTX32 workspace size
CFSSTKSZ   DS.W    1   * $08 supervisor-mode stack size per task
CFISTKSZ   DS.W    1   * $0A ISR stack size, if enabled
CFCBCOUNT  DS.W    1   * $0C ev flag & semaphore control block count
CFRSRVD1   DS.W    1   * $0E reserved, must be zero
CFIDLE     DS.W    1   * $10 idle task stack size
CFRSRVD2   DS.W    1   * $12 reserved, must be zero
CFDISLEV   DS.W    1   * $14 component disable level
CFUSTKSZ   DS.W    1   * $16 user-mode stack size per task
CFRSRVD3   DS.L    1   * $18 reserved, must be zero
CFUTSKCT   DS.W    1   * $1C user task count
CFRSRVD4   DS.W    1   * $1E reserved, must be zero
CFTXRDY    DS.L    1   * $20 TXRDY driver routine pointer
CFTCREATE  DS.L    1   * $24 TCREATE routine pointer
CFTDELETE  DS.L    1   * $28 TDELETE routine pointer
CFTSWITCH  DS.L    1   * $2C TSWITCH routine pointer
CFCVTADDR  DS.L    1   * $30 component vector table pointer
CFTBLB     EQU   $34   * total size in bytes
