
*  VRTX Workspace Organization

           OFFSET  0
WXACT_F		DS.L 1		Forward pointer to a chain of all TCB's	of
*				active tasks
WXACT_R		DS.L 1 * $04	Backward pointer of the chain of the active
*				TCB's
WXEMTT		DS.L 1 * $08	empty TCB chain
WXEMTFLG	DS.L 1 * $0C	event flag control blocks
WXTRUN		DS.L 1 * $10	pointer to TCB of running task
WXTWAIT		DS.L 1 * $14	pointer to TCB waiting to run
WXSCNEST	DS.W 1 * $18	system call nesting counter
WXLOCK		DS.W 1 * $1A
WXTSLICE	DS.W 1 * $1C	time slice interval
WXREREQ		DS.B 1 * $1E	rescheduling request flag
		DS.B 1 * $1F
		DS.W 1 * $20
WXWAITC		DS.B 1 * $22	variable, holding the special character
		DS.B 1 * $23
WXWAITTCB	DS.L 1 * $24	pointer to TCB of task waiting for a sp. char
WXTCBMSK	DS.W 1 * $28	Task control block base pointer mask
		DS.W 1 * $2A		-- adjust to longword --
WXTCBPNT	DS.L 1 * $2C	Task control block table base pointer
WXMSQMSK	DS.W 1 * $30	Message queue control block pointer mask
		DS.W 1 * $32		-- adjust to longword --
WXMSQPNT	DS.L 1 * $34	Message queue control block base pointer
WXMBXMSK	DS.W 1 * $38	Mailbox control block pointer mask
		DS.W 1 * $3A		-- adjust to longword --
WXMBXPNT	DS.L 1 * $3C	Mailbox control block base pointer
WXMEMMSK	DS.W 1 * $40	memory partition control block mask.
		DS.W 1 * $42		-- adjust to longword --
WXMEMPNT	DS.L 1 * $44	Memory partition control block base pointer
		DS.L 1 * $48	not used
WXPRIPNT	DS.L 1 * $4C    Start address of pointer array for each prio
WXFLGCNT	DS.L 1 * $50	Number of free flag/semaph. control blocks
WXFLGPNT	DS.L 1 * $54	Pointer to flag/semaph. control block list
WXWPNT		DS.L 1 * $58	pointer to free VRTX workspace
WXFREE		DS.L 1 * $5C	byte count of free VRTX workspace
WXTXOFF		DS.B 1 * $60	flag indicating off state of transmitting channel
		DS.B 1				-- adjust to word --
WXTXRDY		DS.L 1 * $62	Address of txrdy routine
WXPRIMAP1	DS.W 16 * $66	high resolution priority bit map.
*				Each possible task priority has its own bit
*				in this map. There are 16*16 = 256 bits in
*				this map. The bit #15 in the first word is
*				for task priority 0 (the highest priority).
WXPRIMAP2	DS.W 1 * $86	low resolution priority bit map.
*				Each group of 16 task priorities has one
*				bit reserved in this map. The bit #15 is
*				for the priority group 0...15.
WXTCREAT	DS.L 1 * $88	t-create routine address
WXTDELET	DS.L 1 * $8C	t_delete routine address
WXTSWITCH	DS.L 1 * $90	t_switch routine address
WXINEST		DS.W 1 * $94	UI_enter nesting counter
WXISTEN		DS.B 1 * $96	flag indicating if ISR stack switching enabled
		DS.B 1 * $97		-- adjust to word --
WXISRSP		DS.L 1 * $98	ISR stack pointer
WXSSZ		DS.L 1 * $9C	system mode stack size per task
WXSRU		DS.W 1 * $A0	component disable level (user mode)
WXSRS		DS.W 1 * $A2	component disable level (system mode)
WXTIME		DS.L 1 * $A4	system time field
		DS.W 1 * $A8	-- not used --
WXTOADJ		DS.W 1 * $AA	counter of outstanding clock ticks for timeout
WXTOFLG		DS.L 1 * $AC	
WXTOPNT		DS.L 1 * $B0	forward pointer of timeout link chain
WXTOBAK		DS.L 1 * $B4	dummy backward pointer from timeout link 
WXICCNT		DS.W 1 * $B8	serial channel input buffer character count
WXIRX		DS.W 1 * $BA	serial channel input buffer read index
WXIWX		DS.W 1 * $BC	serial channel input buffer write index
		DS.W 1 * $BE	--- not used
WXGETTCB_F	DS.L 1 * $C0	forward pointer to TCB of task pending on getc
WXGETTCB_R	DS.L 1 * $C4	backward pointer of double linked TCB chain
*				for tasks pending on getc()
WXIBUF		DS.L 1 * $C8	serial channel input buffer base address
		DS.L 1 * $CC
		DS.L 1 * $D0
		DS.L 1 * $D4
WXOCCNT		DS.W 1 * $D8	serial channel output buffer character count
WXORX		DS.W 1 * $DA	serial channel output buffer read index
WXOWX		DS.W 1 * $DC	serial channel output buffer write index
		DS.W 1 * $DE
WXPUTTCB_F	DS.L 1 * $E0	forward pointer to TCB of task pending on putc
WXPUTTCB_R	DS.L 1 * $E4	backward pointer of double linked TCB chain
*				for tasks pending on putc()
WXOBUF		DS.L 1 * $E8	serial channel output buffer base address
		DS.L 1 * $EC
		DS.L 1 * $F0
		DS.L 1 * $F4
WXMCBEMT	DS.L 1 * $F8	points to a chain of empty MCB's
WXMCBDUM	DS.L 1 * $FC	a dummy mailbox control block
		DS.L 1 * $100
		DS.W 1 * $104
		DS.W 1 * $106
		DS.L 1 * $108
		DS.L 1 * $10C
		DS.L 1 * $110
		DS.L 1 * $114
		DS.L 1 * $118
WXIDLE		DS.L 1 * $11C	Task control block of idle task
		DS.L 1 * $120
		DS.L 1 * $124
		DS.L 1 * $128
		DS.W 1 * $12C
		DS.W 1 * $12E	priority of idle task ?
		DS.L 2 * $130
		DS.L 1 * $138
		DS.W 1 * $13C
		DS.W 1 * $13E
		DS.L 4 * $140
		DS.L 4 * $150
		DS.L 4 * $160
WXTOP		DS.L 1 * $170	pointer to top of free VRTX workspace
		DS.L 3 * $174
		DS.L 4 * $180
		DS.L 1 * $190
		DS.L 1 * $194
		DS.L 1 * $198
		DS.L 1 * $19C	start of temp storage used in t_create
		DS.L 4 * $1A0	$19C...$1AF used for D0...D4
		DS.W 1 * $1B0	temp. used for task status register
		DS.L 1 * $1B2	temp. used for task start addr
WXTMPTOP	DS.W 1 * $1B6	default top of temp. storage
		DS.L 1 * $1B8
		DS.L 1 * $1BC


* Offsets into initial VRTX32 stack frame

	OFFSET	0
STKD6	DS.L	1	D6 value for new task
STKD7	DS.L	1	D7 value for new task
STKA4	DS.L	1	A4 value for new task
STKA5	DS.L	1	A5 value for new task
STKA6	DS.L	1	A6 value for new task
STKSR	DS.W	1	SR value for new task
STKPC	DS.L	1	PC value for new task
STKFI	DS.L	1	fmt/ID word - 68010 only



* The different types of control blocks are sometimes linked together
* into the same chain. It is therefore important, that the link pointers
* can be found on a constant offset from previous link pointer.
* Because the structures of the control blocks are different, VRTX works
* always with a standardized access offset to access these pointers.
* This means, that pointers used in the control block linked chains
* are never pointers to the real physical location of the control blocks,
* but to a virtual structure, in which the offsets to the forward and
* backward pointers are constant. The following definition sets these offsets.

CBNEXT	equ	$14	virtual offset to forward link pointer
CBBACK	equ	$18	offset to backward link pointer

* The correction-offsets to adjust the physical control block address into
* a common virtual, compatible pointer access offset, working with above
* definitions, is dependent of the type of control block.
* Below are the adjustment value definitions for the various control blocks.
* To convert the physical control block address into the virtual link
* address, the following offsets have to be added to the physical addresses.

QCBOFF	equ	-2	link pointer offset for queue control blocks
SCBOFF	equ	-8	semaphore/flag control block offset
FCBOFF	equ	-8
MCBOFF	equ	-8	offset for mailbox control blocks

TOOFF	equ	-8	offset for access to timeout chain link pointer
*			within the TCB
* TCB -- Task Control Block offsets for internal use of VRTX

           OFFSET  0
XBBACK	DS.L	1   * $0	pointer back to ID-ordered TCB-pointer array
XBTOVAL	DS.L	1   * $04	timeout value
XBTOLNK	DS.L	1   * $08	timeout chain link pointer
XBTOBAK	DS.L	1   * $0C	timeout chain back pointer
	DS.W	1   * $10
XBPRIW	DS.B	1   * $12
XBPRI2	DS.B	1   * $13	also used to store a task priority
XTCBOFF
XBPRI_F	DS.L    1   * $14 	link pointer to next TCB with same priority
XBPRI_R	DS.L    1   * $18	backward pointer 
XBEXT	DS.L    1   * $1C	pointer to user's TCB extension
XBPRI	DS.B    1   * $20 	task priority
XBID	DS.B    1   * $21 	task ID number
XBSTAT	DS.W    1   * $22 	task status
XBD0	DS.L    1   * $24 	saved D0
XBD1	DS.L    1   * $28 	saved D1
XBD2	DS.L    1   * $2C 	saved D2
XBD3	DS.L    1   * $30 	saved D3
XBD4	DS.L    1   * $34 	saved D4
XBD5	DS.L    1   * $38 	saved D5
XBA0	DS.L    1   * $3C 	saved A0
XBA1	DS.L    1   * $40 	saved A1
XBA2	DS.L    1   * $44 	saved A2
XBA3	DS.L    1   * $48 	saved A3
XBSSP	DS.L    1   * $4C 	supervisor-mode stack pointer
XBUSP	DS.L    1   * $50 	user-mode stack pointer
XBSTACK	DS.L    1   * $54 	reserved (original stack pointer)
XBFLAGS	DS.W    1   * $58 	reserved
XBP2_F	DS.L    1   * $5A 	forward link pointer for active task chain
XBP2_R	DS.L    1   * $5E 	backward link pointer (chain of active tasks)
XBRSV	DS.W    1   * $62 	reserved
XBMCB	DS.L	1   * $64	pointer to a mailbox control block
XBQCB	DS.L	1   * $68	used for a queue control block
XBTICNT	DS.L	1   * $6C	Counter for task interruptions by system timer
XBTSLC	DS.W	1   * $70	Time slice interval counter
XBPMSK1	DS.L	1   * $72	Task priority encoded as two bit masks
XBPMSK2	DS.L	1   * $76	Priority dependent table addressing offsets


XCBB	EQU   $7A   * total size in bytes

* Memory Partition Control block structure definition

	OFFSET	0
PLINK	DS.L	1		pointer to next entry
PID	DS.W	1	4	partition ID
	DS.W	1
PBLSZ	DS.L	1	8	block size
PEXPNT	DS.L	1	C	pointer to memory partition extension list
	DS.L	1	10
PCBEND

* Partition Extension List entry structure definition

	OFFSET	0
PEXLINK	DS.L	1		pointer to next entry
PEXBEG	DS.L	1	4	partition extension memory start address
PEXEND	DS.L	1	8	partition extension memory end address
PEXBLCT	DS.W	1	C	partition extension block count
	DS.W	1	E
	DS.L	1	$10
	DS.L	1	$14
	DS.L	1	$18
	DS.W	1	$1C
PEXBLNK	DS.W	1	$1E	number of last released block
PEXBAT	DS.W	1	$20	begin of block allocation table (BAT)
* Queue directory entry structure definition

	OFFSET	0
QLINK	DS.L	1		pointer to next entry
QID	DS.W	1	4	partition ID
QSUSCNT	DS.W	1	6	number of tasks suspended on this queue
QLEN	DS.W	1	8	number of queue entries (count of messages)
QSIZ	DS.W	1	A	size of queue
QINDX	DS.W	1	C	index number of queue entry in front of queue
QWRINDX	DS.W	1	$E	write index number
	DS.W	1	$10
QCBNEXT	DS.L	1	$12	control block forward link pointer
QCBBACK	DS.L	1	$16	backward link pointer to previous control block
QPNDOPT	DS.W	1	$1A	queue pend order option
	DS.L	1	$1C
QMESS	DS.L	1	$20	start of message queue
QMESS1	DS.L	1	$24
QMESS2	DS.L	1	$28
QMESS3	DS.L	1	$2C
* Semaphore/ Event flag group control block structure

	OFFSET	0
SFID	DS.L	1		ECB/SCB identification number
SFTYPE	DS.L	1	$4	Control block type, 1 = event flag, 2 = semaph.
	DS.L	1	$8
SFBNEXT	DS.L	1	$C	formward link pointer to next control block
SFBBACK	DS.L	1	$10	backward link pointer to previous control block
SEMVAL
EVFLAGS	DS.W	1	$14	event flags / semaphore value
SPNDOPT	DS.W	1	$16	event flags / semaph. pend option

* Mailbox control block offset definition
	OFFSET	0
MBNEXT	DS.L	1	$0	link pointer yo next (empty) MCB
MBXADDR	DS.L	1	$4	address of mailbox
MBCOUNT	DS.W	1	$8	Number of tasks suspended on mailbox
	DS.W	1	$A
MCBNEXT	DS.L	1	$C	forward link pointer to next control block
MCBBACK	DS.L	1	$10	backward link pointer to previous control block
MBRES1	DS.L	1	$14
MBRES2	DS.L	1	$18
MBRES3	DS.L	1	$1C
