/*
 * MegaLoad low level functions.
 */

#include <avr/io.h>


//*********************************************************

workreg  = 18
wr0      = 0
wr1      = 1
wr30     = 30

#if __AVR_MEGA__
  #define XJMP jmp
  #define XCALL call
#else
  #define XJMP rjmp
  #define XCALL rcall
#endif

/*
#if define(__AVR_ATmega64__) || defined (__AVR_ATmega128__)
    SPMCR = 0x68
#else
    SPMCR = 0x57
#endif
*/

//-----------------------------------------

// void write_page (unsigned int adr, unsigned char function);
// bits 8:15 adr addresses the page...(must setup RAMPZ beforehand!!!)
.global write_page
.func write_page
write_page:
    XCALL __WAIT_SPMEN__
    movw    wr30, 24        // move address to z pointer (R31 = ZH, R30 = ZL)
    STS     SPMCR, 22       // argument 2 decides function
    SPM                     // perform pagewrite
    RET
.endfunc

//-----------------------------------------

// void fill_temp_buffer (unsigned int data, unsigned int adr);
// bits 7:1 in adr addresses the word in the page... (2=first word, 4=second word etc..)
.global fill_temp_buffer
.func fill_temp_buffer
fill_temp_buffer:
    push    wr1
    XCALL __WAIT_SPMEN__
    movw    wr30, 22      // move adress to z pointer (R31=ZH R30=ZL)
    movw    wr0, 24       // move data to reg 0 and 1
    LDI     workreg, 0x01
    STS     SPMCR, workreg
    SPM                   // Store program memory
    pop     wr1
    RET
.endfunc

//-----------------------------------------

// unsigned int read_program_memory (unsigned int adr ,unsigned char cmd);
.global read_program_memory
.func read_program_memory
read_program_memory:
    movw    wr30, 24        // move adress to z pointer
    SBRC    22, 0           // read lockbits? (second argument = 0x09)
    STS     SPMCR, 22       // if so, place second argument in SPMEN register
#if defined (__AVR_ATmega128__)
    ELPM    24, Z+          // read LSB
    ELPM    25, Z           // read MSB
#else
    LPM     24, Z+
    LPM     25, Z
#endif
    RET
.endfunc

//-----------------------------------------

// void write_lock_bits (unsigned char val);
.global write_lock_bits
.func write_lock_bits
write_lock_bits:
     MOV     wr0, 24
     LDI     workreg, 0x09
     STS     SPMCR, workreg
     SPM                    // write lockbits
     RET
.endfunc

//-----------------------------------------

.global enableRWW
.func enableRWW
enableRWW:
	XCALL __WAIT_SPMEN__
    LDI workreg, 0x11
    STS SPMCR, workreg
    SPM
    RET
.endfunc

//-----------------------------------------

.func __WAIT_SPMEN__
__WAIT_SPMEN__:
    LDS     workreg, SPMCR       // load SPMCR to R27
    SBRC    workreg, 0           // check SPMEN flag
    RJMP    __WAIT_SPMEN__       // wait for SPMEN flag cleared
    RET
.endfunc

//-----------------------------------------
