;################################################################
;#                                                              #
;#  AVR ChipBasic2 API V1.03 API Macros                         #
;#  (c) 2009 Joerg wolfram                                      #
;#                                                              #
;################################################################
.macro api_token
	call	0x001e
.endm

.macro api_untoken
	call	0x0020
.endm

.macro api_popxyz
	jmp	0x0022
.endm

.macro api_pushxyz
	call	0x0023
.endm

.macro api_popregs
	jmp	0x0024
.endm

.macro api_pushregs
	call	0x0025
.endm

.macro api_getvram
	call	0x0026
.endm

.macro api_getsysram
	call	0x0029
.endm

.macro api_getpal
	call	0x002c
.endm

.macro api_getarray
	call	0x002f
.endm

.macro api_getchart0
	call	0x0032
.endm

.macro api_getchart1
	call	0x0035
.endm

.macro api_getbuffer
	call	0x0038
.endm

.macro api_getvalues
	call	0x003b
.endm

.macro api_dataptr
	call	0x004d
.endm

.macro api_getbase
	call	0x004f
.endm

.macro api_setcolor
	call	0x0051
.endm

.macro api_setfcolor
	call	0x0053
.endm

.macro api_setborder
	call	0x0055
.endm

.macro api_setvmode
	call	0x0057
.endm

.macro api_setpalette
	call	0x0059
.endm

.macro api_sync
	call	0x005b
.endm

.macro api_slow
	call	0x005d
.endm

.macro api_fast
	call	0x005f
.endm

.macro api_setchannel
	call	0x0061
.endm

.macro api_setfont
	call	0x0063
.endm

.macro api_clrscr
	call	0x0065
.endm

.macro api_outchar
	call	0x0067
.endm

.macro api_outdez
	call	0x0069
.endm

.macro api_outhex
	call	0x006b
.endm

.macro api_gotoxy
	call	0x006d
.endm

.macro api_romtext
	call	0x006f
.endm

.macro api_thistext
	call	0x0071
.endm

.macro api_cbox
	call	0x0073
.endm

.macro api_ibox
	call	0x0076
.endm

.macro api_scroll
	call	0x0079
.endm

.macro api_newline
	call	0x007b
.endm

.macro api_clearvec
	call	0x007d
.endm

.macro api_cleartext
	call	0x007f
.endm

.macro api_sprite
	call	0x0081
.endm

.macro api_cursor
	call	0x0083
.endm

.macro api_waitkey
	call	0x0087
.endm

.macro api_nokey
	call	0x0089
.endm

.macro api_kstate
	call	0x008b
.endm

.macro api_getkey
	call	0x008f
.endm

.macro api_lastkey
	call	0x0092
.endm

.macro api_putser
	call	0x0095
.endm

.macro api_getser
	call	0x0097
.endm

.macro api_getserb
	call	0x0099
.endm

.macro api_putpar
	call	0x009b
.endm

.macro api_putxm
	call	0x009d
.endm

.macro api_getxm
	call	0x009f
.endm

.macro api_plot
	call	0x00a1
.endm

.macro api_draw
	call	0x00a3
.endm

.macro api_box
	call	0x00a5
.endm

.macro api_fbox
	call	0x00a7
.endm

.macro api_circle
	call	0x00a9
.endm

.macro api_fcircle
	call	0x00ad
.endm

.macro api_bcopy1
	call	0x00b1
.endm

.macro api_bcopy2
	call	0x00b3
.endm

.macro api_bcopy3
	call	0x00b5
.endm

.macro api_menu
	call	0x00b7
.endm

.macro api_drawmenu
	call	0x00b9
.endm

.macro api_alert
	call	0x00bb
.endm

.macro api_ask
	call	0x00bd
.endm

.macro api_alertthis
	call	0x00bf
.endm

.macro api_askthis
	call	0x00c1
.endm

.macro api_note
	call	0x00c3
.endm

.macro api_setvolume
	call	0x00c5
.endm

.macro api_startseq
	call	0x00c7
.endm

.macro api_setseq
	call	0x00c9
.endm

.macro api_getseq
	call	0x00cb
.endm

.macro api_i2c_read
	call	0x00cd
.endm

.macro api_i2c_write
	call	0x00cf
.endm

.macro api_i2c_start
	call	0x00d1
.endm

.macro api_i2c_stop
	call	0x00d3
.endm

.macro api_i2c_rbyte
	call	0x00d5
.endm

.macro api_i2c_rbyten
	call	0x00d7
.endm

.macro api_i2c_wbyte
	call	0x00d9
.endm

.macro api_i2c_rlm75
	call	0x00db
.endm

.macro api_eep_read
	call	0x00dd
.endm

.macro api_eep_write
	call	0x00df
.endm

.macro api_abs
	call	0x00e1
.endm

.macro api_add
	call	0x00e3
.endm

.macro api_sub
	call	0x00e5
.endm

.macro api_mul
	call	0x00e7
.endm

.macro api_div
	call	0x00e9
.endm

.macro api_sin
	call	0x00eb
.endm

.macro api_cos
	call	0x00ed
.endm

.macro api_eq
	call	0x00ef
.endm

.macro api_lt
	call	0x00f1
.endm

.macro api_gt
	call	0x00f3
.endm

.macro api_sqr
	call	0x00f5
.endm

.macro api_rnd
	call	0x00f7
.endm

.macro api_adc
	call	0x00f9
.endm

.macro api_dbit
	call	0x00fb
.endm

.macro api_fs_create
	call	0x00fd
.endm

.macro api_fs_delete
	call	0x00ff
.endm

.macro api_fs_read
	call	0x0101
.endm

.macro api_fs_write
	call	0x0103
.endm

.macro api_fs_cfree
	call	0x0105
.endm

.macro api_fs_size
	call	0x0107
.endm

.macro api_fs_checkf
	call	0x0109
.endm

.macro api_fs_gettype
	call	0x010b
.endm

.macro api_fs_rread
	call	0x010f
.endm

.macro api_fs_rwrite
	call	0x0114
.endm

.macro api_fs_fsize
	call	0x0119
.endm

.macro api_fs_ffind
	call	0x011b
.endm

.macro api_copychar4
	call	0x011d
.endm

.macro api_copychar6
	call	0x011f
.endm

.macro api_basrun
	call	0x0121
.endm

.macro api_exparser
	call	0x0123
.endm

