;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# block copy									#
;# copyright (c) 2007-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; bitblt routine
;------------------------------------------------------------------------------
libmio_bcopy:	push_regs			;save pointers
		push	tempreg5
		push	tempreg6
		push	tempreg7
		push	tempreg8
		push	r18			;vidmode
		ldi	YL,LOW(libmio_ram+50)
		ldi	YH,HIGH(libmio_ram+50)
		ldd	r18,Y+lmo_vidmode-50
		ldd	tempreg5,Y+(lmo_bcsrcx-50)	;get coordinates
		ldd	tempreg6,Y+(lmo_bcsrcy-50)
		ldd	tempreg7,Y+(lmo_bcdestx-50)
		ldd	tempreg8,Y+(lmo_bcdesty-50)
		ldd	tempreg2,Y+(lmo_bcdx-50)	;dx
		ldd	tempreg3,Y+(lmo_bcdy-50)	;dy

;calc lines/bytes
libmio_bcopy01:	mov	XL,r18			;get video mode
		andi	XL,0x03			;reduce to 3
		mov	ZL,tempreg2		;set dx
		lsl	tempreg3		;lines*2
		lsl	ZL			;pix*2
		cpi	XL,3			;vmode 3
		breq	libmio_bcopy02		;yes
		lsl	tempreg3		;lines*2
		lsl	ZL			;pix*2
		cpi	XL,2			;vmode 2
		breq	libmio_bcopy02		;yes
		lsl	tempreg3		;lines*2
		lsl	ZL			;pix*2
libmio_bcopy02:	mov	ZH,tempreg3		;set lines to ZH

;ZL=blocksize X ZH=blocksize Y
		lds	XL,libmio_bcmode	;get bcmode
		cpi	XL,0x01			;v->v
		brne	libmio_bcopy10		;no

;mode 1 (vmem->vmem)
		movw	YL,tempreg5		;check src coords
		rcall	libmio_bc_cs		;check
		cpi	ereg,0x00
		breq	libmio_bcopy04
libmio_bcopy03:	ldi	ereg,31			;src coords error
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy04:	movw	YL,tempreg7		;check dest coords
		rcall	libmio_bc_cs
		cpi	ereg,0x00
		breq	libmio_bcopy05		;error
		ldi	ereg,32			;dest coords error
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy05:	rcall	libmio_bc_vv		;start block copy
		rjmp	libmio_bcopy_e		;end

;mode 2 (vmem->mem)
libmio_bcopy10:	cpi	XL,0x02			;v->m
		brne	libmio_bcopy20		;no

		movw	YL,tempreg5		;check src coords
		rcall	libmio_bc_cs		;check
		cpi	ereg,0x00
		breq	libmio_bcopy11
		ldi	ereg,31			;src coords error
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy11:	movw	YL,tempreg7		;array pos
		rcall	libmio_bc_ac		;check for place in array
		cpi	ereg,0x00
		breq	libmio_bcopy12
		ldi	ereg,18			;out of array error
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy12:	ldi	XL,LOW(bas_array)	;base adr
		ldi	XH,HIGH(bas_array)
		add	tempreg7,XL		;calc block adr
		adc	tempreg8,XH
		rcall	libmio_bc_vm		;start block copy
		rjmp	libmio_bcopy_e		;end

;mode 3 (mem->vmem)
libmio_bcopy20:	cpi	XL,0x03			;m->v
		breq	libmio_bcopy21		;yes
		ldi	ereg,21			;no valid mode
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy21:	mov	XL,tempreg6		;array H
		cpi	XL,3
		brcs	libmio_bcopy22
		ldi	ereg,18
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy22:	ldi	XL,LOW(bas_array)	;base adr
		ldi	XH,HIGH(bas_array)
		add	tempreg5,XL		;calc block adr
		adc	tempreg6,XH
		movw	ZL,tempreg5		;set address
		ld	tempreg2,Z+		;copy bytes
		ld	tempreg3,Z+		;copy lines

		movw	YL,tempreg7		;check dst coords
		rcall	libmio_bc_cs		;check
		cpi	ereg,0x00
		breq	libmio_bcopy23
		ldi	ereg,32			;dest coords error
		rjmp	libmio_bcopy_e		;exit with error

libmio_bcopy23:	rcall	libmio_bc_mv		;start block copy

libmio_bcopy_e:	pop	r18
		pop	tempreg8		;restore registers
		pop	tempreg7
		pop	tempreg6
		pop	tempreg5
		pop_regs

;------------------------------------------------------------------------------
;check coordinates in YL/YH (blocksize is in ZL/ZH)
;------------------------------------------------------------------------------
libmio_bc_cs:	add	YL,ZL			;x+dx
		brcc	libmio_bc_cs1		;no overflow->OK

libmio_bc_cs0:	ldi	ereg,31			;c out of range
		ret				;end here

libmio_bc_cs1:	lds	XL,libmio_clipx2	;max X
		cp	YL,XL			;compare
		brcc	libmio_bc_cs0		;X is greater= max
		
		add	YH,ZH			;Y+dy
		brcs	libmio_bc_cs0		;overflow->error
		lds	XH,libmio_clipy2	;max Y
		cp	YH,XH			;compare
		brcc	libmio_bc_cs0		;Y is greater= max
		ret

;------------------------------------------------------------------------------
;check for place in array (Y=adr)
;------------------------------------------------------------------------------
libmio_bc_ac:	mul	tempreg3,tempreg2	;bytes*lines
		add	YL,r0
		adc	YH,r1
		adiw	YL,2			;place for coords
		cpi	YH,3			;HIGH
		brcs	libmio_bc_ac1
		ldi	ereg,18			;out of array
libmio_bc_ac1:	ret

;------------------------------------------------------------------------------
;get lines/bytes (PIX in ZL/ZH)
;------------------------------------------------------------------------------
libmio_bc_glb:	mov	XL,r18		;get video mode
		lds	tempreg2,libmio_bcdx	;dx
		lds	tempreg3,libmio_bcdy	;dy
		mov	ZL,tempreg2		;set dx
		lsl	tempreg3		;*2
		lsl	ZL
		cpi	XL,3			;vmode 3
		breq	libmio_bc_glb1		;yes
		lsl	tempreg3		;*2
		lsl	ZL
		cpi	XL,2			;vmode 2
		breq	libmio_bc_glb1		;yes
		lsl	tempreg3		;*2
		lsl	ZL
libmio_bc_glb1:	mov	ZH,tempreg3
		ret

;------------------------------------------------------------------------------
; vmem to vmem
; tempreg5,X1
; tempreg6,Y1
; tempreg7,X2
; tempreg8,Y2
; tempreg2 bytes
; tempreg3 lines
;------------------------------------------------------------------------------
libmio_bc_vv:	cp	tempreg6,tempreg8	;carry if (dest Y) > (src Y)
		brcs	libmio_bc_vv_2		;we must copy down->up
libmio_bc_vv_1:	movw	XL,tempreg5		;src coords
		rcall	libmio_bc_cadr		;calc addr
		ldi	ZL,LOW(bcopy_buffer)	;we use the bcopy buffer (temp)
		ldi	ZH,HIGH(bcopy_buffer)
		rcall	libmio_bcr		;copy to buffer
		movw	XL,tempreg7		;dst coords
		rcall	libmio_bc_cadr		;calc addr
		ldi	ZL,LOW(bcopy_buffer)	;we use the bcopy buffer (temp)
		ldi	ZH,HIGH(bcopy_buffer)
		rcall	libmio_bcl		;copy from buffer
		inc	tempreg6
		inc	tempreg8
		dec	tempreg3		;lines counter
		brne	libmio_bc_vv_1
		ret

libmio_bc_vv_2:	add	tempreg6,tempreg3	;set coords to last line
		add	tempreg8,tempreg3
		dec	tempreg6
		dec	tempreg8
libmio_bc_vv_3:	movw	XL,tempreg5		;src coords
		rcall	libmio_bc_cadr		;calc addr
		ldi	ZL,LOW(bcopy_buffer)	;we use the bcopy buffer (temp)
		ldi	ZH,HIGH(bcopy_buffer)
		rcall	libmio_bcr		;copy to buffer
		movw	XL,tempreg7		;dst coords
		rcall	libmio_bc_cadr		;calc addr
		ldi	ZL,LOW(bcopy_buffer)	;we use the bcopy buffer (temp)
		ldi	ZH,HIGH(bcopy_buffer)
		rcall	libmio_bcl		;copy from buffer
		dec	tempreg6
		dec	tempreg8
		dec	tempreg3		;lines counter
		brne	libmio_bc_vv_3
		ret

;------------------------------------------------------------------------------
; vmem to mem
; tempreg5,X2
; tempreg6,Y2
; tempreg7,ADRL
; tempreg8,ADRH
; tempreg2 bytes
; tempreg3 lines
;------------------------------------------------------------------------------
libmio_bc_vm:	movw	ZL,tempreg7		;set address
		st	Z+,tempreg2		;copy bytes
		st	Z+,tempreg3		;copy lines

libmio_bc_vm_1:	movw	XL,tempreg5		;src coords
		rcall	libmio_bc_cadr		;calc addr
		rcall	libmio_bcr		;copy to buffer
		inc	tempreg6		;line+1
		dec	tempreg3		;lines counter
		brne	libmio_bc_vm_1		;loop
		ret

;------------------------------------------------------------------------------
; mem to vmem
; tempreg5,X1
; tempreg6,Y1
; tempreg7,ADRL
; tempreg8,ADRH
;------------------------------------------------------------------------------
libmio_bc_mv:	movw	ZL,tempreg5		;set address
		ld	tempreg2,Z+		;copy bytes
		ld	tempreg3,Z+		;copy lines

libmio_bc_mv_1:	movw	XL,tempreg7		;dst coords
		rcall	libmio_bc_cadr		;calc addr
		rcall	libmio_bcl		;copy from buffer
		inc	tempreg8		;line+1
		dec	tempreg3		;lines counter
		brne	libmio_bc_mv_1
		ret

;------------------------------------------------------------------------------
;calc byte address of block to Y
;XL=X  XH=Y
;------------------------------------------------------------------------------
libmio_bc_cadr:	push	tempreg3		;save register
		ldi	YL,LOW(libmio_vram)	;base address
		ldi	YH,HIGH(libmio_vram)	
		cpi	r18,0x01
		brne	libmio_bc_cad0
		ldi	tempreg3,21		;bytes per line
		rjmp	libmio_bc_cad1
libmio_bc_cad0:	cpi	r18,0x05
		brne	libmio_bc_cad2
		ldi	tempreg3,16
libmio_bc_cad1:	mul	XH,tempreg3		;*Y
		add	YL,r0
		adc	YH,r1			
		mov	tempreg3,XL		;X
		lsr	tempreg3		;/8
		lsr	tempreg3
		lsr	tempreg3
		add	YL,tempreg3
		adc	YH,const_0
		mov	tempreg1,XL		;startbit
		pop	tempreg3		;restore register
		ret				;end
;mode2
libmio_bc_cad2:	cpi	r18,0x02		;mode 2?
		brne	libmio_bc_cad3
		ldi	tempreg3,30		;bytes per line
		mul	XH,tempreg3		;*Y
		add	YL,r0
		adc	YH,r1			
		mov	tempreg3,XL		;X
		lsr	tempreg3		;/4
		lsr	tempreg3
		add	YL,tempreg3
		adc	YH,const_0
		mov	tempreg1,XL		;startbit
		lsl	tempreg1		;*2
		pop	tempreg3		;restore register
		ret				;end
;mode3
libmio_bc_cad3:	ldi	tempreg3,42		;bytes per line
		mul	XH,tempreg3		;*Y
		add	YL,r0
		adc	YH,r1			
		mov	tempreg3,XL		;X
		lsr	tempreg3		;/2
		lsr	tempreg3
		add	YL,tempreg3
		adc	YH,const_0
		mov	tempreg1,XL		;startbit
		lsl	tempreg1		;*4
		lsl	tempreg1
		pop	tempreg3		;restore register
		ret				;end

;------------------------------------------------------------------------------
;copy routine with only right shift to byte aligned
;Y=src address
;Z=dst address
;tempreg1=startbit src
;tempreg2=number of bytes (1...)
;------------------------------------------------------------------------------
libmio_bcr:	push	tempreg4		;save registers
		push	tempreg3
		push	XH
		push	XL
		mov	tempreg3,tempreg2	;copy bytes
		mov	tempreg4,tempreg1	;copy startpos
		andi	tempreg4,0x07		;startbit
		brne	libmio_bcr_02
libmio_bcr_01:	ld	XL,Y+			;copy byte
		st	Z+,XL		
		dec	tempreg3		;loop counter
		brne	libmio_bcr_01		;loop if not all done
		rjmp	libmio_bcl_06

libmio_bcr_02:	ldi	XH,0x80
libmio_bcr_03:	cpi	tempreg4,0x01		;=1
		breq	libmio_bcr_04
		lsr	XH			;lsr factor
		dec	tempreg4
		rjmp	libmio_bcr_03		;loop

libmio_bcr_04:	clr	tempreg4		;byte counter
libmio_bcr_05:	ld	XL,Y+			;get src
		mul	XL,XH			;*factor
		cpi	tempreg4,0x00		;first
		breq	libmio_bcr_06		;yes
		ld	XL,-Z			;last dest
		or	XL,r0
		st	Z+,XL
libmio_bcr_06:	st	Z+,r1			;store r1
		inc	tempreg4
		cp	tempreg4,tempreg3	;last?
		brne	libmio_bcr_05		;no -> loop

		ld	XL,Y+			;get additional src
		mul	XL,XH			;*factor
		ld	XL,-Z			;last dest
		or	XL,r0
		st	Z+,XL
		rjmp	libmio_bcl_06

;------------------------------------------------------------------------------
;copy routine with only left shift from byte aligned
;Z=src address
;Y=dst address
;tempreg1=startbit dst
;tempreg2=number of bytes (1...)
;------------------------------------------------------------------------------
libmio_bcl:	push	tempreg4		;save registers
		push	tempreg3
		push	XH
		push	XL
		mov	tempreg3,tempreg2	;copy bytes
		mov	tempreg4,tempreg1	;copy startbit
		andi	tempreg4,0x07		;mask
		brne	libmio_bcl_02

libmio_bcl_01:	ld	XL,Z+			;copy byte
		st	Y+,XL		
		dec	tempreg3		;loop counter
		brne	libmio_bcl_01		;loop if not all done
		rjmp	libmio_bcl_06

libmio_bcl_02:	push	r16			;save registers
		push	r17
		ldi	r16,0xff		;mask
		ldi	r17,0x01		;factor
libmio_bcl_03:	lsl	r16			;shift mask
		lsl	r17			;factor *2
		dec	tempreg4
		brne	libmio_bcl_03

libmio_bcl_04:	mov	tempreg3,tempreg2	;copy bytes
		ld	tempreg4,Y		;get dst
		com	r16			;invert mask
		and	tempreg4,r16		;clear affected bits
		com	r16			;re-invert mask

libmio_bcl_05:	ld	XL,Z+			;get src byte
		mul	XL,r17			;*factor
		or	r0,tempreg4		;add bits from last action 
		st	Y+,r0			;write this byte
		mov	tempreg4,r1		;copy overflow to next byte
		dec	tempreg3		;dec byte counter
		brne	libmio_bcl_05		;loop

		ld	tempreg3,Y
		and	tempreg3,r16		;mask bits
		or	tempreg3,tempreg4	;add bits from last action 
		st	Y+,tempreg3
		pop	r16			;restore registers
		pop	r17
libmio_bcl_06:	pop	XL
		pop	XH
		pop	tempreg3
		pop	tempreg4
		ret				;end

libmio_bc1:	push_ptr
		movw	tempreg5,YL
		movw	tempreg7,ZL
		rcall	libmio_bc_vv
		pop_ptr

libmio_bc2:	push_ptr
		movw	tempreg5,YL
		movw	tempreg7,ZL
		rcall	libmio_bc_vm
		pop_ptr

libmio_bc3:	push_ptr
		movw	tempreg5,YL
		movw	tempreg7,ZL
		rcall	libmio_bc_mv
		pop_ptr

