;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# circles									#
;# copyright (c) 2005-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;circle routines
;libmio_costab	= cosinus table 255->0 256 values
;------------------------------------------------------------------------------
.ifdef use_libmio_circle
libmio_circle:	push_regs
		ldi	tempreg2,0x00		;init oldvalues
		ldi	tempreg3,0x00
		ldi	ZH,HIGH(libmio_costab*2)
		clr	ZL
		lds	YL,libmio_bcdx		;rx
		andi	YL,0x7f			;limit to 127
		lds	YH,libmio_bcdy		;ry
		andi	YH,0x7f			;limit to 127

libmio_ci_10:	lpm	tempreg1,Z		;cos
		mul	tempreg1,YL		;*rx
		mov	XL,r1			;new x offset
		com	ZL
		lpm	tempreg1,Z		;sin
		com	ZL
		mul	tempreg1,YH		;*ry
		mov	XH,r1			;new y offset
		cp	XL,tempreg2		;new X?
		brne	libmio_ci_12		;yes
		cp	XH,tempreg3		;new Y?
		brne	libmio_ci_12		;yes
		inc	ZL			;loop counter
		brne	libmio_ci_10		;loop
		rjmp	libmio_ci_14		;end

libmio_ci_12:	mov	tempreg2,XL		;set oldvalues
		mov	tempreg3,XH
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;Y0
		add	XL,tempreg2
		add	XH,tempreg3
		call	libmio_plot		;plot
		sub	XH,tempreg3
		sub	XH,tempreg3
		call	libmio_plot
		sub	XL,tempreg2
		sub	XL,tempreg2
		call	libmio_plot
		add	XH,tempreg3
		add	XH,tempreg3
		call	libmio_plot
		inc	ZL			;loop counter
		brne	libmio_ci_10		;loop
libmio_ci_14:	pop_regs

libmio_fcircle:	push_regs
		ldi	tempreg3,0xff		;init oldvalue Y
		ldi	ZH,HIGH(libmio_costab*2)
		clr	ZL
		lds	YL,libmio_bcdx		;rx
		andi	YL,0x7f			;limit to 127
		lds	YH,libmio_bcdy		;ry
		andi	YH,0x7f			;limit to 127

libmio_fci_10:	lpm	tempreg1,Z		;X
		mul	tempreg1,YL		;*rx
		mov	XL,r1			;new x offset
		com	ZL
		lpm	tempreg1,Z		;X
		com	ZL
		mul	tempreg1,YH		;*ry
		mov	XH,r1			;new y offset
		cp	XH,tempreg3		;new Y?
		brne	libmio_fci_12		;yes
		inc	ZL			;loop counter
		brne	libmio_fci_10		;loop
		rjmp	libmio_ci_14		;end

libmio_fci_12:	mov	tempreg2,XL		;set oldvalue X
		mov	tempreg3,XH		;set oldvalue y
		lds	XL,libmio_bcsrcx	;X0
		lds	XH,libmio_bcsrcy	;y0
		mov	tempreg4,XL		;copy x0
		sub	XH,tempreg3		;line Y
		sub	XL,tempreg2		;start X
		add	tempreg4,tempreg2	;end X
libmio_fci_14:	call	libmio_plot		;set pix
		add	XH,tempreg3
		add	XH,tempreg3
		call	libmio_plot		;set pix
		sub	XH,tempreg3		;line Y
		sub	XH,tempreg3		;line Y
		inc	XL
		cp	tempreg4,XL
		brcc	libmio_fci_14
		inc	ZL			;loop counter
		brne	libmio_fci_10		;loop
		rjmp	libmio_ci_14
.endif