;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# BASIC runtime engine								#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;-----------------------------------------------------------------------
; copy char matrix in mode 6
; tempreg1 = src char
; tempreg2 = dest char
; tempreg3 = color (nur bei mode 6)
;-----------------------------------------------------------------------
libmio_cpbits6:	push_regs
		ldi	XL,LOW(libmio_vram+690)
		ldi	XH,HIGH(libmio_vram+690)
		ldi	tempreg1,30
		andi	tempreg2,0x3f
		mul	tempreg1,tempreg2
		add	XL,r0
		adc	XH,r1
		lds	r0,libmio_color
		sts	libmio_color,tempreg3
		clr	tempreg2
		call	libmio_copyti
		sts	libmio_color,r0
		pop_regs


libmio_cpbits4:	push_regs
		mov	ZL,tempreg1		;src char
		ldi	ZH,HIGH(libmio_ctable*2)
		ldi	XL,0x80			;offset
		ldi	XH,0x07
		andi	tempreg2,0x7f
		add	XL,tempreg2
		ldi	tempreg2,0x0a
		ldi	tempreg3,0x80
libmio_cpb4_1:	lpm	tempreg1,Z
		st	X,tempreg1
		inc	ZH
		add	XL,tempreg3
		adc	XH,const_0
		dec	tempreg2
		brne	bas_lobmio_cpb4_1
		ret
