
;-----------------------------------------------------------------------
; set sequencer
; Y = start address
; Z = end address
; XL= speed
; XH= number of loops
;-----------------------------------------------------------------------
libmio_startsq:	push_ptr
		sts	libmio_seqstat,const_0	;stopp sequencer
		sts	libmio_seqstat,XH	;set number of loops
		sts	libmio_seqtick,const_1	;at first we must read data
		sts	libmio_seqcount,const_1	;at first we must read data
		sts	libmio_seql,YL
		sts	libmio_seqal,YL
		sts	libmio_seqh,YH
		sts	libmio_seqah,YH
		sts	libmio_seqbl,ZL
		sts	libmio_seqbh,ZH
libmio_ssq1:	sts	libmio_seqspeed,XL
libmio_ssq2:	sts	libmio_seqstat,XH	;status=running
		pop_ptr

libmio_setseq:	push_ptr
		mov	XH,XL
		rjmp	libmio_ssq2

libmio_getseq:	lds	XL,libmio_seqstat
		ret

