;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# video signal generation for editor						#
;# copyright (c) 2005-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;--------------------------------------------------------------------------------
;macro for char 1..5
;-------------------------------------------------------------------------------- 
.macro libmio_oc2a
		out	PORTC,tempreg3		;1 output P0 (=0)
		mov	r1,tempreg4		;1 get color
		sbrc	tempreg2,6		;1 skip if no change

		out	PINC,r1			;1 output P1
		mov	tempreg3,YL		;1 get color
		mov	tempreg4,YL		;1
		swap	tempreg4		;1
		sbrc	tempreg2,5		;1 skip if no change

		out	PINC,r1			;1 output P2
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		sbrc	tempreg2,4		;1 skip if no change

		out	PINC,r1			;1 output P3
		andi	ZL,0x7f			;1 mask bits
		nop				;1 filling
		sbrc	tempreg2,3		;1 skip if no change

		out	PINC,r1			;1 output P4
		lpm	r0,Z			;3 get pixline
		sbrc	tempreg2,2		;1 skip if no change

		out	PINC,r1			;1 output P5
		mov	tempreg2,r0		;1 prepare next pixline
		ld	ZL,X+			;2 get char

.endm

;--------------------------------------------------------------------------------
;macro for char 6..11
;-------------------------------------------------------------------------------- 
.macro libmio_oc2b
		out	PORTC,tempreg3		;1 output P0 (=0)
		mov	r1,tempreg4		;1 get color
		sbrc	tempreg2,6		;1 skip if no change

		out	PINC,r1			;1 output P1
		mov	tempreg3,YH		;1 get color
		mov	tempreg4,YH		;1
		swap	tempreg4		;1
		sbrc	tempreg2,5		;1 skip if no change

		out	PINC,r1			;1 output P2
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		sbrc	tempreg2,4		;1 skip if no change

		out	PINC,r1			;1 output P3
		andi	ZL,0x7f			;1 mask bits
		nop				;1 filling
		sbrc	tempreg2,3		;1 skip if no change

		out	PINC,r1			;1 output P4
		lpm	r0,Z			;3 get pixline
		sbrc	tempreg2,2		;1 skip if no change
				
		out	PINC,r1			;1 output P5
		mov	tempreg2,r0		;1 prepare next pixline
		ld	ZL,X+			;2 get char
.endm

;--------------------------------------------------------------------------------
;macro for char 12..17
;-------------------------------------------------------------------------------- 
.macro libmio_oc2c
		out	PORTC,tempreg3		;1 output P0 (=0)
		mov	r1,tempreg4		;1 get color
		sbrc	tempreg2,6		;1 skip if no change

		out	PINC,r1			;1 output P1
		mov	tempreg3,r16		;1 get color
		mov	tempreg4,r16		;1
		swap	tempreg4		;1
		sbrc	tempreg2,5		;1 skip if no change

		out	PINC,r1			;1 output P2
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		sbrc	tempreg2,4		;1 skip if no change

		out	PINC,r1			;1 output P3
		andi	ZL,0x7f			;1 mask bits
		nop				;1 filling
		sbrc	tempreg2,3		;1 skip if no change

		out	PINC,r1			;1 output P4
		lpm	r0,Z			;3 get pixline
		sbrc	tempreg2,2		;1 skip if no change

		out	PINC,r1			;1 output P5
		mov	tempreg2,r0		;1 prepare next pixline
		ld	ZL,X+			;2 get char
.endm

;--------------------------------------------------------------------------------
;macro for char 18..23
;-------------------------------------------------------------------------------- 
.macro libmio_oc2d
		out	PORTC,tempreg3		;1 output P0 (=0)
		mov	r1,tempreg4		;1 get color
		sbrc	tempreg2,6		;1 skip if no change

		out	PINC,r1			;1 output P1
		mov	tempreg3,r17		;1 get color
		mov	tempreg4,r17		;1
		swap	tempreg4		;1
		sbrc	tempreg2,5		;1 skip if no change

		out	PINC,r1			;1 output P2
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		sbrc	tempreg2,4		;1 skip if no change

		out	PINC,r1			;1 output P3
		andi	ZL,0x7f			;1 mask bits
		nop				;1 filling
		sbrc	tempreg2,3		;1 skip if no change

		out	PINC,r1			;1 output P4
		lpm	r0,Z			;3 get pixline
		sbrc	tempreg2,2		;1 skip if no change

		out	PINC,r1			;1 output P5
		mov	tempreg2,r0		;1 prepare next pixline
		ld	ZL,X+			;2 get char
.endm

;--------------------------------------------------------------------------------
;macro for char 18..23
;-------------------------------------------------------------------------------- 
.macro libmio_oc2e
		out	PORTC,tempreg3		;1 output P0 (=0)
		mov	r1,tempreg4		;1 get color
		sbrc	tempreg2,6		;1 skip if no change

		out	PINC,r1			;1 output P1
		mov	tempreg3,r18		;1 get color
		mov	tempreg4,r18		;1
		swap	tempreg4		;1
		sbrc	tempreg2,5		;1 skip if no change

		out	PINC,r1			;1 output P2
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		sbrc	tempreg2,4		;1 skip if no change

		out	PINC,r1			;1 output P3
		andi	ZL,0x7f			;1 mask bits
		nop				;1 filling
		sbrc	tempreg2,3		;1 skip if no change

		out	PINC,r1			;1 output P4
		lpm	r0,Z			;3 get pixline
		sbrc	tempreg2,2		;1 skip if no change

		out	PINC,r1			;1 output P5
		mov	tempreg2,r0		;1 prepare next pixline
		ld	ZL,X+			;2 get char
.endm


;-------------------------------------------------------------------------------
; -output character line 4 clocks per pixel
; -256 characters are in table 6x12px each
;-------------------------------------------------------------------------------
libmio_tvm:	lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high
		lds	YL,libmio_elcolor	;2 recent line color
		mov	YH,vline_l		;1 get pixel line
		ldi	ZH,HIGH(libmio_ctable*2);start chartable
		lds	ZL,libmio_cline		;2 character line
		add	ZH,ZL			;1
		inc	ZL			;1 cline+1
		sts	libmio_cline,ZL		;2 store back character line
		cpi	ZL,10
		brcs	libmio_tvm5		;a visible line
		cpi	ZL,12
		brne	libmio_tvm4
		adiw	XL,35			;1 next line
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
		sts	libmio_cline,const_0	;2 clear cline


libmio_tvm1:	cpi	YH,12			;1 start of second line
		brne	libmio_tvm2		;no
		lds	YH,libmio_estatus	;get color of status line
libmio_tvm1a:	sts	libmio_elcolor,YH
		jmp	libmio_is_15



libmio_tvm2:	cpi	YH,24			;1 last of head
		brne	libmio_tvm3
		ldi	XL,LOW(libmio_vram+3*libmio_ecols)
		ldi	XH,HIGH(libmio_vram+3*libmio_ecols)
		lds	YL,libmio_edstart
		ldi	YH,libmio_ecols
		mul	YL,YH
		add	XL,r0
		adc	XH,r1
		ldi	YL,0x0e			;1 dark white on black
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
		sts	libmio_elcolor,YL
		jmp	libmio_is_15


libmio_tvm3:	cpi	YH,216			;start of help line
		brne	libmio_tvm4
		ldi	YL,0x4b			;white on red
		ldi	XL,LOW(libmio_vram+2*libmio_ecols)
		ldi	XH,HIGH(libmio_vram+2*libmio_ecols)
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
		sts	libmio_elcolor,YL
libmio_tvm4:	jmp	libmio_is_15

libmio_tvm5:	push	r16
		push	r17
		push	r18
		cpi	YH,216
		brcc	libmio_tvm6
		mov	YH,YL			;copy color
		mov	r16,YL			;copy color
		mov	r17,YL			;copy color
		mov	r18,YL			;copy color
		rjmp	libmio_tvm7

libmio_tvm6:	ldi	r18,0x68		;white on magenta
		ldi	r17,0x2c		;white on blue
		ldi	r16,0x88		;black on green
		ldi	YH,0xcc			;black on yellow
		ldi	YL,0x4a			;white on red


libmio_tvm7:	mov	tempreg3,YL		;1 get color 1
		mov	tempreg4,YL		;1 get cdiff 1
		swap	tempreg4		;1
		ld	ZL,X+			;2 get char
		sbrc	ZL,7			;1 skip if no invert
		eor	tempreg3,tempreg4	;1
		andi	ZL,0x7f			;1 mask bits
		lpm	tempreg2,Z		;3 get pixline
		ld	ZL,X+			

		libmio_oc2a			;char 1
		libmio_oc2a			;char 2
		libmio_oc2a			;char 3
		libmio_oc2a			;char 4
		libmio_oc2a			;char 5
		libmio_oc2a			;char 6
		libmio_oc2b			;char 7
		libmio_oc2b			;char 8
		libmio_oc2b			;char 9
		libmio_oc2b			;char 10
		libmio_oc2b			;char 11
		libmio_oc2b			;char 12
		libmio_oc2b			;char 13
		libmio_oc2c			;char 14
		libmio_oc2c			;char 15
		libmio_oc2c			;char 16
		libmio_oc2c			;char 17
		libmio_oc2c			;char 18
		libmio_oc2c			;char 19
		libmio_oc2d			;char 20
		libmio_oc2d			;char 21
		libmio_oc2d			;char 22
		libmio_oc2d			;char 23
		libmio_oc2d			;char 24
		libmio_oc2d			;char 25
		libmio_oc2d			;char 26
		libmio_oc2d			;char 27
		libmio_oc2e			;char 28
		libmio_oc2e			;char 29
		libmio_oc2e			;char 30
		libmio_oc2e			;char 31
		libmio_oc2e			;char 32
		libmio_oc2e			;char 33
		libmio_oc2e			;char 34
		libmio_oc2e			;char 35
		out	PORTC,const_0		;1 set to border
		pop	r18
		pop	r17
		pop	r16
		jmp	libmio_is_15

