;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# viedo mode 7 engine								#
;# copyright (c) 2005-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;-------------------------------------------------------------------------------
; -output character lines and vector area, 9 clocks per pixel
;-------------------------------------------------------------------------------
;upper text line
libmio_tvx_t1:	ldi	XL,LOW(libmio_vram)	;1
		ldi	XH,HIGH(libmio_vram)	;1
		ldi	YL,LOW(libmio_vram+60)	;1
		ldi	YH,HIGH(libmio_vram+60)	;1
		sts	libmio_cline,vline_l	;2
		jmp	libmio_tvc_0		;3

;lower text line
libmio_tvx_t2:	ldi	XL,LOW(libmio_vram+30)	;1
		ldi	XH,HIGH(libmio_vram+30)	;1
		ldi	YL,LOW(libmio_vram+90)	;1
		ldi	YH,HIGH(libmio_vram+90)	;1
		subi	tempreg1,210		;1
		sts	libmio_cline,tempreg1	;2
		jmp	libmio_tvc_0		;3

libmio_tvx:	mov	tempreg1,vline_l	;1
		subi	tempreg1,10		;1
		brcc	libmio_tvx_01		;1/2
		rjmp	libmio_tvx_t1		;2 upper text line
libmio_tvx_01:	cpi	tempreg1,210		;1
		brcs	libmio_tvx_02		;1/2
		rjmp	libmio_tvx_t2		;2 lower text line
libmio_tvx_02:	;jmp	libmio_is_15		;DEBUG
		ldi	tempreg2,24		;1
		lsr	tempreg1		;1
		ldi	XL,LOW(libmio_vram+120)	;1
		ldi	XH,HIGH(libmio_vram+120);1
		add	XL,tempreg1		;1
		adc	XH,const_0		;1
		ld	tempreg1,X		;2
		mul	tempreg1,tempreg2	;1
		ldi	XL,LOW(libmio_vram+225)	;1
		ldi	XH,HIGH(libmio_vram+225);1
		add	XL,r0			;1
		adc	XH,r1			;1
		ldi	YL,159			;1 set initial counter

;set 1
		ld	tempreg1,X+		;2 position
		ld	tempreg2,X+		;value
libmio_tvx_10:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_11		;2
		nop				;1
		nop				;1
		nop				;1
		cp	YL,const_0		;1
		brne	libmio_tvx_10		;2
		rjmp	libmio_tvx_e

;set 2
libmio_tvx_11:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_12:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_13		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_12		;2
		rjmp	libmio_tvx_e

;set 3
libmio_tvx_13:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
libmio_tvx_14:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_15		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_14		;2
		rjmp	libmio_tvx_e

;set 4
libmio_tvx_15:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_16:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_17		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_16		;2
		rjmp	libmio_tvx_e

;set 5
libmio_tvx_17:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
libmio_tvx_18:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_19		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_18		;2
		rjmp	libmio_tvx_e

;set 6
libmio_tvx_19:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_20:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_21		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_20		;2
		rjmp	libmio_tvx_e

;set 7
libmio_tvx_21:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
libmio_tvx_22:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_23		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_22		;2
		rjmp	libmio_tvx_e

;set 8
libmio_tvx_23:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_24:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_25		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_24		;2
		rjmp	libmio_tvx_e

;set 9
libmio_tvx_25:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
libmio_tvx_26:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_27		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_26		;2
		rjmp	libmio_tvx_e

;set 10
libmio_tvx_27:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_28:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_29		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_28		;2
		rjmp	libmio_tvx_e


;set 11
libmio_tvx_29:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
libmio_tvx_30:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_31		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_30		;2
		rjmp	libmio_tvx_e

;set 12
libmio_tvx_31:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
libmio_tvx_32:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	libmio_tvx_33		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_32		;2
		rjmp	libmio_tvx_e


;set 12x
libmio_tvx_33:	nop
		nop
		out	PORTC,tempreg3		;1 set cvalue
		nop
		nop
libmio_tvx_34:	inc	YL			;1
		cp	YL,tempreg1		;1
		nop
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	libmio_tvx_34		;2
		rjmp	libmio_tvx_e

libmio_tvx_e:
;the end
libmio_tvx_1x:	lds	tempreg2,libmio_border	;2
		nop
		nop
		out	PORTC,tempreg2		;1
		rjmp	libmio_is_15


