;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# xmodem library								#
;# copyright (c) 2005-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
		
;-----------------------------------------------------------------------------
; read XMODEM block, tempreg3=blocknum, Y=address
;-----------------------------------------------------------------------------
libmio_rxbl:	push	tempreg1
		push	tempreg2
		push	tempreg4
libmio_rxbl_lo:	rcall	libmio_gserb			;get char
		cpi	tempreg1,0x1b			;ESC
		brne	libmio_rxbl_0			;no
		ldi	ereg,1				;break
		rjmp	libmio_rxbl_03			;end

libmio_rxbl_0:	cpi	tempreg1,0x01			;SOH
		brne	libmio_rxbl_lo			;end with error
		rcall	libmio_gser			;next char=block num
		mov	tempreg3,tempreg1
		rcall	libmio_gser			;next char=inv block num
		com	tempreg1
		cp	tempreg3,tempreg1		
		breq	libmio_rxbl_01			;OK
libmio_rxbl_00:	ldi	ereg,40				;error
		rjmp	libmio_rxbl_03			;end

libmio_rxbl_01:	ldi	tempreg4,128			;num of bytes
		clr	tempreg2			;checksum
libmio_rxbl_02:	rcall	libmio_gser			;get data byte
		add	tempreg2,tempreg1
		st	Y+,tempreg1
		dec	tempreg4
		brne	libmio_rxbl_02
		rcall	libmio_gser			;get checksum byte
		cp	tempreg1,tempreg2		;OK
		brne	libmio_rxbl_04
		clr	ereg				;OK
libmio_rxbl_03:	pop	tempreg4
		pop	tempreg2
		pop	tempreg1
		ret

libmio_rxbl_04:	ldi	ereg,41				;checksum error
		rjmp	libmio_rxbl_03

;-----------------------------------------------------------------------------
; write XMODEM block, tempreg3=blocknum, Y=address
;-----------------------------------------------------------------------------
libmio_txbl:	push	tempreg1
		push	tempreg2
		push	tempreg4
		ldi	tempreg1,0x01			;SOH
		rcall	libmio_pser			;out
		mov	tempreg1,tempreg3
		rcall	libmio_pser			;blocknum
		com	tempreg1
		rcall	libmio_pser			;inv. blocknum

libmio_txbl_01:	ldi	tempreg4,128			;num of bytes
		clr	tempreg2			;checksum
libmio_txbl_02:	ld	tempreg1,Y+
		add	tempreg2,tempreg1
		rcall	libmio_pser			;get data byte
		dec	tempreg4
		brne	libmio_txbl_02
		mov	tempreg1,tempreg2		;copy checksum
		rcall	libmio_pser			;out checksum byte
libmio_txbl_03:	rjmp	libmio_rxbl_03
