;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# array functions								#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################


;-----------------------------------------------------------------------
; read array value
;-----------------------------------------------------------------------
arr_read1:	movw	tempreg1,YL

arr_read:	push	YL
		push	YH
		lds	tempreg1,bas_ram+10	;index low
		lds	tempreg2,bas_ram+11	;index high
arr_read_2:	rcall	arr_acalc		;calc address
		ld	XL,Y+
		clr	XH
		brtc	arr_read_3
		ld	XH,Y+
arr_read_3:
; increment array pointer
		lds	r0,bas_ram+10		;index low
		lds	r1,bas_ram+11		;index high
		add	r0,const_1		;+1
		adc	r1,const_0
		sts	bas_ram+10,r0		;write back
		sts	bas_ram+11,r1
		pop	YH
		pop	YL
		ret

;-----------------------------------------------------------------------
; write array value
;-----------------------------------------------------------------------
arr_write:	push	YL
		push	YH
		lds	tempreg1,bas_partab	;index low
		lds	tempreg2,bas_partab+1	;index high
arr_write_2:	rcall	arr_acalc		;calc address
		st	Y+,XL
		brtc	arr_write_3
		st	Y+,XH
arr_write_3:
; increment array pointer2
arr_incp2:	lds	r0,bas_partab		;index low
		lds	r1,bas_partab+1		;index high
		add	r0,const_1		;+1
		adc	r1,const_0
		sts	bas_partab,r0		;write back
		sts	bas_partab+1,r1
		pop	YH
		pop	YL
		ret

;-----------------------------------------------------------------------
; calc address (tempreg1/2=element)
;-----------------------------------------------------------------------
arr_acalc:	ldi	YH,high(bas_array)	;array
		ldi	YL,low(bas_array)
		cpi	tempreg2,0x03		;limit
		breq	arr_acalc_e		;is between byte and word
		brcc	arr_acalc_2		;word?
		clt				;byte access
arr_acalc_1:	add	YL,tempreg1		;array element address
		adc	YH,tempreg2
		ret 

arr_acalc_2:	set				;word access
		subi	tempreg1,LOW(1024)
		sbci	tempreg2,HIGH(1024)
		lsl	tempreg1		;*2
		rol	tempreg2
		cpi	tempreg2,0x03
		brcs	arr_acalc_1
arr_acalc_e:	pop	tempreg1		;kill stack
		pop	tempreg1
		ldi	ereg,18			;out of array
		ret


