;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# system clone									#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;------------------------------------------------------------------------------
;clone flash
;------------------------------------------------------------------------------
clone_main:	libmio_askthis
		.db	0x6f,"Clone system? ",0
		cpi	tempreg1,0x01
		breq	clone_main_1
		ret
			
clone_main_1:	rcall	clone_init		;init
		rcall	clone_pen		;programm enable
		cpi	ereg,0x00
		breq	clone_main_2
		rcall	clone_exit
		libmio_alertthis
		.db	0x4f,"No controller found ",0
		ret
		
clone_main_2:	rcall	clone_rsb		;read signature bytes
		cpi	ereg,0x00
		breq	clone_main_3
		rcall	clone_exit
		libmio_alertthis
		.db	0x4f,"No Mega644 found",0
		ret

;erase chip
clone_main_3:	rcall	clone_wal		;draw alert box
		rcall	clone_era		;erase chip

;program flash
		clr	ZL			;clear pointer
		clr	ZH
		ldi	tempreg2,0x00		;page counter
clone_main_4:	ldi	tempreg3,0x00		;word counter
clone_main_5:	lpm	r0,Z+			;low byte
		rcall	clone_lobyte		;write
		lpm	r0,Z+			;high byte
		rcall	clone_hibyte		;write
		inc	tempreg3		;word counter3
		cpi	tempreg3,0x80		;end of page
		brne	clone_main_5		;word loop
		rcall	clone_wpage		;write page
		inc	tempreg2		;next page
		brne	clone_main_4		;page loop
;program low fuse
		ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0xa0		;byte2
		rcall	clone_czbyte		;byte3
		ldi	tempreg1,0xe6		;low fuse byte
		rcall	clone_cbyte
		rcall	clone_wait

;program high fuse
		ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0xa8		;byte2
		rcall	clone_czbyte		;byte3
		ldi	tempreg1,0xd1		;high fuse byte
		rcall	clone_cbyte
		rcall	clone_wait
;program extended fuse
		ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0xa4		;byte2
		rcall	clone_czbyte		;byte3
		ldi	tempreg1,0xfc		;ext fuse byte
		rcall	clone_cbyte
		rcall	clone_wait

		rcall	clone_exit
		libmio_alertthis
		.db	0x80,"System cloned",0,0
		ret

;------------------------------------------------------------------------------
; init SPI and activate reset
;------------------------------------------------------------------------------
clone_init:	ldi	tempreg1,0x53		;config
		out	SPCR0,tempreg1		;set spi
		out	SPSR0,const_0		;x2=0
		sbi	DDRB,4			;output
		cbi	PORTB,4			;start (reset)
		ldi	tempreg1,0xff
clone_init1:	dec	tempreg1
		brne	clone_init1
		sbi	PORTB,4			;stop (reset)
		ldi	tempreg1,0xff
clone_init2:	dec	tempreg1
		brne	clone_init2
		cbi	PORTB,4			;start (reset)
		ldi	tempreg1,0xff
clone_init3:	dec	tempreg1
		brne	clone_init3
		cbi	PORTB,4			;start (reset)
		ldi	tempreg1,0xff
clone_init4:	dec	tempreg1
		brne	clone_init4
		libmio_sync
		ret

;------------------------------------------------------------------------------
; deactivate reset and reconfigure SPI
;------------------------------------------------------------------------------
clone_exit:	sbi	PORTB,4			;end (deactivate reset)
		ldi	tempreg1,0x5c		;config
		out	SPCR0,tempreg1		;set spi
		out	SPSR0,const_1		;x2=1
		ret

;------------------------------------------------------------------------------
; send byte
;------------------------------------------------------------------------------
clone_czbyte:	rjmp	clone_zbyte
clone_zbyte:	clr	tempreg1
clone_cbyte:	out	SPDR0,tempreg1
clone_cbyte_1:	in	tempreg1,SPSR0
		sbrs	tempreg1,SPIF0
		rjmp	clone_cbyte_1
		in	tempreg1,SPDR0
		ret

;------------------------------------------------------------------------------
; enable programming
;------------------------------------------------------------------------------
clone_pen:	clr	ereg			;no error
		ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0x53		;byte2
		rcall	clone_czbyte		;byte 3
		cpi	tempreg1,0x53		;echo OK
		breq	clone_pen_1
		ldi	ereg,0x01		;no sync
clone_pen_1:	rcall	clone_zbyte		;byte 4 and end
		ret

clone_vc:	push	XH
		push	XL
		push	tempreg1
		mov	XL,tempreg1
		clr	XH
		libmio_outhex
		libmio_outspace
		pop	tempreg1
		pop	XL
		pop	XH
		ret

;------------------------------------------------------------------------------
; read signature bytes
;------------------------------------------------------------------------------
clone_rsb:	clr	ereg			;no error
		ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x00		;adr 0
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x1e		;ID OK
		breq	clone_rsb_1
		ldi	ereg,0x02		;ID not OK
		ret

clone_rsb_1:	ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x01		;adr 1
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x96		;ID OK
		breq	clone_rsb_2
		ldi	ereg,0x02		;ID not OK
		ret

clone_rsb_2:	ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x02		;adr 1
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x09		;ID OK
		breq	clone_rsb_3
		cpi	tempreg1,0x0a		;ID OK
		breq	clone_rsb_3
		ldi	ereg,0x02		;ID not OK
clone_rsb_3:	ret

;------------------------------------------------------------------------------
; erase chip
;------------------------------------------------------------------------------
clone_era:	ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0x80		;byte2
		rcall	clone_czbyte		;byte 2+3
		rcall	clone_zbyte		;byte 4 and end
		rjmp	clone_wait

;------------------------------------------------------------------------------
; write page
;------------------------------------------------------------------------------
clone_wpage:	ldi	tempreg1,0x4c		;byte1
		rcall	clone_cbyte
		clr	tempreg4
		mov	tempreg1,tempreg2	;page number
		lsr	tempreg1		;/2
		ror	tempreg4
		rcall	clone_cbyte
		mov	tempreg1,tempreg4
		rcall	clone_czbyte		;byte 3+4
		rjmp	clone_wait

;------------------------------------------------------------------------------
; write low byte
;------------------------------------------------------------------------------
clone_lobyte:	ldi	tempreg1,0x40		;byte1
		rcall	clone_czbyte		;byte 1+2
		mov	tempreg1,tempreg3	;word number
		rcall	clone_cbyte
		mov	tempreg1,r0
		rjmp	clone_cbyte		;byte 4 and end

;------------------------------------------------------------------------------
; write high byte
;------------------------------------------------------------------------------
clone_hibyte:	ldi	tempreg1,0x48		;byte1
		rcall	clone_czbyte		;byte 1+2
		mov	tempreg1,tempreg3	;word number
		rcall	clone_cbyte
		mov	tempreg1,r0
		rjmp	clone_cbyte		;byte 4 and end

;------------------------------------------------------------------------------
;write-alertbox
;------------------------------------------------------------------------------
clone_wal:	push_regs
		lds	tempreg1,libmio_color	;old color
		sts	bas_partab+9,tempreg1	;save
		ldi	tempreg1,0x4c		;yellow on red
		sts	libmio_color,tempreg1	;set new color
		ldi	YL,5
		ldi	YH,10
		ldi	ZL,24
		ldi	ZH,12
		libmio_wbox			;draw window
		libmio_thistext
		.db 	11,6,"Cloning System...",0
		lds	tempreg1,bas_partab+9
		sts	libmio_color,tempreg1	;restore old color
		pop_regs

;------------------------------------------------------------------------------
;wait a little bit
;------------------------------------------------------------------------------
clone_wait:	ldi	tempreg3,4
clone_wait_1:	libmio_sync
		dec	tempreg3
		brne	clone_wait_1
		ret
