;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# line compressor								#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-----------------------------------------------------------------------
; compress inbuf->linebuf (Y->X)
;-----------------------------------------------------------------------
clin_main:
;fill code buffer with 0xff
		ldi	XL,LOW(bas_linebuf)	;code buffer address
		ldi	XH,HIGH(bas_linebuf)
		ldi	tempreg1,0xff
		ldi	tempreg2,0x22
clin_main_clr:	st	X+,tempreg1
		dec	tempreg2
		brne	clin_main_clr

;find last active char in line and set pos to tempreg5
		ldi	YL,LOW(bas_inbuf+32)	;text buffer address
		ldi	YH,HIGH(bas_inbuf+32)
		ldi	tempreg1,32		;last pos +1
clin_main_fend:	ld	tempreg2,-Y		;get char
		cpi	tempreg2,0x20		;space
		brne	clin_main_fen1
		dec	tempreg1
		brne	clin_main_fend
clin_main_fen1:	mov	tempreg5,tempreg1
;now start compressing
		ldi	XL,LOW(bas_linebuf)	;code buffer address
		ldi	XH,HIGH(bas_linebuf)
		ldi	YL,LOW(bas_inbuf)	;text buffer address
		ldi	YH,HIGH(bas_inbuf)
		add	tempreg5,YL		;stopp byte

clin_main_01:	cpi	XL,LOW(bas_linebuf+32)
		brcc	clin_main_end
		cp	YL,tempreg5
		brcc	clin_main_end
		ld	tempreg1,Y		;get char
		cpi	tempreg1,0x00		;end
		brne	clin_main_02
clin_main_end:	ret

clin_main_02:	rcall	clin_comment		;comment?
		cpi	tempreg1,0xff		;OK
		breq	clin_main_end

		rcall	clin_string		;string
		cpi	tempreg1,0xff		;OK
		breq	clin_main_end
		cpi	tempreg1,0x00		;not found
		brne	clin_main_01		;loop if string was found

		rcall	clin_keyw		;keyword
		cpi	tempreg1,0x00		;not found
		brne	clin_main_01		;loop if keyword was found

		rcall	clin_hexval		;hex value
		cpi	tempreg1,0x00		;not found
		brne	clin_main_01		;loop if hexvalue was found

		rcall	clin_decval		;decimal value
		cpi	tempreg1,0x00		;not found
		brne	clin_main_01		;loop if hexvalue was found

		ld	tempreg1,Y+		;copy raw char
		cpi	tempreg1,'a'
		brcs	clin_main_03
		cpi	tempreg1,'z'+1
		brcc	clin_main_03
		subi	tempreg1,0x20		;set to caps
clin_main_03:	st	X+,tempreg1

		rjmp	clin_main_01

;-------------------------------------------------------------------------------
;check for decimal value
;-------------------------------------------------------------------------------
clin_decval:	ld	tempreg1,Y		;get first char
		cpi	tempreg1,'0'
		brcs	clin_decval_1		;no number
		cpi	tempreg1,'9'+1
		brcc	clin_decval_1
		subi	tempreg1,'0'
		rjmp	clin_decval_2

clin_decval_1:	clr	tempreg1		;not found code
		ret

clin_decval_2:	mov	tempreg3,tempreg1	;initial value
		clr	tempreg4		
		adiw	YL,1

clin_decval_3:	ld	tempreg1,Y		;get next char
		cpi	tempreg1,'0'
		brcs	clin_decval_4		;no number
		cpi	tempreg1,'9'+1
		brcc	clin_decval_4
		subi	tempreg1,'0'
		lsl	tempreg3		;*2
		rol	tempreg4
		movw	r0,tempreg3
		lsl	tempreg3		;*2 (*4)
		rol	tempreg4
		lsl	tempreg3		;*2 (*8)
		rol	tempreg4
		add	tempreg3,r0
		adc	tempreg4,r1
		add	tempreg3,tempreg1
		adc	tempreg4,const_0
		adiw	YL,1
		rjmp	clin_decval_3

clin_decval_4:	cpi	tempreg4,0x00		;
		breq	clin_decval_5
		ldi	tempreg1,0x1d		;code for dec 16
		st	X+,tempreg1
		st	X+,tempreg4		;high
		st	X+,tempreg3		;low
		ret

clin_decval_5:	cpi	tempreg3,0x0a
		brcs	clin_decval_6
		ldi	tempreg1,0x1c		;code for dec 8
		st	X+,tempreg1
		st	X+,tempreg3		;low
		ret

clin_decval_6:	subi	tempreg3,0xd0		;+0x30
		st	X+,tempreg3		;low
		ldi	tempreg1,0x1c		;code for dec 8
		ret

;-------------------------------------------------------------------------------
;check for hex value
;-------------------------------------------------------------------------------
clin_hexval:	ld	tempreg1,Y
		cpi	tempreg1,'$'		;hex value
		breq	clin_hexval_1
		clr	tempreg1		;not found
		ret

clin_hexval_1:	clr	tempreg3		;initial value
		clr	tempreg4		
		adiw	YL,1			;set pointer

clin_hexval_2:	ld	tempreg2,Y		;second char

		cpi	tempreg2,'0'
		brcs	clin_hexval_w		;OK, write!
		cpi	tempreg2,'9'+1
		brcc	clin_hexval_u
		subi	tempreg2,'0'
		rjmp	clin_hexval_5

clin_hexval_u:	cpi	tempreg2,'Z'
		brcs	clin_hexval_3
		subi	tempreg2,0x20

clin_hexval_3:	cpi	tempreg2,'A'
		brcs	clin_hexval_w		;OK, write
		cpi	tempreg2,'G'
		brcc	clin_hexval_w
		subi	tempreg2,'A'-10

clin_hexval_5:	andi	tempreg2,0x0f
		swap	tempreg2
		ldi	tempreg1,4
clin_hexval_6:	lsl	tempreg2
		rol	tempreg3
		rol	tempreg4
		dec	tempreg1
		brne	clin_hexval_6
		adiw	YL,1			;next char
		rjmp	clin_hexval_2		;loop

clin_hexval_w:	cpi	tempreg4,0x00
		breq	clin_hexval8
		ldi	tempreg1,0x1f		;code for hex 16
		st	X+,tempreg1
		st	X+,tempreg4		;hi
		st	X+,tempreg3		;lo
		ret

clin_hexval8:	ldi	tempreg1,0x1e		;code for hex 8
		st	X+,tempreg1
		st	X+,tempreg3		;low
		ret

;-------------------------------------------------------------------------------
; check for string (0=not found)
;-------------------------------------------------------------------------------
clin_string:	ld	tempreg1,Y		;get char
		cpi	tempreg1,'"'		;start of string
		breq	clin_string_1
		clr	tempreg1		;not found
		ret

clin_string_1:	adiw	YL,1			;next char
		st	X+,tempreg1		;store "
clin_string_2:	ld	tempreg1,Y+		;get char
		cpi	tempreg1,'"'		;end of string
		brne	clin_string_3		;branch if not
		st	X+,tempreg1		;store "
		ldi	tempreg1,0x01		;string found
		ret				;thats all
clin_string_3:	cpi	tempreg1,0x00		;end?
		brne	clin_string_4
		ldi	tempreg1,'"'
		st	X+,tempreg1
		ldi	tempreg1,0xff		;end code
		st	X+,tempreg1
		ret
clin_string_4:	st	X+,tempreg1
		rjmp	clin_string_2

;-------------------------------------------------------------------------------
; check for comment (0=not found)
;-------------------------------------------------------------------------------
clin_comment:	ld	tempreg1,Y		;get char
		cpi	tempreg1,0x27		;start of comment
		breq	clin_comment_1
		clr	tempreg1		;not found
		ret
clin_comment_1:	adiw	YL,1			;goto next char
clin_comment_2:	st	X+,tempreg1		;store char
		ld	tempreg1,Y+		;get char
		cpi	tempreg1,0x00		;end
		brne	clin_comment_2		;branch if not
		ldi	tempreg1,0xff
		st	X+,tempreg1
		ret

;-------------------------------------------------------------------------------
; check for keyword (Y=pointer)
;-------------------------------------------------------------------------------
clin_keyw:	push	ZH
		push	ZL
		push	XH
		push	XL
		push	tempreg2
		ldi	ZL,LOW(tokentab*2)	;start of token table
		ldi	ZH,HIGH(tokentab*2)
clin_keyw_01:	movw	r0,YL			;save ram pointer
		lpm	tempreg1,Z+		;get token number
		cpi	tempreg1,0x00		;end of token table
		breq	clin_keyw_04		;yes
		set				;equ flag
		ldi	tempreg2,7		;number of chars to compare

clin_keyw_02:	lpm	XL,Z+			;get ROM char
		cpi	XL,'.'			;dont care
		breq	clin_keyw_03
		ld	XH,Y+			;get RAM char
		cpi	XH,'a'
		brcs	clin_keyw_02a
		subi	XH,0x20
clin_keyw_02a:	cp	XL,XH
		breq	clin_keyw_03
		clt
						;clear flag
clin_keyw_03:	dec	tempreg2
		brne	clin_keyw_02
		brts	clin_keyw_04		;found
		movw	YL,r0			;restore ram pointer
		rjmp	clin_keyw_01
		
clin_keyw_04:	pop	tempreg2
		pop	XL			;restore registers
		pop	XH
		pop	ZL
		pop	ZH
		cpi	tempreg1,0x00
		breq	clin_keyw_05
		st	X+,tempreg1		;write token
		push	tempreg1
clin_keyw_ws1:	ld	tempreg1,Y
		cpi	tempreg1,0x20		;space
		brne	clin_keyw_ws2		;no->end
		adiw	YL,1			;pointer+1
		rjmp	clin_keyw_ws1
clin_keyw_ws2:	pop	tempreg1
clin_keyw_05:	ret

