;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# full screen editor								#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.set	editor_linestart = 2
.set	editor_linedigits = 2
.set	editor_unchanged = 32
.set	editor_changed = '*'

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
editor_entry:	clr	XL			;Boder=black
		libmio_setborder		;set
		ldi	XL,0x03
		libmio_chpump
		push	ereg
		lds	tempreg1,libmio_lastmenu	;prg to edit
		call	mem_setprog		;set program pointer
		libmio_clrscr			;clear screen
		libmio_emode			;set screen in editor mode
		clr	ctrl			;set mode

editor_entry_1:	lds	tempreg1,libmio_keycode	;wait for key release
		cpi	tempreg1,0x00
		brne	editor_entry_1

		libmio_thistext
		.db 0,0,editor_unchanged,"PROGRAM ",0
		lds	tempreg1,libmio_lastmenu	;prg number
		subi	tempreg1,0xcf			;+0x31
		libmio_outchar
		ldi	tempreg1,':'
		libmio_outchar
		ldi	YL,LOW(libmio_vram+11)	;start of program name
		ldi	YH,HIGH(libmio_vram+11)
		rcall	editor_cstat
		rcall	editor_shline
		call	mem_load		;load program	
		rcall	editor_renum		;number lines
		pop	ereg
		ldi	XL,0x88			;black on green
		cpi	ereg,0
		breq	editor_entry_p
editor_lnum_2:	ldi	XL,0xcc			;black on yellow
		ldi	ZL,LOW(errtab1*2)
		ldi	ZH,HIGH(errtab1*2)
editor_lnum_3:	cpi	ereg,1
		breq	editor_entry_o
		ldi	XL,0x4b			;white on red
		dec	ereg
editor_lnum_4:	lpm	tempreg1,Z+
		cpi	tempreg1,0
		brne	editor_lnum_4
		rjmp	editor_lnum_3

editor_entry_o:	rcall	editor_fstat		;fill status line
		ldi	ctrl,0x02
		ldi	XL,5
		ldi	XH,1
		libmio_gotoxy
		libmio_romtext			;errortext
		libmio_thistext
		.db	255," IN P",0,0
		lds	tempreg1,libmio_prog
		subi	tempreg1,0xcf
		libmio_outchar
		ldi	tempreg1,':'
		libmio_outchar
		clr	XH
		mov	XL,r12			;line no
		inc	XL
		libmio_outdez
		ldi	tempreg1,':'
		libmio_outchar
		mov	XL,r13			;statement
		inc	XL
		libmio_outdez
editor_entry_p:	ret				;thats all

editor_cset:	ldi	XL,editor_changed		;change signal char
		mov	tempreg6,XL
		ldi	tempreg4,editor_unchanged
		ret

;------------------------------------------------------------------------------
;main editor loop
;------------------------------------------------------------------------------
editor_main:	clr	ctrl			;normal mode
		rcall	editor_cset
		rcall	editor_entry
		
		mov	r13,const_0		;first viewed line
editor_main_00:	clr	XL			;set cursor position
		clr	XH
editor_main_0:	sts	libmio_edstart,r13
editor_main_1:	libmio_ecursor
		libmio_screenshot
		
;------------------------------------------------------------------------------
;pos1 key
;------------------------------------------------------------------------------
		cpi	tempreg1,0xe0		;pos1
		brne	editor_main_2
		clr	XL			;X=0
		rjmp	editor_main_0

;------------------------------------------------------------------------------
;end key
;------------------------------------------------------------------------------
editor_main_2:	cpi	tempreg1,0xe1		;end
		brne	editor_main_3
		ldi	XL,libmio_ecols-4
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor left key
;------------------------------------------------------------------------------
editor_main_3:	cpi	tempreg1,0xe2		;left
		brne	editor_main_4
		dec	XL
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor right key
;------------------------------------------------------------------------------
editor_main_4:	cpi	tempreg1,0xe3		;right
		brne	editor_main_5
		inc	XL
		mov	ctrl,XH
		call	editor_fend		;find end
		cp	ctrl,XL
		brcc	editor_main_41
		cpi	XH,bas_lines-1
		brne	editor_main_40
		dec	XL
		rjmp	editor_checkb	
editor_main_40:	clr	XL
		inc	XH	
editor_main_41:	rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor up key
;------------------------------------------------------------------------------
editor_main_5:	cpi	tempreg1,0xe4		;up
		brne	editor_main5
		dec	XH
		sbrc	XH,7
		clr	XH
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;page up key
;------------------------------------------------------------------------------
editor_main5:	cpi	tempreg1,0xe6		;page up
		brne	editor_main6
		subi	XH,0x08
		sbrc	XH,7
		clr	XH
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;page down key
;------------------------------------------------------------------------------
editor_main6:	cpi	tempreg1,0xe7		;page down
		brne	editor_main_6
		subi	XH,0xf8
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;cursor down key
;------------------------------------------------------------------------------
editor_main_6:	cpi	tempreg1,0xe5		;down
		brne	editor_main_7
		inc	XH
		rjmp	editor_checkb

;------------------------------------------------------------------------------
;enter key
;------------------------------------------------------------------------------
editor_main_7:	cpi	tempreg1,0xea		;enter
		brne	editor_main_70
		inc	XH
		clr	XL

;------------------------------------------------------------------------------
;limit coordinates to editable area
;------------------------------------------------------------------------------
editor_checkb:	cpi	XL,0x80			;out of left bound?
		brcs	editor_checkb1		;no
		ldi	XL,libmio_ecols-4	;set to right pos
		dec	XH			;prev line
		cpi	XH,0x80			;out of upper bound?
		brcs	editor_chb6		;no -> find line end
		clr	XL			;set pos to 0,0
		clr	XH
		rjmp	editor_main_0		;editor loop

editor_checkb1:	cpi	XL,libmio_ecols-3	;out of right bound?
		brcs	editor_chb3		;no
		cpi	XH,bas_lines-1		;last line?
		breq	editor_chb6		;yes -> find line end
		clr	XL			;X=0
		inc	XH			;next line
		rjmp	editor_main_0		;editor loop
		
editor_chb3:	cpi	XH,bas_lines
		brcs	editor_chb4
		ldi	XH,bas_lines-1		
		
editor_chb4:	mov	r16,XH			;y-coord
		cp	r16,r13			;check if line is visible
		brcc	editor_chb5
		mov	r13,r16
editor_chb5:	mov	r16,r13			;display Y
		subi	r16,0xf1		;+15
		cp	r16,XH			;check if line is visible
		brcc	editor_chb6
		mov	r16,XH
		subi	r16,0x0f
		mov	r13,r16
editor_chb6:	mov	ctrl,XH
		call	editor_fend		;find end
		cp	ctrl,XL
		brcc	editor_chb7
		mov	XL,ctrl	
editor_chb7:	rjmp	editor_main_0			

;------------------------------------------------------------------------------
;alt+delete key
;------------------------------------------------------------------------------
editor_main_70:	mov	ctrl,XH
		cpi	tempreg1,0xee		;delete
		brne	editor_main_75
		push	XL
		push	XH
		call	editor_dline
		pop	XH
		pop	XL		
		rjmp	editor_change

;------------------------------------------------------------------------------
;alt+insert key (insert line)
;------------------------------------------------------------------------------
editor_main_75:	cpi	tempreg1,0xef		;insert
		brne	editor_main_8
		push	XH
		call	editor_iline
		pop	XH
		clr	XL
		rjmp	editor_change
		
;------------------------------------------------------------------------------
;delete key
;------------------------------------------------------------------------------
editor_main_8:	cpi	tempreg1,0xe9		;delete
		brne	editor_main_9
		rcall	editor_dchar
		rjmp	editor_change

;------------------------------------------------------------------------------
;backspace key
;------------------------------------------------------------------------------
editor_main_9:	cpi	tempreg1,0xec		;backspace
		brne	editor_main_a
		cpi	XL,0			;at the begin of the line?
		brne	editor_main_91		;no
		rjmp	editor_main_1		;loop
editor_main_91:	dec	XL
		rcall	editor_dchar
		rjmp	editor_change		;loop

;------------------------------------------------------------------------------
;check control key
;------------------------------------------------------------------------------
editor_main_a:	lds	tempreg2,libmio_kbdstate
		andi	tempreg2,0x04		;left ctrl
		brne	editor_mainc_1
		rjmp	editor_mai_nc

;------------------------------------------------------------------------------
;CTRL+F3 receive program
;------------------------------------------------------------------------------
editor_mainc_1:	cpi	tempreg1,0xf3
		brne	editor_mainc_4
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"RECEIVE PROGRAM Y/N ?",0
		rcall	editor_yn	
		brtc	editor_mainc_2
		rcall	edit_sread
		rcall	editor_renum		;renumber lines
		rcall	editor_cset
		sts	libmio_vram,tempreg6	;set change symbol
editor_mainc_2:	rcall	editor_cstat
		clr	ereg
editor_mainc_3:	rjmp	editor_main_00			

;------------------------------------------------------------------------------
;CTRL+F2 transmit program
;------------------------------------------------------------------------------
editor_mainc_4:	cpi	tempreg1,0xf2
		brne	editor_mainc_6
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"SEND PROGRAM Y/N ?",0,0
		rcall	editor_yn	
		brtc	editor_mainc_2
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"SENDING...        ",0,0
		sts	libmio_channel,const_1	
		rcall	edit_opr
		sts	libmio_channel,const_0	
		rcall	editor_cset
editor_mainc_5:	rjmp	editor_mainc_2

;------------------------------------------------------------------------------
;CTRL+F4 new program
;------------------------------------------------------------------------------
editor_mainc_6:	cpi	tempreg1,0xf4
		brne	editor_mainc_8
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"CLEAR PROGRAM Y/N ?",0
		rcall	editor_yn	
		brtc	editor_mainc_7
		rcall	editor_pnew		;clear prog
		rcall	editor_renum
		rcall	editor_cset
		sts	libmio_vram,tempreg6	;set change symbol
editor_mainc_7:	rjmp	editor_mainc_2

;------------------------------------------------------------------------------
;CTRL+F1 print program
;------------------------------------------------------------------------------
editor_mainc_8:	cpi	tempreg1,0xf1
		brne	editor_copy
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"PRINT PROGRAM Y/N ?",0
		rcall	editor_yn	
		brtc	editor_mainc_9
		ldi	XL,0x4b
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"PRINTING...        ",0
		ldi	XL,0x02
		sts	libmio_channel,XL
		rcall	edit_opr
		sts	libmio_channel,const_0	
		rcall	editor_cset
editor_mainc_9:	rjmp	editor_mainc_2

;------------------------------------------------------------------------------
;ctrl/c copy
;------------------------------------------------------------------------------
editor_copy:	cpi	tempreg1,'c'
		brne	editor_move
		rcall	editor_wrbuf		;copy to inbuf
		rjmp	editor_main_1

;------------------------------------------------------------------------------
;ctrl/x move
;------------------------------------------------------------------------------
editor_move:	cpi	tempreg1,'x'
		brne	editor_paste
		call	editor_wrbuf		;copy to inbuf
		rcall	editor_clrline
		sts	libmio_vram,tempreg6	;set change symbol
		rjmp	editor_pstend

;------------------------------------------------------------------------------
;ctrl/v paste
;------------------------------------------------------------------------------
editor_paste:	ldi	YL,LOW(libmio_vram+29)
		ldi	YH,HIGH(libmio_vram+29)
		cpi	tempreg1,'v'
		brne	editor_pstend
		ld	tempreg3,Y
		cpi	tempreg3,'B'
		brne	editor_pstenx
		ldi	tempreg3,' '
		st	Y+,tempreg3		;clear buffer text
		st	Y+,tempreg3		;clear buffer text
		st	Y+,tempreg3		;clear buffer text
		st	Y+,tempreg3		;clear copy symbol
		st	Y+,tempreg3		;clear number
		st	Y+,tempreg3		;clear number
		rcall	editor_rdbuf
		rcall	editor_renum
		sts	libmio_vram,tempreg6	;set change symbol
		rjmp	editor_main_1

editor_pstend:	clr 	ereg
editor_pstenx:	rjmp	editor_main_1

;------------------------------------------------------------------------------
;F2 save
;------------------------------------------------------------------------------
editor_mai_nc:	cpi	tempreg1,0xf2
		brne	editor_main_c
		push	XH			;save cursor pos
		push	XL
		rcall	editor_uc
		breq	editor_main_b1
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"SAVE PROGRAM Y/N ?",0,0
		rcall	editor_yn
		brtc	editor_main_b
		call	mem_save
		call	mem_load
		rcall	editor_renum
		rcall	editor_cset
		sts	libmio_vram,tempreg4	;set unchange symbol
editor_main_b:	rcall	editor_cstat
		clr	ereg
editor_main_b1:	pop	XL			;restore cursor pos
		pop	XH
		rjmp	editor_main_0

;------------------------------------------------------------------------------
;F3 Load
;------------------------------------------------------------------------------
editor_main_c:	cpi	tempreg1,0xf3
		brne	editor_mainr
		push	XH			;save cursor pos
		push	XL
		rcall	editor_uc
		breq	editor_main_c1
		ldi	XL,0xcc
		rcall	editor_fstat		;clear status line
		libmio_thistext
		.db 1,7,"LOST CHANGES Y/N ?",0,0
		rcall	editor_yn
		brtc	editor_main_b
		call	mem_load
		rcall	editor_renum
		rcall	editor_cset
		sts	libmio_vram,tempreg4	;set unchange symbol
editor_main_c1:	rjmp	editor_main_b

;------------------------------------------------------------------------------
;F1 edit programm name
;------------------------------------------------------------------------------
editor_mainr:	cpi	tempreg1,0xf1
		brne	editor_exit
		mov	tempreg7,XL
		mov	tempreg8,XH
		rcall	editor_ren
		mov	XL,tempreg7
		mov	XH,tempreg8
		sts	libmio_vram,tempreg6	;set change symbol
		rjmp	editor_main_1
		
editor_main_ex:	rjmp	editor_main_b		;jump extender

;------------------------------------------------------------------------------
;ESC
;------------------------------------------------------------------------------
editor_exit:	cpi	tempreg1,0xed
		brne	editor_main_k
		push	XH			;save cursor pos
		push	XL
		rcall	editor_uc
		breq	editor_exit_3

editor_exit_1:	ldi	XL,0xcc
		rcall	editor_fstat
		libmio_thistext
		.db 1,7,"QUIT W/O SAVE Y/N ?",0
		rcall	editor_yn
		brtc	editor_main_ex
editor_exit_2:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	editor_exit_2
editor_exit_3:	libmio_nmode			;switch to normal mode
		ldi	XL,0x00
		libmio_setvmode
		pop	XL
		pop	XH
		ret

;------------------------------------------------------------------------------
;F4 run
;------------------------------------------------------------------------------
editor_main_k:	cpi	tempreg1,0xf4		;F4
		brne	editor_main_f		;no
		rcall	editor_uc
		brne	editor_main_l
		libmio_nmode			;switch to normal mode
		libmio_clrscr			;clear screen
		ret				;go back and run
editor_main_l:	ldi	XL,0x69			;magenta
		rcall	editor_fstat
		libmio_thistext
		.db 1,7,"SAVE CHANGES BEFORE RUN!",0,0
		libmio_waitkey
		rjmp	editor_main_b

editor_main_f:
		cpi	tempreg1,0xeb		;tab
		brne	editor_main_20		;no
		cpi	XL,25
		brcc	editor_main_20
		ldi	tempreg1,0x20		;space
		rcall	editor_ichar
editor_mtab:	ldi	tempreg1,0x20		;space
		mov	ZL,XL
editor_mtab1:	subi	ZL,3
		breq	editor_change
		brcc	editor_mtab1
		rcall	editor_ichar
		rjmp	editor_mtab

;------------------------------------------------------------------------------
;a visible  char
;------------------------------------------------------------------------------
editor_main_20:	lds	tempreg2,libmio_kbdstate
		sbrc	tempreg2,2		;left ctrl
		rjmp	editor_main_ig		;ignore
		sbrc	tempreg2,3		;right ctrl
		rjmp	editor_main_ig		;ignore
		cpi	tempreg1,0x1c		;degree
		brcs	editor_main_ig		;ignore less
		cpi	tempreg1,0x80		;last visible+1
		brcc	editor_main_ig		;igore greater or equal
		rcall	editor_ichar		;insert char
editor_change:	sts	libmio_vram,tempreg6	;set change symbol
editor_main_ig:	rjmp	editor_main_1


editor_ichar:	cpi	XL,libmio_ecols-4	;we are at the end?
		breq	editor_ichar2		;yes
		mov	tempreg2,XL		;save X-pos
		ldi	XL,libmio_ecols-4
		libmio_ecalc

editor_ichar1:	ld	tempreg3,-Y		;char on cursor pos
		std	Y+1,tempreg3		;write to next
		dec	XL
		cp	XL,tempreg2
		brne	editor_ichar1
		st	Y,tempreg1
		inc	XL
		ret

editor_ichar2:	libmio_ecalc			;calculate vram address
		st	Y,tempreg1
		ret				;loop

;------------------------------------------------------------------------------
;del char on cursor pos
;------------------------------------------------------------------------------
editor_dchar:	libmio_ecalc			;get memory position
		mov	tempreg2,XL		;copy x-coordinate
editor_dchar_1:	cpi	tempreg2,libmio_ecols-4	;at the end?
		breq	editor_dchar_2
		ldd	tempreg1,Y+1
		st	Y+,tempreg1
		inc	tempreg2
		rjmp	editor_dchar_1

editor_dchar_2:	ldi	tempreg2,0x20			;space
		st	Y,tempreg2
		ret

;------------------------------------------------------------------------------
;check keys for Y/N 
;------------------------------------------------------------------------------
editor_yn:	libmio_waitkey
		cpi	tempreg1,'Y'
		breq	editor_yn1
		cpi	tempreg1,'y'
		breq	editor_yn1
		cpi	tempreg1,0xea		;ENTER
		breq	editor_yn1
		cpi	tempreg1,'N'
		breq	editor_yn2
		cpi	tempreg1,'n'
		breq	editor_yn2
		cpi	tempreg1,0xed		;ESC
		breq	editor_yn2
		rjmp	editor_yn

editor_yn1:	set				;set T-flag
		ret		
editor_yn2:	clt				;res T-flag
		ret

;------------------------------------------------------------------------------
;check for unchanged-symbol
;------------------------------------------------------------------------------
editor_uc:	lds	XL,libmio_vram
		cpi	XL,editor_unchanged	;no change
		ret

;------------------------------------------------------------------------------
;clear status line 
;------------------------------------------------------------------------------
editor_cstat:	ldi	XL,0x88			;black on green
		rcall	editor_fstat
		libmio_thistext
		.db 1,5,"OK",0,0
		ret

;------------------------------------------------------------------------------
;fill status line with XL 
;------------------------------------------------------------------------------
editor_fstat:	push	ZL
		push	ZH
		clr	ctrl			;normal text
		sts	libmio_estatus,XL
		libmio_thistext
		.db 1,5,"                             ",0
		pop	ZH
		pop	ZL		
		ret

;-----------------------------------------------------------------------
; edit name
;-----------------------------------------------------------------------
editor_ren:	ldi	XL,0
edit_ren_01:	libmio_ncursor			;view cursor
		cpi	tempreg1,0xea		;enter
		brne	edit_ren_02
		ret
edit_ren_02:	cpi	tempreg1,0xe2		;cursor left
		brne	edit_ren_03
		cpi	XL,0
		breq	edit_ren_01
		dec	XL
		rjmp	edit_ren_01
edit_ren_03:	cpi	tempreg1,0xe3		;cursor right
		brne	edit_ren_04
		cpi	XL,11
		breq	edit_ren_01
		inc	XL
		rjmp	edit_ren_01
edit_ren_04:	cpi	tempreg1,0x20
		brcs	edit_ren_01
		cpi	tempreg1,0x80
		brcc	edit_ren_01
		st	Y,tempreg1
		cpi	XL,11
		breq	edit_ren_05
		inc	XL
edit_ren_05:	rjmp	edit_ren_01

;-----------------------------------------------------------------------
; output program
;-----------------------------------------------------------------------
edit_opr:	ldi	YL,LOW(libmio_vram+1)
		ldi	YH,HIGH(libmio_vram+1)
		ldi	tempreg2,22		;number of chars
edit_opr_1:	ld	tempreg1,Y+
		libmio_outchar
		dec	tempreg2
		brne	edit_opr_1

		libmio_newline
		ldi	tempreg1,bas_lines-1
edit_opr_2:	rcall	edit_chkl
		brts	edit_opr_3		;no empty
		dec	tempreg1
		brne	edit_opr_2
edit_opr_3:	mov	tempreg2,tempreg1	;max linennumber
		inc	tempreg2
		clr	tempreg1
edit_opr_4:	cp	tempreg1,tempreg2
		breq	edit_opr_5
		rcall	edit_outl		;output line
		inc	tempreg1
		rjmp	edit_opr_4
edit_opr_5:	ldi	tempreg1,'#'
		libmio_outchar
		libmio_newline
		ret

;------------------------------------------------------------------------------
;check if line tempreg1 is empty
;------------------------------------------------------------------------------
edit_chkl:	push	YL
		push	YH
		push	tempreg2
		push	tempreg3
		clt				;set to empty
		ldi	YL,LOW(libmio_vram+108)	;start of text
		ldi	YH,HIGH(libmio_vram+108)
		ldi	tempreg2,35
		mul	tempreg1,tempreg2
		add	YL,r0
		adc	YH,r1
		ldi	tempreg2,32		;chars per line
edit_chkl_1:	ld	tempreg3,Y+		;get char
		cpi	tempreg3,0x21
		brcc	edit_chkl_2
		dec	tempreg2
		brne	edit_chkl_1
		pop	tempreg3
		pop	tempreg2
		pop	YH
		pop	YL
		ret

edit_chkl_2:	set				;not empty
		pop	tempreg3
		pop	tempreg2
		pop	YH
		pop	YL
		ret

;------------------------------------------------------------------------------
;output line tempreg1
;------------------------------------------------------------------------------
edit_outl:	push	YH
		push	YL
		push	tempreg1
		push	tempreg2
		push	tempreg3
		ldi	YL,LOW(libmio_vram+105)	;start of text
		ldi	YH,HIGH(libmio_vram+105)
		ldi	tempreg2,35
		mul	tempreg1,tempreg2
		add	YL,r0
		adc	YH,r1
		push	YH			;save line address
		push	YL
		adiw	YL,35			;go to end of line+1

		ldi	tempreg2,35
edit_outl_1:	ld	tempreg3,-Y		;get char
		cpi	tempreg3,0x21		;space+1
		brcc	edit_outl_2
		dec	tempreg2		;char counter
		brne	edit_outl_1
		
edit_outl_2:	pop	YL			;restore address
		pop	YH
edit_outl_3:	ld	tempreg1,Y+
		libmio_outchar
		dec	tempreg2
		brne	edit_outl_3
		libmio_newline
		pop	tempreg3
		pop	tempreg2
		pop	tempreg1
		pop	YL
		pop	YH
		ret

;------------------------------------------------------------------------------
;standard helpline
;------------------------------------------------------------------------------
editor_shline:	push_ptr
		push	tempreg1
		ldi	ZL,LOW(editor_shld*2)
		ldi	ZH,HIGH(editor_shld*2)
editor_shl0:	ldi	XL,LOW(libmio_vram+70)
		ldi	XH,HIGH(libmio_vram+70)
editor_shl1:	lpm	tempreg1,Z+
		cpi	tempreg1,0x00
		breq	editor_shl2
		st	X+,tempreg1
		rjmp	editor_shl1
editor_shl2:	pop	tempreg1
		pop_ptr
;		     -------+++++++-------+++++++-------
editor_shld:	.db " Exit   Name   Save  Reload   Run  ",0

;------------------------------------------------------------------------------
;control helpline
;------------------------------------------------------------------------------
editor_chline:	push_ptr
		push	tempreg1
		ldi	ZL,LOW(editor_chld*2)
		ldi	ZH,HIGH(editor_chld*2)
		rjmp	editor_shl0

;		     -------+++++++-------+++++++-------
editor_chld:	.db "        Print  Send   Recv    New  ",0

;------------------------------------------------------------------------------
;receive helpline
;------------------------------------------------------------------------------
editor_rhline:	push_ptr
		push	tempreg1
		ldi	ZL,LOW(editor_rhld*2)
		ldi	ZH,HIGH(editor_rhld*2)
		rjmp	editor_shl0

;		     -------+++++++-------+++++++-------
editor_rhld:	.db " Abort                             ",0

;------------------------------------------------------------------------------
; read from serial
;------------------------------------------------------------------------------
edit_sread:	rcall	editor_rhline
		ldi	XL,0xcc
		rcall	editor_fstat
		libmio_thistext			;show head
		.db	1,5,"RECEIVING...",0,0
		sts	libmio_edstart,const_0
		rcall	editor_pnew
		rcall	editor_renum
		clr	ctrl			;start with line 0
		ldi	ZL,0xcc			;bk on white
		sts	libmio_estatus,ZL
		ldi	ZL,LOW(libmio_vram+11)
		ldi	ZH,HIGH(libmio_vram+11)
		mov	r14,ZL
		mov	r15,ZH	
		ldi	tempreg1,0x11		;XON
		libmio_pser			;send
		ldi	tempreg2,0x0c		;name length
edit_sreadn:	libmio_gserb			;read name
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		cpi	tempreg1,':'		;ignore all ecxept colon
		brne	edit_sreadn
edit_sreadn2:	libmio_gserb			;get serial
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		cpi	tempreg1,0x20		;space
		brcs	edit_sreadn4		;is less -> control
edit_sreadn3:	st	Z+,tempreg1
		dec	tempreg2		;limit length
		brne	edit_sreadn2		;loop	
edit_sreadn4:	cpi	tempreg1,0x20		;space
		brcs	edit_sread0		;is less -> control
		libmio_gserb
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		rjmp	edit_sreadn4
		
edit_sread0:	ldi	ZL,LOW(libmio_vram+2*libmio_ecols)
		ldi	ZH,HIGH(libmio_vram+2*libmio_ecols)
		mov	r14,ZL
		mov	r15,ZH	

		
edit_sread1:	ldi	tempreg2,libmio_ecols
		mov	ZL,r14
		mov	ZH,r15
		adiw	ZL,libmio_ecols
		mov	r14,ZL
		mov	r15,ZH	
edit_sreadv:	libmio_gserb
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		cpi	tempreg1,0x20		;ignore all less than space
		brcs	edit_sreadv
		cpi	tempreg1,'#'		;end
		breq	edit_sread5		
		rjmp	edit_sread2a
edit_sread2:	libmio_gserb			;get serial
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		cpi	tempreg1,0x20		;space
		brcs	edit_sread3		;is less -> control
edit_sread2a:	st	Z+,tempreg1
		dec	tempreg2
		brne	edit_sread2		;OK
edit_sread2b:	libmio_gserb			;get serial
		cpi	tempreg1,0x1b		;ESC
		breq	edit_sread5		;abort
		cpi	tempreg1,0x20		;space
		brcc	edit_sread2b		;wait for line feed		
		
edit_sread3:	inc	ctrl
edit_sread4:	cpi	ctrl,bas_lines+1
		brne	edit_sread1
edit_sread5:	ret


;------------------------------------------------------------------------------
; calc line adr of XH to X
;------------------------------------------------------------------------------
editor_lcalc:	ldi	XL,libmio_ecols		;bytes/vram-line
		mul	XH,XL
	    	ldi	XL,LOW(libmio_vram+3*libmio_ecols)	;lines start
		ldi	XH,HIGH(libmio_vram+3*libmio_ecols)
		add	XL,r0			;calc line address
		adc	XH,r1
		ret

;------------------------------------------------------------------------------
; read line [XH] from inbuf to vram
;------------------------------------------------------------------------------
editor_rdbuf:	push	XH
		push	XL
		rcall	editor_lcalc		;set address in vram
		ldi	YL,LOW(bas_inbuf)	;text buffer address
		ldi	YH,HIGH(bas_inbuf)
		ldi	tempreg2,libmio_ecols	;number of chars to copy
editor_rdbuf1:	ld	tempreg1,Y+		;get from vram
		st	X+,tempreg1
		dec	tempreg2
		brne	editor_rdbuf1
		pop	XL
		pop	XH		
		ret

;------------------------------------------------------------------------------
; write line [XH] from vram to inbuf
;------------------------------------------------------------------------------
editor_wrbuf:	push	XH
		push	XL
		ldi	YL,LOW(libmio_vram+29)
		ldi	YH,HIGH(libmio_vram+29)
		ldi	XL,'B'
		st	Y+,XL			;set buffer text
		ldi	XL,'U'
		st	Y+,XL			;set buffer text
		ldi	XL,'F'
		st	Y+,XL			;set buffer text
		ldi	XL,'='
		st	Y+,XL			;set buffer text
		rcall	editor_lcalc		;set address in vram
		ldi	YL,LOW(bas_inbuf)	;text buffer address
		ldi	YH,HIGH(bas_inbuf)
		ldi	tempreg2,libmio_ecols	;number of chars to copy
editor_wrbuf1:	ld	tempreg1,X+		;get from vram
		st	Y+,tempreg1
		dec	tempreg2
		brne	editor_wrbuf1		
		lds	tempreg1,bas_inbuf
		sts	libmio_vram+33,tempreg1	;copy number
		lds	tempreg1,bas_inbuf+1
		sts	libmio_vram+34,tempreg1	;copy number
		pop	XL
		pop	XH	
		ret

;------------------------------------------------------------------------------
; clear line [XH] in vram
;------------------------------------------------------------------------------
editor_clrline:	push	XH
		push	XL
		push	tempreg1
		push	tempreg2
		rcall	editor_lcalc		;set address in vram
		adiw	XL,3
		ldi	tempreg1,0x20		;space
		ldi	tempreg2,libmio_ecols-3	;number of chars to copy
editor_cline1:	st	X+,tempreg1
		dec	tempreg2
		brne	editor_cline1
		pop	tempreg2
		pop	tempreg1
		pop	XL
		pop	XH		
		ret

;------------------------------------------------------------------------------
; new program
;------------------------------------------------------------------------------
editor_pnew:	push_ptr
		push	tempreg1
		ldi	tempreg1,0x20		;space
		ldi	XL,LOW(libmio_vram+3*libmio_ecols)	;lines start
		ldi	XH,HIGH(libmio_vram+3*libmio_ecols)
		ldi	YL,LOW(bas_lines*libmio_ecols)
		ldi	YH,HIGH(bas_lines*libmio_ecols)
editor_pnew_1:	st	X+,tempreg1
		sbiw	YL,1
		brne	editor_pnew_1		
		pop	tempreg1
		pop_ptr

;------------------------------------------------------------------------------
; renumber lines
;------------------------------------------------------------------------------
editor_renum:	push_ptr
		push	tempreg1
		ldi	tempreg1,0x01		;first linenumber
		ldi	XL,LOW(libmio_vram+3*libmio_ecols)	;lines start
		ldi	XH,HIGH(libmio_vram+3*libmio_ecols)
editor_renum1:	ldi	YL,0x30			;"0"
		mov	YH,tempreg1
editor_renum2:	subi	YH,10			;-10
		brcs	editor_renum3
		inc	YL
		rjmp	editor_renum2
editor_renum3:	subi	YH,0xc6			;+70
		st	X+,YL			;10^1
		st	X+,YH			;10^0
		ldi	YL,0x20			;space
		st	X+,YL			;write
		adiw	XL,libmio_ecols-3	;ptr to next line
		inc	tempreg1
		cpi	tempreg1,bas_lines+1
		brne	editor_renum1
		pop	tempreg1
		pop_ptr

;------------------------------------------------------------------------------
;status messages
;------------------------------------------------------------------------------
errtab1:	.db "BREAK",0,"OVERFLOW",0,"DIVIDE /0",0,"SQR FROM <0"
errtab5:	.db 0,"CONSTANT TOO BIG",0,"WRONG EXPRESSION",0,"SYNTAX ERROR",0,"UNKNOWN KEYWORD",0
errtab9:	.db "WRONG FORMAT",0,"BAD LINENUMBER",0,"NEXT W/O FOR",0,"RETURN W/O GOSUB",0
errtab13:	.db "STACK OVERFLOW",0,"UNTIL W/O REPEAT",0,"I2C ERROR",0,"UNKNOWN ERROR",0
errtab17:	.db "DFLASH ERROR",0,"OUT OF ARRAY",0,"INCOMPLETE PAR",0,"KEYWORD IS MISSING",0
errtab21:	.db "WRONG BCOPY ",0,"OUT OF SCREEN",0,"CANNOT CREATE FILE",0,"MEMORY FULL",0
errtab25:	.db "FILE NOT FOUND",0,"PAGE NOT IN FILE",0,"PAGES NOT IN RANGE",0,"NOT IN GRAPHICS MODE",0
errtab29:	.db "NOT IN TEXT MODE",0,"NO USR FILE",0,"SRC OUT OF SCREEN",0,"DEST OUT OF SCREEN",0
errtab33:	.db "WRONG SPRITE",0,"WRONG EEPROM ADR",0,"NO PRG FILE",0,"XMODEM ERROR"
errtab37:	.db 0,"CAN'T LOAD THIS",0
;------------------------------------------------------------------------------
; delete line [XH] in vram
;------------------------------------------------------------------------------
editor_dline:	cpi	XH,bas_lines-1	;last line
		brcs	editor_dline1
		ret

editor_dline1:	push	XH			;save line number
editor_dline2:	rcall	editor_cup		;copy next line to this
		inc	XH
		cpi	XH,bas_lines-1
		brne	editor_dline2
		rcall	editor_clrline		;clear last line
		pop	XH
		rjmp	editor_renum		;renumber lines

;------------------------------------------------------------------------------
; insert line [XH] in vram
;------------------------------------------------------------------------------
editor_iline:	cpi	XH,bas_lines-1	;last line
		brcs	editor_iline1
		ret

editor_iline1:	push	XH			;save registers
		push	XL
		mov	XL,XH			;
		dec	XL
		ldi	XH,bas_lines-2
editor_iline2:	rcall	editor_cdown
		dec	XH
		cp	XH,XL
		brne	editor_iline2
		inc	XH
		rcall	editor_clrline
		pop	XL
		pop	XH
		rjmp	editor_renum		;renumber lines 

;------------------------------------------------------------------------------
; copy line [XH] to [XH+1]
;------------------------------------------------------------------------------
editor_cdown:	push_ptr
		rcall	editor_lcalc		;set address in vram
		adiw	XL,3			;skip linenumber
		movw	YL,XL
		ldi	XH,libmio_ecols-3
editor_cdown1:	ld	XL,Y+
		std	Y+libmio_ecols-1,XL
		dec	XH
		brne	editor_cdown1
		pop_ptr

;------------------------------------------------------------------------------
; copy line [XH+1] to [XH]
;------------------------------------------------------------------------------
editor_cup:	push_ptr
		rcall	editor_lcalc		;set address in vram
		adiw	XL,3			;skip linenumber
		movw	YL,XL
		ldi	XH,libmio_ecols-3
editor_cup1:	ldd	XL,Y+libmio_ecols
		st	Y+,XL
		dec	XH
		brne	editor_cup1
		pop_ptr

;------------------------------------------------------------------------------
; find end of line XH (first space pos)
;------------------------------------------------------------------------------
editor_fend:	push_ptr
		rcall	editor_lcalc		;calc address
		movw	YL,XL			;copy
		adiw	XL,35			;set pointer to end of line
editor_fend1:	ld	tempreg1,-X		;get char
		cpi	tempreg1,0x21		;space
		brcs	editor_fend1
		cpi	tempreg1,0x80		;space
		brcc	editor_fend1

editor_fend2:	sub	XL,YL			;sub start
		sbc	XH,YL
		mov	ctrl,XL
		subi	ctrl,2			;linenumber
		sbrc	ctrl,7
		clr	ctrl
		pop_ptr
