;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# menu functions								#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
menu_mainloop:	libmio_nokey
menu_main:	ldi	XL,0			;blue
		libmio_setborder
		ldi	XL,1
		libmio_chpump			;enable chargepump for serial
		clr	ctrl			;normal mode
		sts	libmio_channel,const_0	;output to screen
		clr	XL
		libmio_setvmode			;standard video mode
		ldi	XL,0x07			;color scheme (cyan on blue)
		libmio_setcolor
		libmio_clrscr
		ldi	XL,0x15			;color scheme (cyan on blue)
		libmio_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,20
		libmio_whbox
		ldi	XL,0x51			;color scheme (cyan on black)
		libmio_setcolor
		libmio_thistext
		.db 1,1,0x83,0x83,0x83,0x83,0x83,0x83," AVR-ChipBasic2 ",0x82,0x82,0x82,0x82,0x82,0x82,0,0
		ldi	YL,LOW(libmio_vram+721)
		ldi	YH,HIGH(libmio_vram+721)

		ldi	r16,0x4a		;red on cyan
		st	Y,r16
		std	Y+27,r16

		ldi	r16,0xc4		;yellow on red
		std	Y+1,r16
		std	Y+26,r16

		ldi	r16,0x8c		;green on yellow
		std	Y+2,r16
		std	Y+25,r16

		ldi	r16,0x28		;blue on green
		std	Y+3,r16
		std	Y+24,r16

		ldi	r16,0x62		;magenta on blue
		std	Y+4,r16
		std	Y+23,r16

		ldi	r16,0xa6		;cyan on magenta
		std	Y+5,r16
		std	Y+22,r16

		rcall	menu_mbar		;draw menu bar at bottom line
		lds	tempreg1,libmio_lastmenu
		cpi	tempreg1,0x0b		;
		brcs	menu_main_0
		clr	tempreg1

menu_main_0:	sts	libmio_lastmenu,tempreg1
		mov	tempreg3,tempreg1	;set as default
menu_main_1:	sbrc	tempreg3,7		;is below zero
		clr	tempreg3		;set to zero
		cpi	tempreg3,0x0b		;maximum+1
		brcs	menu_main_2
		ldi	tempreg3,0x0a		;limit to max
		
menu_main_2:	ldi	tempreg2,0x00		;prg icon counter
menu_main_3:	push	tempreg3
		rcall	menu_prgicon		;draw program icon
		pop	tempreg3
		inc	tempreg2
		cpi	tempreg2,0x08		;beyond limit?
		brne	menu_main_3
		rcall	menu_memicon		;dataflash
		rcall	menu_cfgicon		;config
		rcall	menu_inficon		;info

menu_main_4:	push	tempreg3
		rcall	menu_keys
		pop	tempreg3
		
		cpi	tempreg1,0xe2		;left
		brne	menu_main_5
		dec	tempreg3		;change to n-1
		rjmp	menu_main_1		;loop

menu_main_5:	cpi	tempreg1,0xe3		;right
		brne	menu_main_6
		inc	tempreg3		;change to n+1
		rjmp	menu_main_1		

menu_main_6:	cpi	tempreg1,0xe4		;up
		brne	menu_main_7
		cpi	tempreg3,0x04
		brcs	menu_main_7
		subi	tempreg3,0x04		;change to n-4
		rjmp	menu_main_1		
	    
menu_main_7:	cpi	tempreg1,0xe5		;down
		brne	menu_main_8
		cpi	tempreg3,0x07
		brcc	menu_main_8
		subi	tempreg3,0xfc		;change to n+4
		rjmp	menu_main_1		

menu_main_8:	cpi	tempreg3,0x08		;program
		brcs	menu_main_20		;branch if yes
		cpi	tempreg1,0xea		;enter
		breq	menu_main_9
		cpi	tempreg1,0xf4		;F4 (Run)
		brne	menu_main_4
				
menu_main_9:	sts	libmio_lastmenu,tempreg3
		cpi	tempreg3,0x08		;flash
		brne	menu_main_10
		cpi	tempreg1,0xea		;ENTER
		brne	menu_main_4		
		rcall	menu_wnk
		call	fman_main		;call flash manager
		rjmp	menu_mainloop

menu_main_10:	cpi	tempreg3,0x09		;config
		brne	menu_main_11
		cpi	tempreg1,0xea		;ENTER
		brne	menu_main_4		
		rcall	menu_wnk
		call	confp_main		;call config
		rjmp	menu_mainloop

menu_main_11:	rcall	menu_wnk
		cpi	tempreg1,0xea		;ENTER
		brne	menu_main_4		
		call	infopage_main		;call info
		rjmp	menu_mainloop

;a program
menu_main_20:	push	tempreg1
		lds	tempreg1,libmio_kbdstate
		sbrc	tempreg1,2		;skip if no left control
		rjmp	menu_main_40		;ctrl
		pop	tempreg1
		cpi	tempreg1,0xea		;enter
		breq	menu_main_21
		cpi	tempreg1,0xf4		;run
		brne	menu_main_22
menu_main_21:	rcall	menu_wnk0
		clr	ereg
		call	menu_runprog		;run pogram
		rjmp	menu_mainloop

menu_main_22:	cpi	tempreg1,0xf1		;edit
		brne	menu_main_23
		rcall	menu_wnk0
		clr	ereg
		call	menu_editloop		;edit program
		rjmp	menu_mainloop

menu_main_23:	cpi	tempreg1,0xf2		;save
		brne	menu_main_24
		rcall	menu_wnk0
		call	fsys_savebas
		rjmp	menu_mainloop

menu_main_24:	cpi	tempreg1,0xf3		;load
		brne	menu_main_25
		rcall	menu_wnk0
		call	fsys_loadbas		;edit program
		rjmp	menu_mainloop

menu_main_25:	rjmp	menu_main_4

menu_main_40:	pop	tempreg1
		cpi	tempreg1,0xf1		;copy
		brne	menu_main_41
		rcall	menu_wnk0
		call	menu_copy		;copy program
		rjmp	menu_mainloop

menu_main_41:	cpi	tempreg1,0xf2		;recv
		brne	menu_main_42
		rcall	menu_wnk0
		call	send_prog		;send program
		rjmp	menu_mainloop

menu_main_42:	cpi	tempreg1,0xf3		;send
		brne	menu_main_43
		rcall	menu_wnk0
		call	recv_prog		;receive program
		rjmp	menu_mainloop

menu_main_43:	cpi	tempreg1,0xf4		;clear
		brne	menu_main_25
		rcall	menu_wnk0
		call	menu_clear		;clear program
		rjmp	menu_mainloop

;------------------------------------------------------------------------------
;info text (version)
;------------------------------------------------------------------------------
menu_itext1:	libmio_thistext
		.db 255,"AVR-ChipBasic2 V1.10",0
		ret

;------------------------------------------------------------------------------
;wait for key release
;------------------------------------------------------------------------------
menu_wnk0:	sts	libmio_lastmenu,tempreg3
menu_wnk:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	menu_wnk		;wait for key release
		ret

;------------------------------------------------------------------------------
;draw program icon (tempreg2=number, tempreg3=invert 0/1)
;------------------------------------------------------------------------------
menu_prgicon:	ldi	XL,0x01			;X coord of icon 0
		ldi	XH,0x03			;Y coord of icon 0
		sbrc	tempreg2,0
		subi	XL,0xf9			;X+7
		sbrc	tempreg2,1
		subi	XL,0xf2			;X+14
		sbrc	tempreg2,2
		subi	XH,0xfa			;Y+6
		mov	tempreg1,tempreg2
		call	mem_readf1
		mov	r16,tempreg1
		ldi	tempreg1,0x2e		;white on blue
		cpi	r16,'N'
		brne	menu_pric_1
		ldi	tempreg1,0x2c		;yellow on blue
menu_pric_1:	cp	tempreg3,tempreg2
		brne	menu_prgicon_0
		swap	tempreg1
menu_prgicon_0:	sts	libmio_color,tempreg1
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0
		ldi	tempreg1,'P'
		libmio_outchar
		mov	tempreg1,tempreg2	;prg number
		subi	tempreg1,0xcf		;+0x31
		libmio_outchar
		libmio_thistext
		.db	255,0x20,0x20,0
		inc	XH
		libmio_gotoxy
		mov	tempreg1,tempreg2
		call	mem_readf1		;start address
		cpi	tempreg1,'N'		;native
		brne	menu_prgi_1
		libmio_thistext
		.db	255,0x20,0x20,0xe6,0xe7,0x20,0x20,0
		inc	XH
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0xe8,0xe9,0x20,0x20,0
		rjmp	menu_prgi_e

menu_prgi_1:	libmio_thistext
		.db	255,0x20,0x20,0xd0,0xd1,0x20,0x20,0
		inc	XH
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0xd2,0xd3,0x20,0x20,0


menu_prgi_e:	mov	tempreg1,tempreg2
		call	mem_progadr_0		;start address
		inc	XH
		libmio_gotoxy
		ldi	tempreg3,0x06		;chars per line
menu_prgicon_1:	lpm	tempreg1,Z+
		libmio_outchar
		dec	tempreg3
		brne	menu_prgicon_1
		inc	XH
		libmio_gotoxy
		ldi	tempreg3,0x06		;chars per line
menu_prgicon_2:	lpm	tempreg1,Z+
		libmio_outchar
		dec	tempreg3
		brne	menu_prgicon_2
		inc	XH
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0x20,0x20,0x20,0x20,0
		ret

;------------------------------------------------------------------------------
;draw info icon (X=coord)
;------------------------------------------------------------------------------
menu_inficon:	ldi	tempreg1,0x2a		;cyan on blue
		cpi	tempreg3,0x0a
		brne	menu_inficon_1
		swap	tempreg1
menu_inficon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,15,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,15,0x20,0x20,0xd4,0xd5,0x20,0x20,0,0
		libmio_thistext
		.db	17,15,0x20,0x20,0xd6,0xd7,0x20,0x20,0,0
		libmio_thistext
		.db	18,15," INFO ",0,0
		libmio_thistext
		.db	19,15,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		ret


;------------------------------------------------------------------------------
;draw conf icon (X=coord)
;------------------------------------------------------------------------------
menu_cfgicon:	ldi	tempreg1,0x28		;green on blue
		cpi	tempreg3,0x09
		brne	menu_cfgicon_1
		swap	tempreg1
menu_cfgicon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,8,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,8,0x20,0x20,0xd8,0xd9,0x20,0x20,0,0
		libmio_thistext
		.db	17,8,0x20,0x20,0xda,0xdb,0x20,0x20,0,0
		libmio_thistext
		.db	18,8,"CONFIG",0,0
		libmio_thistext
		.db	19,8,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		ret


;------------------------------------------------------------------------------
;draw flash icon (X=coord)
;------------------------------------------------------------------------------
menu_memicon:	ldi	tempreg1,0x2c		;yellow on blue
		cpi	tempreg3,0x08
		brne	menu_memicon_1
		swap	tempreg1
menu_memicon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,1,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,1,0x20,0x20,0xdc,0xdd,0x20,0x20,0,0
		libmio_thistext
		.db	17,1,0x20,0x20,0xde,0xdf,0x20,0x20,0,0
		libmio_thistext
		.db	18,1,"DFLASH",0,0
		libmio_thistext
		.db	19,1,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		ret

;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------
menu_keys:	ldi	r19,0xdd		;dummy value
		sts	libmio_lastkey,const_0
	
menu_keys_01:	call	libmio_scrs		;enable screenshots
		lds	tempreg1,libmio_kbdstate
		andi	tempreg1,0x04		;mask control bit
		cp	tempreg1,r19
		breq	menu_keys_03		;equal
		mov	r19,tempreg1		;copy to old
		cpi	tempreg1,0x00		;normal
		brne	menu_keys_02		;not
		rcall	menu_mbar		;standard menu
		rjmp	menu_keys_01

menu_keys_02:	rcall	menu_cmbar		;control menu
		rjmp	menu_keys_01

menu_keys_03:	lds	tempreg1,libmio_lastkey	;get key
		cpi	tempreg1,0x00
		breq	menu_keys_01
		ret

;------------------------------------------------------------------------------
;copy program
;------------------------------------------------------------------------------
menu_copy:	ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;maximal sized box
		ldi	YH,15
		ldi	ZL,28
		ldi	ZH,19
		libmio_whbox
		ldi	XL,0x40			;color scheme (black on green)
		libmio_setcolor
		libmio_thistext
		.db 16,2,"Copy Program to",0
		lds	tempreg4,libmio_lastmenu	;active number
menu_copy_1:	ldi	tempreg3,0		
menu_copy_2:	ldi	XL,0x0c			;color scheme (yellow on black)
		cp	tempreg3,tempreg4
		brne	menu_copy_3
		ldi	XL,0x60			;color scheme (black on yellow)
menu_copy_3:	libmio_setcolor
		ldi	XH,18
		mov	XL,tempreg3
		lsl	XL
		add	XL,tempreg3
		subi	XL,-3
		libmio_gotoxy
		ldi	tempreg1,'P'
		libmio_outchar
		mov	tempreg1,tempreg3
		andi	tempreg1,0x07
		subi	tempreg1,-49
		libmio_outchar
		inc	tempreg3
		cpi	tempreg3,0x08
		brne 	menu_copy_2
menu_copy_4:	libmio_waitkey
		cpi	tempreg1,0xe2		;left
		brne	menu_copy_5
		cpi	tempreg4,0x00
		breq	menu_copy_4
		dec	tempreg4
		rjmp	menu_copy_1

menu_copy_5:	cpi	tempreg1,0xe3		;right
		brne	menu_copy_6
		cpi	tempreg4,0x07
		breq	menu_copy_4
		inc	tempreg4
		rjmp	menu_copy_1

menu_copy_6:	cpi	tempreg1,0xea		;enter
		brne	menu_copy_7
		call	mem_copy
		ret

menu_copy_7:	cpi	tempreg1,0xed		;esc
		brne	menu_copy_4
		ret

;------------------------------------------------------------------------------
;clear program
;------------------------------------------------------------------------------
menu_clear:	libmio_askthis
		.db 0x4f,"Clear this Program? ",0
		cpi	tempreg1,0x01		;yes?
		breq	menu_clear_1
		ret
menu_clear_1:	call	mem_clear
		ret

;------------------------------------------------------------------------------
; editor loop
;------------------------------------------------------------------------------
menu_editloop:	libmio_nokey
		call	mem_readfirst
		cpi	tempreg1,'N'		;native
		breq	menu_editloop0
		call	editor_main
		sts	libmio_kflags,const_0
		lds	XL,libmio_lastkey
		cpi	XL,0xf4			;F4
		breq	menu_editloop1
menu_editloop0:	rjmp	menu_main
menu_editloop1:	call	mem_readfirst
		lpm	tempreg1,Z
		cpi	tempreg1,0x5f		;plain text
		breq	menu_editloop
		rcall	menu_runprog		;run programm
		clr	XL
		libmio_setvmode
menu_editloop3:	rjmp	menu_editloop

;------------------------------------------------------------------------------
;run program
;------------------------------------------------------------------------------
menu_runprog:	libmio_clrscr			;clear screen from menu
		clr	ereg			;clear error flag
		sts	libmio_keycode,const_0	;clear keyboard
		call	mem_progadr		;start address
		lpm	tempreg1,Z
		cpi	tempreg1,0x5f		;plain text
		breq	menu_rp0
		adiw	ZL,12
		lpm	tempreg1,Z+		;get type
		cpi	tempreg1,'N'		;native
		brne	menu_runprg_0
		adiw	ZL,3
		lsr	ZH
		ror	ZL
		icall				;call prg
menu_rp0:	ret				;goto menu

menu_runprg_0:	call	tbrun			;run programm
		sts	libmio_font,const_0
		sts	libmio_seqspeed,const_0	;stop sequencer
;		libmio_nmode			;normal mode
		sts	libmio_channel,const_0	;set output to screen
		libmio_slow			;set video on
		libmio_newline
		libmio_setcolor
		ldi	XL,0x40			;red
		sts	0x100,XL		;store to palette
		ldi	XL,0xe0			;white
		sts	0x101,XL

		lds	XL,libmio_vidmode	;get videomode to select action
		andi	XL,0x07
		cpi	XL,0x00
		brne	menu_runprg_2
menu_runprg_1:	ldi	XL,0x27			;color
		ldi	XH,22			;Y-position
		rjmp	menu_runprog3

menu_runprg_2:	cpi	XL,0x01
		brne	menu_runprg_3
		ldi	XL,0x27			;color
		libmio_setcolor			;set
		ldi	YL,0
		ldi	YH,13
		ldi	ZL,8
		ldi	ZH,14
		libmio_cbox
		ldi	XL,0x72			;color
		libmio_setcolor			;set

		ldi	YL,0
		ldi	YH,104
		ldi	ZL,71
		ldi	ZH,115
		libmio_fbox

		ldi	XL,0x27			;color
		ldi	XH,105			;Y-position
		rjmp	menu_runprog3

menu_runprg_3:	cpi	XL,0x02
		brne	menu_runprg_4
		ldi	XL,0x10			;color
		ldi	XH,66			;Y-position
		rjmp	menu_runprog3

menu_runprg_4:	cpi	XL,0x03
		brne	menu_runprg_5
		ldi	XL,0x10			;color
		ldi	XH,47			;Y-position
		rjmp	menu_runprog3

menu_runprg_5:	cpi	XL,0x05
		brne	menu_runprg_6
		ldi	XL,0x10			;color
		ldi	XH,56			;Y-position
		rjmp	menu_runprog3

menu_runprg_6:	cpi	XL,0x07
		brne	menu_runprog4
		ldi	XL,0x27			;color
		ldi	XH,1			;Y-position
		rjmp	menu_runprog3

menu_runprog3:	libmio_setcolor
		clr	XL
		libmio_gotoxy
		libmio_thistext
		.db 255," PRESS ESC ",0,0
menu_runprog4:	lds	XL,libmio_keycode
		cpi	XL,0xed			;esc
		brne	menu_runprog4		;wait for esc key
menu_runprog5:	libmio_nokey
		ret

;------------------------------------------------------------------------------
;the menu bar at bottom line
;------------------------------------------------------------------------------
menu_mbar:	ldi	ZL,LOW(menu_data*2)
		ldi	ZH,HIGH(menu_data*2)
menu_mbar_01:	libmio_drawmenu
		ret

;------------------------------------------------------------------------------
;the menu bar at bottom line (ctrl mode)
;------------------------------------------------------------------------------
menu_cmbar:	ldi	ZL,LOW(menu_cdata*2)
		ldi	ZH,HIGH(menu_cdata*2)
		rjmp	menu_mbar_01


			;111111222222333333444444555555
menu_data:	.db  	"       Edit  Save  Load  Run  "
menu_cdata:	.db	"       Copy  Send  Recv  Clear"
