#!/usr/bin/perl
#################################################################################
#										#
# screenshot tool for avr-chipbasic2						#
# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
use POSIX;

$serdevice="/dev/ttyS0";
$fname=$ARGV[0];
$use_c8=0;

$ct[0]=".";
$ct[1]="x";
$ct[2]="B";
$ct[3]="b";
$ct[4]="R";
$ct[5]="r";
$ct[6]="M";
$ct[7]="m";
$ct[8]="G";
$ct[9]="g";
$ct[10]="C";
$ct[11]="c";
$ct[12]="Y";
$ct[13]="y";
$ct[14]="W";
$ct[15]="w";

if ($fname eq "-c8")
{
    $fname=$ARGV[1];
    $ct[0]=".";
    $ct[1]=".";
    $ct[2]="B";
    $ct[3]="B";
    $ct[4]="R";
    $ct[5]="R";
    $ct[6]="M";
    $ct[7]="M";
    $ct[8]="G";
    $ct[9]="G";
    $ct[10]="C";
    $ct[11]="C";
    $ct[12]="Y";
    $ct[13]="Y";
    $ct[14]="W";
    $ct[15]="W";
    $use_c8=1;
}

###############################################################################
# get pixel value from tab
###############################################################################
sub get_pixel
{
    $nb=0;
    if ($z =~ /^\./) {$nb=0}
    elsif ($z =~ /^x/) {$nb=1}
    $z=$';
    return $nb;
}


###############################################################################
# get pixel value from tab
###############################################################################
sub xpal
{
    if ($use_c8 == 0)
    {
        print WTAB "\". c #000000\",\n";
        print WTAB "\"x c #555555\",\n";
        print WTAB "\"b c #5555ff\",\n";
        print WTAB "\"B c #0000cc\",\n";
        print WTAB "\"R c #aa0000\",\n";
        print WTAB "\"r c #ff5555\",\n";
        print WTAB "\"M c #cc00cc\",\n";
        print WTAB "\"m c #ff55ff\",\n";
        print WTAB "\"G c #00cc00\",\n";
        print WTAB "\"g c #55ff55\",\n";
        print WTAB "\"C c #00cccc\",\n";
        print WTAB "\"c c #55ffff\",\n";
        print WTAB "\"Y c #cccc00\",\n";
        print WTAB "\"y c #ffff55\",\n";
        print WTAB "\"W c #cccccc\",\n";
        print WTAB "\"w c #ffffff\",\n";
    }
    else
    {
        print WTAB "\". c #000000\",\n";
        print WTAB "\"x c #000000\",\n";
        print WTAB "\"B c #0000ff\",\n";
        print WTAB "\"b c #0000ff\",\n";
        print WTAB "\"R c #ff0000\",\n";
        print WTAB "\"r c #ff0000\",\n";
        print WTAB "\"M c #ff00ff\",\n";
        print WTAB "\"m c #ff00ff\",\n";
        print WTAB "\"G c #00ff00\",\n";
        print WTAB "\"g c #00ff00\",\n";
        print WTAB "\"C c #00ffff\",\n";
        print WTAB "\"c c #00ffff\",\n";
        print WTAB "\"Y c #ffff00\",\n";
        print WTAB "\"y c #ffff00\",\n";
        print WTAB "\"W c #ffffff\",\n";
        print WTAB "\"w c #ffffff\",\n";
    }
}

###############################################################################
# get nibble data from matrix
###############################################################################
sub get_nibble
{
    $nb=0;
    if ($z =~ /^0/) {$nb=0}
    elsif ($z =~ /^1/) {$nb=1}
    elsif ($z =~ /^2/) {$nb=2}
    elsif ($z =~ /^3/) {$nb=3}
    elsif ($z =~ /^4/) {$nb=4}
    elsif ($z =~ /^5/) {$nb=5}
    elsif ($z =~ /^6/) {$nb=6}
    elsif ($z =~ /^7/) {$nb=7}
    elsif ($z =~ /^8/) {$nb=8}
    elsif ($z =~ /^9/) {$nb=9}
    elsif ($z =~ /^A/) {$nb=10}
    elsif ($z =~ /^B/) {$nb=11}
    elsif ($z =~ /^C/) {$nb=12}
    elsif ($z =~ /^D/) {$nb=13}
    elsif ($z =~ /^E/) {$nb=14}
    elsif ($z =~ /^F/) {$nb=15}
    $z=$';
    return $nb;
}
###############################################################################
# get screenshot type
###############################################################################
sub get_type
{
    $vmode=-1;
    if ($z =~ /^0/) {$vmode=0}
    elsif ($z =~ /^8/) {$vmode=8}		#editor mode
    elsif ($z =~ /^1/) {$vmode=1}
    elsif ($z =~ /^2/) {$vmode=2}
    elsif ($z =~ /^3/) {$vmode=3}
    elsif ($z =~ /^4/) {$vmode=4}
    elsif ($z =~ /^5/) {$vmode=5}
    elsif ($z =~ /^6/) {$vmode=6}
    elsif ($z =~ /^7/) {$vmode=7}
    elsif ($z =~ /^9/) {$vmode=1}
    elsif ($z =~ /^A/) {$vmode=2}
    elsif ($z =~ /^B/) {$vmode=3}
    elsif ($z =~ /^C/) {$vmode=4}
    elsif ($z =~ /^D/) {$vmode=5}
    elsif ($z =~ /^E/) {$vmode=6}
    elsif ($z =~ /^F/) {$vmode=7}

    if ($vmode>=0)
    {
	$z=$';
	$border=&get_nibble();
	$estatus=&get_nibble();
	for($i=0;$i<16;$i++)
	{
	    $cval=&get_nibble();
	    $pal[$i]=$cval;
	}
    }
}

###############################################################################
# read data from chip
###############################################################################
sub get_data
{
    open (SER, $serdevice);
    $z=<SER>;
    &get_type();
    if ($vmode==0)
    {
	for($i=0;$i<46;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "T";
	}
    }
    elsif ($vmode==8)
    {    
	$pal[0]=$estatus*32;
	if ($pal[0]<128){$pal[0]=$pal[0]+14}
	for($i=0;$i<19;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "E";
	}
    }
    elsif ($vmode==1)
    {
	for($i=0;$i<131;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "1";
	}
    }

    elsif ($vmode==2)
    {
	for($i=0;$i<76;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "2";
	}	    
    }   
 
    elsif ($vmode==3)
    {
	for($i=0;$i<58;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "3";
	}
    }

    elsif ($vmode==5)
    {
	for($i=0;$i<64;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "5";
	}
    }

    elsif ($vmode==4)
    {
	for($i=0;$i<87;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "4";
	}
    }

    elsif ($vmode==6)
    {
	for($i=0;$i<87;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "6";
	}
    }

    elsif ($vmode==7)
    {
	for($i=0;$i<92;$i++)
	{
	    $data[$i]=<SER>;
	    chomp($data[$i]);
	    print "7";
	}
    }
    
    close(SER);
}

###############################################################################
# convert strings to char and attribute array (normal mode)
###############################################################################
sub fillarray_mode0
{
    for ($y=0;$y<23;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[30*$y+$x]=16*$hi+$lo;
	}
    }

    for ($y=0;$y<23;$y++)
    {
	$z=$data[23+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $acell[30*$y+$x]=16*$hi+$lo;
	}
    }
}

###############################################################################
# convert strings to char and attribute array (editor mode)
###############################################################################
sub fillarray_emode
{
    for ($y=0;$y<19;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<36;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    if ($y==0)
	    {
		$vcell[$x]=16*$hi+$lo;
		$acell[$x]=10;
	    }	
	    if ($y==1)
	    {
		$vcell[36+$x]=16*$hi+$lo;
		$acell[36+$x]=$pal[0];
	    }
	    if ($y==2)
	    {
		$vcell[36*18+$x]=16*$hi+$lo;
		$acell[36*18+$x]=32*2+2*7;
		if ($x>6)
		{
		    $acell[36*18+$x]=32*6+2*0;
		}
		if ($x>13)
		{
		    $acell[36*18+$x]=32*4+2*0;
		}
		if ($x>20)
		{
		    $acell[36*18+$x]=32*1+2*7;
		}
		if ($x>27)
		{
		    $acell[36*18+$x]=32*3+2*7;
		}
	    }	
	    if ($y>2)
	    {
		$vcell[36*($y-1)+$x]=16*$hi+$lo;
		$acell[36*($y-1)+$x]=14;
	    }	
	    
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics1)
###############################################################################
sub fillarray_mode1
{
    for ($y=0;$y<15;$y++)
    {
	$z=$data[116+$y];
	for ($x=0;$x<21;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $fcell[21*$y+$x]=$ct[$hi];
	    $bcell[21*$y+$x]=$ct[$lo];
	}
    }


    for ($y=0;$y<116;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<21;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $bline=$lo+16*$hi;
	    $fgc=$bcell[$x+21*floor($y/8)];
	    $bgc=$fcell[$x+21*floor($y/8)];
	    for ($px=0;$px<8;$px++)
	    {
		$bit=$bline & 1;
		if ($bit==0)
		{
		    $vcell[$px+8*$x+168*$y]=$bgc;
		}
		else
		{
		    $vcell[$px+8*$x+168*$y]=$fgc;
		}
		$bline=$bline >> 1;
	    }
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics2)
###############################################################################
sub fillarray_mode2
{
    for ($y=0;$y<76;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $cin[0]=$lo & 3;
	    $lo=$lo >> 2;
	    $cin[1]=$lo & 3;
	    $cin[2]=$hi & 3;
	    $hi=$hi >> 2;
	    $cin[3]=$hi & 3;
	    $vcell[4*$x+120*$y+0]=$ct[$pal[$cin[0]]];
	    $vcell[4*$x+120*$y+1]=$ct[$pal[$cin[1]]];
	    $vcell[4*$x+120*$y+2]=$ct[$pal[$cin[2]]];
	    $vcell[4*$x+120*$y+3]=$ct[$pal[$cin[3]]];
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics3)
###############################################################################
sub fillarray_mode3
{
    for ($y=0;$y<58;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<42;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[2*$x+84*$y+0]=$ct[$pal[$lo]];
	    $vcell[2*$x+84*$y+1]=$ct[$pal[$hi]];
	}
    }
}

###############################################################################
# convert strings to char and charset array (mode 4)
###############################################################################
sub fillarray_mode4
{
    for ($y=0;$y<23;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[30*$y+$x]=(16*$hi+$lo) & 127;
	}
    }

    for ($y=0;$y<23;$y++)
    {
	$z=$data[23+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $acell[30*$y+$x]=16*$hi+$lo;
	}
    }
    $coffset=0;
    $loffset=0;
    for ($y=0;$y<41;$y++)
    {
	$z=$data[46+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $charcell[$coffset+128*$loffset]=16*$hi+$lo;
	    $coffset+=1;
	    if ($coffset==128)
	    {
		$coffset=0;
		$loffset+=1;
	    } 
	}
    }
    
}

###############################################################################
# convert strings to char and charset array (mode 6)
###############################################################################
sub fillarray_mode6
{
    for ($y=0;$y<23;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[30*$y+$x]=16*$hi+$lo;
	}
    }

    for ($c=0;$c<64;$c++)
    {
	$z=$data[23+$c];
	for ($y=0;$y<10;$y++)
	{
	    for ($x=0;$x<3;$x++)
	    {
		$hi=&get_nibble();
		$lo=&get_nibble();
		$charcell[60*$c+6*$y+2*$x+0]=$hi;
		$charcell[60*$c+6*$y+2*$x+1]=$lo;
	    }
	}
    }
}

###############################################################################
# convert strings to pixel array (graphics5)
###############################################################################
sub fillarray_mode5
{
    $bgc=$ct[$pal[0]];
    $fgc=$ct[$pal[1]];
    for ($y=0;$y<64;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<16;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $bline=$lo+16*$hi;
	    for ($px=0;$px<8;$px++)
	    {
		$bit=$bline & 1;
		if ($bit==0)
		{
		    $vcell[$px+8*$x+128*$y]=$bgc;
		}
		else
		{
		    $vcell[$px+8*$x+128*$y]=$fgc;
		}
		$bline=$bline >> 1;
	    }
	}
    }
}

###############################################################################
# convert strings to char and attribute array (mode 7)
###############################################################################
sub fillarray_mode7
{
    for ($y=0;$y<2;$y++)
    {
	$z=$data[$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $vcell[30*$y+$x]=16*$hi+$lo;
	}
    }

    for ($y=0;$y<2;$y++)
    {
	$z=$data[2+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    $acell[30*$y+$x]=16*$hi+$lo;
	}
    }
    $doffset=0;
    $line=0;
    $linebyte=0;
    for ($y=0;$y<83;$y++)
    {
	$z=$data[2+$y];
	for ($x=0;$x<30;$x++)
	{
	    $hi=&get_nibble();
	    $lo=&get_nibble();
	    if ($doffset<105)
	    {
		$lptr[$doffset++]=16*$hi+$lo;
	    }
	    else
	    {
		$lptr[$line][$linebyte]=16*$hi+$lo;
		$doffset+=1;
		$linebyte+=1;
		if ($linebyte==24)
		{
		    $linebyte=0;
		    $line+=1;
		}
	    }
	}
    }
}



sub lborder
{
    print WTAB "\"";
    for($bo=0;$bo<5;$bo++)
    {
	print WTAB $ct[$border];
    }
}

sub rborder
{
    for($bo=0;$bo<5;$bo++)
    {
	print WTAB $ct[$border];
    }
    print WTAB "\",\n";
}

sub uborder
{
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<$_[0];$chr++)
	{
	    print WTAB $ct[$border]; 
	}
	print WTAB "\",\n";
    }
}

sub dborder
{
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<$_[0];$chr++)
	{
	    print WTAB $ct[$border];
	}
	if ($pline<5)
	{
	    print WTAB "\",\n";
	}
	else
	{
	    print WTAB "\"\n";
	}
    }
}

###############################################################################
# write xpm image (normal mode)
###############################################################################
sub writexpm_mode0
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 240 16 1\",\n";
    &xpal();

    &uborder(370);
    for($cline=0;$cline<23;$cline++)
    {
	for($pline=0;$pline<10;$pline++)
	{
	    &lborder();
	    for($chr=0;$chr<30;$chr++)
	    {
		$vchar=$vcell[30*$cline+$chr];
		$attr=$acell[30*$cline+$chr];
		$vg=$attr & 15;
		$vg=$ct[$vg];
		$hg=$attr & 240;
		$hg=$ct[$hg/16];

		for($pix=0;$pix<6;$pix++)
		{
		    $pchar=$hg;
		    if ($charcell[6*$pline+60*$vchar+$pix]>0)
		    {
			$pchar=$vg;
		    }
		    print WTAB $pchar.$pchar;
		}
	    }
	    &rborder();
	}
    }
    &dborder(370);
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (graphics mode 1)
###############################################################################
sub writexpm_mode1
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"346 242 16 1\",\n";
    &xpal();

    &uborder(346);
    for($cline=0;$cline<116;$cline++)
    {
	for ($pline=0;$pline<2;$pline++)
	{
	    &lborder(); 
	    for($chr=0;$chr<168;$chr++)
	    {
		$vchar=$vcell[168*$cline+$chr];
		print WTAB $vchar.$vchar;
	    }
	    &rborder();
	}
    }
    &dborder(346);
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (graphics mode 2)
###############################################################################
sub writexpm_mode2
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 238 16 1\",\n";
    &xpal();

    &uborder(370);
    for($cline=0;$cline<76;$cline++)
    {
	for ($pline=0;$pline<3;$pline++)
	{
	    &lborder(); 
	    for($chr=0;$chr<120;$chr++)
	    {
		$vchar=$vcell[120*$cline+$chr];
		print WTAB $vchar.$vchar.$vchar;
	    }
	    &rborder();
	}
    }
    &dborder(370);
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (graphics mode 3)
###############################################################################
sub writexpm_mode3
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"346 242 16 1\",\n";
    &xpal();

    &uborder(346);
    for($cline=0;$cline<58;$cline++)
    {
	for ($pline=0;$pline<4;$pline++)
	{
	    &lborder();
	    for($chr=0;$chr<84;$chr++)
	    {
		$vchar=$vcell[84*$cline+$chr];
		print WTAB $vchar.$vchar;
		print WTAB $vchar.$vchar;
	    }
	    &rborder();
	}
    }
    &dborder(346);
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (mode 4)
###############################################################################
sub writexpm_mode4
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 240 16 1\",\n";
    &xpal();

    &uborder(370);
    for($cline=0;$cline<23;$cline++)
    {
	for($pline=0;$pline<10;$pline++)
	{
	    &lborder();
	    for($chr=0;$chr<30;$chr++)
	    {
		$vchar=$vcell[30*$cline+$chr];
		$attr=$acell[30*$cline+$chr];
		$vg=$attr & 15;
		$vg=$ct[$vg];
		$hg=$attr & 240;
		$hg=$ct[$hg/16];

		for($pix=0;$pix<6;$pix++)
		{
		    $pchar=$hg;
		    if ($charcell[6*$pline+60*$vchar+$pix]>0)
		    {
			$pchar=$vg;
		    }
		    print WTAB $pchar.$pchar;
		}
	    }
	    &rborder();
	}
    }
    &dborder(370);
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (mode 6)
###############################################################################
sub writexpm_mode6
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 240 16 1\",\n";
    &xpal();

    &uborder(370);
    for($cline=0;$cline<23;$cline++)
    {
	for($pline=0;$pline<10;$pline++)
	{
	    &lborder(); 
	    for($chr=0;$chr<30;$chr++)
	    {
		for($pix=0;$pix<6;$pix++)
		{
		    $vchar=($vcell[30*$cline+$chr] & 63) ;
		    $vg=$charcell[60*$vchar+6*$pline+$pix];
		    $vg=$ct[$vg];
		    print WTAB $vg.$vg;
		}
	    }
	    &rborder();
	}
    }
    &dborder(370);
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (graphics mode 5)
###############################################################################
sub writexpm_mode5
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"394 202 16 1\",\n";
    &xpal();

    &uborder(394);
    for($cline=0;$cline<64;$cline++)
    {
	for ($pline=0;$pline<3;$pline++)
	{
	    &lborder(); 
	    for($chr=0;$chr<128;$chr++)
	    {
		$vchar=$vcell[128*$cline+$chr];
		print WTAB $vchar.$vchar.$vchar;
	    }    
    	    &rborder();
	}
    }
    &dborder(394);
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# write xpm image (mode7)
###############################################################################
sub writexpm_mode7
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"370 240 16 1\",\n";
    &xpal();

    &uborder(370);
    $cline=0;
	for($pline=0;$pline<10;$pline++)
	{
	    &lborder();
	    for($chr=0;$chr<30;$chr++)
	    {
		$vchar=$vcell[30*$cline+$chr];
		$attr=$acell[30*$cline+$chr];
		$vg=$attr & 14;
		$vg=$ct[$vg/2];
		$hg=$attr & 224;
		$hg=$ct[$hg/32];

		for($pix=0;$pix<6;$pix++)
		{
		    $pchar=$hg;
		    if ($charcell[6*$pline+60*$vchar+$pix]>0)
		    {
			$pchar=$vg;
		    }
		    print WTAB $pchar.$pchar;
		}
	    }
	    &rborder();
	}

    for($cline=0;$cline<105;$cline++)
    {
	for($ldob=0;$ldob<2;$ldob++)
	{
	    &lborder();
	    $linenr=$lptr[$cline];
	    for ($i=0;$i<360;$i++)
	    {
		$xline[$i]=$border;
	    }
	    $start=159;
	    $dset=0;
	    $c1=$border;
	    $c2=$border;
	    for ($j=0;$j<360;$j++)
	    {
		$pos=($j-160)/(255-160)*360;
		if ($ldat[$linenr][$dset]==$j)
		{
		    $c1=$ldat[$linenr][$dset+1] & 224;
		    $c1=$c1 / 32;
		    $c2=$ldat[$linenr][$dset+1] & 14;
		    $c2=$c2 / 2;
		    
		    
		}
	    }
	
	    for ($i=0;$i<360;$i++)
	    {
		print WTAB $ct[$xline[$i]];
	    }
	    &rborder();
	}
    }

    $cline=1;
	for($pline=0;$pline<10;$pline++)
	{
	    &lborder();
	    for($chr=0;$chr<30;$chr++)
	    {
		$vchar=$vcell[30*$cline+$chr];
		$attr=$acell[30*$cline+$chr];
		$vg=$attr & 14;
		$vg=$ct[$vg/2];
		$hg=$attr & 224;
		$hg=$ct[$hg/32];

		for($pix=0;$pix<6;$pix++)
		{
		    $pchar=$hg;
		    if ($charcell[6*$pline+60*$vchar+$pix]>0)
		    {
			$pchar=$vg;
		    }
		    print WTAB $pchar.$pchar;
		}
	    }
	    &rborder();
	}
    &dborder(370);
    print WTAB "};\n"; 
    close(WTAB);
}


###############################################################################
# write xpm image (editor mode)
###############################################################################
sub writexpm_emode
{
    open (WTAB, ">temp.xpm");
    print WTAB "static char *screenshot_xpm[] ={\n";
    print WTAB "\"442 238 16 1\",\n";
    &xpal();

    &uborder(442);
    for($cline=0;$cline<19;$cline++)
    {
	for($pline=0;$pline<12;$pline++)
	{
	    if (($pline==0) || ($pline==11))
	    {
		print WTAB "\""; 
		for($chr=0;$chr<442;$chr++)
		{
		    print WTAB "."; 
		}
		print WTAB "\",\n"; 
	    }
	    else
	    {
		print WTAB "\"....."; 
		for($chr=0;$chr<36;$chr++)
		{
		    $vchar=$vcell[36*$cline+$chr];
		    $attr=$acell[36*$cline+$chr];
		    $vg=$attr & 15;
		    $vg=$ct[$vg];
		    $hg=$attr & 240;
		    $hg=$ct[$hg/16];
		    $font=$attr & 1;
		    for($pix=0;$pix<6;$pix++)
		    {
			$pchar=$hg;
			if ($charcell[60*$vchar+6*($pline-1)+$pix]>0)
			{
			    $pchar=$vg;
			}
			print WTAB $pchar.$pchar;
		    }
		}
		print WTAB ".....\",\n";
	    }
	}
    }

#Black border (lower)
    for($pline=0;$pline<5;$pline++)
    {
	print WTAB "\""; 
	for($chr=0;$chr<442;$chr++)
	{
    	    print WTAB "."; 
	}
	    if ($pline<5)
	    {
    	        print WTAB "\",\n";
	    }
	    else
	    {
        	print WTAB "\"\n";
	    }    
    }
    
    print WTAB "};\n"; 
    close(WTAB);
}

###############################################################################
# read character cells from fnt0
###############################################################################
$cline=0;
$count=-1;
open (RTAB, "fonts/ctab_f0.dat");
while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
	$count++;
    }
    elsif (length($z)>4)
    {
	$charcell[6*($cline)+60*$count+0]=&get_pixel();
	$charcell[6*($cline)+60*$count+1]=&get_pixel();
	$charcell[6*($cline)+60*$count+2]=&get_pixel();
	$charcell[6*($cline)+60*$count+3]=&get_pixel();
	$charcell[6*($cline)+60*$count+4]=&get_pixel();
	$charcell[6*($cline)+60*$count+5]=&get_pixel();
	$cline++;
    }
}
close(RTAB);

###############################################################################
# set serial port and read data from chip
###############################################################################
system `stty 2400 cs8 -parenb -echo -crtscts -ixon < /dev/ttyS0`;
print "AVR-ChipBASIC2 Screenshot loader V1.00\n";
print "reading data...";
&get_data();
close(SER);
print "done\n";

###############################################################################
# do it
###############################################################################
if ($vmode==0)
{
    &fillarray_mode0();
    &writexpm_mode0();
}
if ($vmode==8)
{
    &fillarray_emode();
    &writexpm_emode();
}
if ($vmode==1)
{
    &fillarray_mode1();
    &writexpm_mode1();
}
if ($vmode==2)
{
    &fillarray_mode2();
    &writexpm_mode2();
}
if ($vmode==3)
{
    &fillarray_mode3();
    &writexpm_mode3();
}
if ($vmode==4)
{
    &fillarray_mode4();
    &writexpm_mode4();
}
if ($vmode==5)
{
    &fillarray_mode5();
    &writexpm_mode5();
}

if ($vmode==6)
{
    &fillarray_mode6();
    &writexpm_mode6();
}

if ($vmode==7)
{
    &fillarray_mode7();
    &writexpm_mode7();
}

###############################################################################
# convert xpm image to whatever you want
###############################################################################
system`convert temp.xpm $fname`;
system`rm temp.xpm`;
