﻿
Public Class Form1

    Shared ZSend16 As UInt16
    Shared ZSend8 As Byte
    Shared SendArray() As Byte
    Shared ZEmpf16 As UInt16
    Shared ZEmpf8 As Byte

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Button5.BackColor = Color.FromArgb(180, 180, 180)
        TextBox3.Focus()
    End Sub


    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived

        Dim ZBytes As Integer = SerialPort1.BytesToRead                                                  'Anzahl der Bytes im Empfangspuffer
        Dim MyMSB As Byte
        Dim MyLSB As Byte

        Invoke(Sub()
                   TextBox10.Text = ZBytes.ToString()                                                    'TexBox10 - Anzahl der Bytes im Buffer
               End Sub)

        If ZBytes = 1 Then
            MyLSB = CByte(SerialPort1.ReadByte())
            ZEmpf8 = MyLSB

            Invoke(Sub()
                       TextBox5.Text = ZEmpf8.ToString()
                       TextBox6.Text = ""
                       TextBox7.Text = ""
                       TextBox8.Text = MyLSB.ToString()
                   End Sub)
        End If

        If ZBytes = 2 Then
            MyLSB = CByte(SerialPort1.ReadByte())
            MyMSB = CByte(SerialPort1.ReadByte())

            ZEmpf16 = 256 * MyMSB + MyLSB

            Invoke(Sub()
                       TextBox5.Text = ""
                       TextBox6.Text = ZEmpf16.ToString()
                       TextBox7.Text = MyMSB.ToString()
                       TextBox8.Text = MyLSB.ToString()
                   End Sub)
        End If

        'Invoke(Sub()
        '           TextBox4.Text = ZEmpf8.ToString()                                                   'SerialPort1.Read(MyArray, 0, 2)
        '       End Sub)                                                                                'BitConverter.ToUInt16(ZEmpf, 0)

        SerialPort1.DiscardInBuffer()                                                                   ' Zum löschen des Eingangspuffers
        'SerialPort1.DiscardOutBuffer()                                                                 ' Zum löschen des Ausgangspuffers
    End Sub


    Private Sub TextBox1_TextChanged(sender As System.Object, e As System.EventArgs)                    'COM-Port angeben > Voreinstellung = COM1

    End Sub


    Private Sub TextBox2_TextChanged(sender As System.Object, e As System.EventArgs)                    'Baudrate angeben > Voreinstellung = 2400

    End Sub


    Private Sub TextBox3_TextChanged(sender As Object, e As EventArgs) Handles TextBox3.TextChanged
        TextBox4.Text = ""
        Button2.BackColor = Color.FromArgb(100, 255, 175)
        Button3.BackColor = Color.FromArgb(180, 180, 180)
    End Sub


    Private Sub TextBox4_TextChanged(sender As Object, e As EventArgs) Handles TextBox4.TextChanged
        TextBox3.Text = ""
        Button3.BackColor = Color.FromArgb(100, 255, 175)
        Button2.BackColor = Color.FromArgb(180, 180, 180)
    End Sub


    Private Sub Button1_Click(sender As System.Object, e As System.EventArgs) Handles Button1.Click     'Connect-Button
        TextBox3.Focus()
        Try
            SerialPort1.PortName = TextBox1.Text
            SerialPort1.BaudRate = TextBox2.Text
            SerialPort1.Open()
            Button1.Enabled = False
            Button2.Enabled = True
            Button3.Enabled = True
            Button4.Enabled = True
            Button2.BackColor = Color.FromArgb(100, 255, 175)
            Button3.BackColor = Color.FromArgb(100, 255, 175)
            Button5.BackColor = Color.FromArgb(255, 140, 0)

        Catch ex As Exception
            MsgBox("Verbindung fehlgeschlagen!")
            SerialPort1.PortName = "COM1"
            SerialPort1.BaudRate = "9600"
        End Try
    End Sub


    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click     'Disconnect-Button
        SerialPort1.Close()
        Button1.Enabled = True
        Button2.Enabled = False
        Button3.Enabled = False
        Button4.Enabled = False
        Button2.BackColor = Color.FromArgb(180, 180, 180)
        Button3.BackColor = Color.FromArgb(180, 180, 180)
        Button5.BackColor = Color.FromArgb(180, 180, 180)
    End Sub


    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click     'Senden-Button 1Byte
        TextBox3.Focus()                                                                                'Fokus wird auf TextBox3 gesetzt
        Try
            ZSend8 = CInt(TextBox3.Text)                                                                'Text in Integer umwandeln (CStr-Interger in Text)

            If ZSend8 > -1 And ZSend8 <= 255 Then
                SendArray = BitConverter.GetBytes(ZSend8)
            End If
            TextBox4.Text = ""
        Catch ex As Exception
            MsgBox("Eingabe falsch!")
        End Try

        System.Threading.Thread.Sleep(50)                                                               'Warten 50ms
        SerialPort1.Write(SendArray, 0, 1)

    End Sub


    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click     'Senden-Button 2Byte
        TextBox4.Focus()                                                                                'Fokus wird auf TextBox3 gesetzt
        Try
            ZSend16 = CInt(TextBox4.Text)                                                               'Text in Integer umwandeln (CStr-Interger in Text)

            If ZSend16 > -1 And ZSend16 <= 65535 Then
                SendArray = BitConverter.GetBytes(ZSend16)
            End If
            TextBox3.Text = ""
        Catch ex As Exception
            MsgBox("Eingabe falsch!")
        End Try

        System.Threading.Thread.Sleep(50)                                                               'Warten 50ms
        SerialPort1.Write(SendArray, 0, 2)

    End Sub


    Private Sub Form1_FormClosing(sender As Object, e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If SerialPort1.IsOpen = True Then
            SerialPort1.Close()
        End If
    End Sub

   
    Private Sub Button5_Click(sender As Object, e As EventArgs) Handles Button5.Click                   'Beenden-Button
        If SerialPort1.IsOpen = True Then
            SerialPort1.Close()
        End If
        Close()
    End Sub

End Class

