/*
 * 	Doku, siehe http://www.mikrocontroller.net/articles/AVR_FAT32
 *	Autor: Daniel R.
 */

#ifndef CONFIG_H_
#define CONFIG_H_

	// #######################################################################################################################

	#define TRUE '1'
	#define FALSE '0'

	// schalter die den funktionsumfang aendern (fat/file):
	#define SMALL_FILE_SYSTEM 	TRUE	// wenn TRUE dann ist kleines file system, wenn FALSE dann komplette file unterstützung !
	#define WRITE 				TRUE	// wenn TRUE dann ist write an, wenn FALSE dann read only !
	#define OVER_WRITE 		FALSE	// wenn TRUE dann kann ffwrite dateien überschreiben (nicht performant), wenn FALSE dann nur normales schreiben !
	#define MULTI_BLOCK 		FALSE	// wenn TRUE dann werden multiblock schreib/lese funktionen benutzt. ist schneller, wird aber möglicherweise nicht von allen karten unterstützt. wenn FALSE ist normale operation

	// vorsicht, da die variable die die sektoren zählt ein short ist.
	#define MAX_CLUSTERS_IN_ROW 256 	// gibt an wie viele cluster am stück ohne fat-lookup geschrieben bzw gelesen werden können, wenn die fat nicht fragmentiert ist !

	// schalter fuer SPI geschwindigkeit
	// wenn MAX_SPEED FALSE dann wird die SPI bus geschwindigkeit nicht hoch gesetzt. ist zum testen von hardware die nicht richtig läuft
	#define MAX_SPEED TRUE

	// flags für ffopen (sind die rückgabewerte von ffopen, auf diese wird geprüft..)
	#define OPENED_TO_READ 'r'
	#define OPENED_TO_WRITE 'w'


	// uart flag und funktionen. hier kann, wenn man andere uart funktionen benutzen moechte die standart funktion geändert werden.
	#define UART_SEND_ONLY TRUE		// wenn TRUE, dann sind nur uart senden funktionen dabei, es werden keine zeichen eingelesen über den uart
	#define UART_INCLUDE  "uart.h"		// pfad zu include datei für die uart funktionen
	#define UPUTS uputs
	#define UPUTC uputc
	#define UINIT uinit
	#define UGETC ugetc
	#define UGETS ugets

#endif
