/*
 * main_simple.c
 *
 *  Created on: 03.09.2009
 *      Author: daniel
 */

/*
 * 	Doku, siehe http://www.mikrocontroller.net/articles/AVR_FAT32
 *	Autor: Daniel R.
 */

#include <stdlib.h>
#include <avr/interrupt.h>
#include <avr/io.h>

#include "config.h"	// hier werden alle nötigen konfigurationen vorgenommen !
#include "file.h"
#include "fat.h"
#include "mmc.h"		// hardware abhängig
#include "uart.h"		// hardware abhängig



//*****************************************************************************************************************
void main(void){

	uinit();								// uart initialisierung

	uputs((unsigned char*)"\nBoot");

	while (mmc_init() == FALSE){			// es wird solange versucht die karte zu initialisieren bis es klappt
		nop();
	}

	uputs((unsigned char*)"...");

	if(TRUE==fat_loadFatData()){			// fat initialisierung funktioniert?

		uputs((unsigned char*)"Ok\n");	// wenn auf dem terminal "Boot... OK" zu lesen ist, ist init ok. jetzt kann man schreiben/lesen

		unsigned char c;
		unsigned long int seek;
		unsigned char file_name[12]="TEST    TXT";

		seek=26;
		c='a';

		// rückgabewert OPENED_TO_WRITE bedeutet, datei ist nicht vorhanden und wurde grade angelegt. bereit zum schreiben !
		if(OPENED_TO_WRITE==ffopen(file_name)){
			do{
				ffwrite(c++);
			}while(--seek);

			// zeilenumbruch in der datei
			ffwrite(0x0D);
			ffwrite(0x0A);

			ffclose();
		}

		// hier ist rückgabewerte von ffopen eigentlich OPENED_TO_READ , datei ist vorhanden und wurde geöffnet. bereit zum lesen !
		else{

			ffopen(file_name);
			seek=file.length;

			do{
				c=ffread();
				uputc(c);
			}while(--seek);

			ffclose();
		}
	}
}









