/*
 * 	Doku, siehe http://www.mikrocontroller.net/articles/AVR_FAT32
 *	Autor: Daniel R.
 */

#ifndef _MMC_H
  #define _MMC_H  

  #define MMC_Write  			PORTB	//Port an der die MMC/SD-Karte angeschlossen ist also des SPI
  #define MMC_Read 			PINB
  #define MMC_Direction_REG	DDRB	

  #if defined (__AVR_ATmega128__)
	#define SPI_DI    		3  //Port Pin an dem Data Output der MMC/SD-Karte angeschlossen ist 
	#define SPI_DO    		2  //Port Pin an dem Data Input der MMC/SD-Karte angeschlossen ist
	#define SPI_Clock  	1  //Port Pin an dem die Clock der MMC/SD-Karte angeschlossen ist (clk)
	#define MMC_Chip_Select 4  //Port Pin an dem Chip Select der MMC/SD-Karte angeschlossen ist
	#define SPI_SS    		0  //Nicht Benutz mu� aber definiert werden
  #endif

  #if defined (__AVR_ATmega32__)
	#define SPI_DI   		6  //Port Pin an dem Data Output der MMC/SD-Karte angeschlossen ist 
	#define SPI_DO    		5  //Port Pin an dem Data Input der MMC/SD-Karte angeschlossen ist
	#define SPI_Clock  	7  //Port Pin an dem die Clock der MMC/SD-Karte angeschlossen ist (clk)
	#define MMC_Chip_Select 3  //Port Pin an dem Chip Select der MMC/SD-Karte angeschlossen ist
	#define SPI_SS    		4  //Nicht Benutz mu� aber definiert werden
  #endif

  #if defined (__AVR_ATmega168__)
	#define SPI_DI   		4  //Port Pin an dem Data Output der MMC/SD-Karte angeschlossen ist 
	#define SPI_DO    		3  //Port Pin an dem Data Input der MMC/SD-Karte angeschlossen ist
	#define SPI_Clock  	5  //Port Pin an dem die Clock der MMC/SD-Karte angeschlossen ist (clk)
	#define MMC_Chip_Select 1  //Port Pin an dem Chip Select der MMC/SD-Karte angeschlossen ist
	#define SPI_SS    		2  //Nicht Benutz mu� aber definiert werden
  #endif

  #if defined (__AVR_ATmega644__)
	#define SPI_DI   		6  //Port Pin an dem Data Output der MMC/SD-Karte angeschlossen ist 
	#define SPI_DO    		5  //Port Pin an dem Data Input der MMC/SD-Karte angeschlossen ist
	#define SPI_Clock  	7  //Port Pin an dem die Clock der MMC/SD-Karte angeschlossen ist (clk)
	#define MMC_Chip_Select 1  //Port Pin an dem Chip Select der MMC/SD-Karte angeschlossen ist
	#define SPI_SS			4  //Nicht Benutz mu� aber definiert werden
  #endif

  #if defined (__AVR_ATmega8__)
	#define SPI_DI    		4  //Port Pin an dem Data Output der MMC/SD-Karte angeschlossen ist 
	#define SPI_DO    		3  //Port Pin an dem Data Input der MMC/SD-Karte angeschlossen ist
	#define SPI_Clock  	5  //Port Pin an dem die Clock der MMC/SD-Karte angeschlossen ist (clk)
	#define MMC_Chip_Select 1  //Port Pin an dem Chip Select der MMC/SD-Karte angeschlossen ist
	#define SPI_SS    		2  //Nicht Benutz mu� aber definiert werden
  #endif



  //Prototypes
  extern  unsigned char 	mmc_init(void);

  extern  unsigned char		mmc_read_byte(void);
  extern  void 				mmc_write_byte(unsigned char);

  extern  unsigned char 	mmc_read_sector (unsigned long,unsigned char *);
  extern  unsigned char 	mmc_write_sector (unsigned long,unsigned char *);
  extern  unsigned char		mmc_write_command (unsigned char *);

  extern unsigned char		mmc_multi_block_stop_read (void);
  extern unsigned char		mmc_multi_block_stop_write (void);

  extern unsigned char 		mmc_multi_block_start_read (unsigned long int addr);
  extern void 				mmc_multi_block_read_sector (unsigned char *Buffer);
  
  extern unsigned char 		mmc_multi_block_start_write (unsigned long int addr);
  extern unsigned char		mmc_multi_block_write_sector (unsigned char *Buffer);

  extern unsigned char 		mmc_wait_ready (void);


  //set MMC_Chip_Select to high (MMC/SD-Karte Inaktiv)
  #define MMC_Disable() MMC_Write|= (1<<MMC_Chip_Select);

  //set MMC_Chip_Select to low (MMC/SD-Karte Aktiv)
  #define MMC_Enable() MMC_Write&=~(1<<MMC_Chip_Select);

  // einen takt nichts machen
  #define nop()  __asm__ __volatile__ ("nop" ::)


#endif
