#ifndef humidity_h_
#define humidity_h_

#include <avr\io.h>

// 			Access bits like variables:
struct bits {
  uint8_t b0:1;
  uint8_t b1:1;
  uint8_t b2:1;
  uint8_t b3:1;
  uint8_t b4:1;
  uint8_t b5:1;
  uint8_t b6:1;
  uint8_t b7:1;
} __attribute__((__packed__));

#define SBIT_(port,pin) ((*(volatile struct bits*)&port).b##pin)
#define	SBIT(x,y)	SBIT_(x,y)


// 			hardware definitions:


#define THRESHOLD_LOWBATT       (uint16_t)(1024 * 1.1 / 3.5 )   // 3.5V

#define	VCC			5.0
#define THRESHOLD_WET1  	(uint16_t)(1024 * 1.0 / VCC )	// 1.0V
#define THRESHOLD_WET2		(uint16_t)(1024 * 1.1 / VCC )   // 1.1V
#define THRESHOLD_DRY1		(uint16_t)(1024 * 4.0 / VCC )   // 4.0V
#define THRESHOLD_DRY2		(uint16_t)(1024 * 4.1 / VCC )   // 4.1V


#define XTAL            	1e6             // 1MHz


#define KEY_PIN			PIND
#define KEY_PULLUP		PORTD

#define KEY_ON_OFF 		0

#define	KEY_ON_OFF_PCI		PCINT16		// = PD0

#define ALL_KEY			( 1<<KEY_ON_OFF	)

#define	MEAS_IN			1		// = ADC1


#define	MEAS_PWR		SBIT( PORTC, 5 )
#define	MEAS_PWR_DDR		SBIT( DDRC,  5 )

#define LED_LOWBATT		SBIT( PORTB, 0 )
#define LED_LOWBATT_DDR		SBIT( DDRB,  0 )

#define LED_WET			SBIT( PORTB, 1 )
#define LED_WET_DDR		SBIT( DDRB,  1 )

#define LED_NORMAL		SBIT( PORTB, 2 )
#define LED_NORMAL_DDR		SBIT( DDRB,  2 )

#define LED_DRY			SBIT( PORTB, 3 )
#define LED_DRY_DDR		SBIT( DDRB,  3 )

#define LED_ON			0 			// low active
#define	LED_OFF			(!LED_ON)

#endif


