/*
 * Debounce of up to 8 keys using method of Peter Dannegger
 * 
 * https://www.mikrocontroller.net/articles/Entprellung#Komfortroutine_(C_f%C3%BCr_AVR)
 * 
 * adapted to Arduino style, almost 100% portable
 * only timer ISR needs to be adapted manually to NON-AVR Arduinos
 * 
 */
#include "debounce.h"

// Arduino IOs
#define LED0  14
#define LED1  15
#define LED2  16

void setup() {
  pinMode(LED0, OUTPUT);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  init_debounce();
}

void loop() {
  if ( get_key_short(KEY0)) digitalWrite(LED0, !digitalRead(LED0));   // reaction on key release
  if ( get_key_long(KEY1))  digitalWrite(LED1, !digitalRead(LED1));   // reaction after REPEAT_START ms
  if ( get_key_press(KEY2)) digitalWrite(LED2, !digitalRead(LED2));   // reaction on key press
}
