/*
 * Entprellung von bis zu 8 Tasten sowie Drehgeber nach Peter Dannegger
 * 
 * https://www.mikrocontroller.net/articles/Entprellung#Komfortroutine_(C_f%C3%BCr_AVR)
 * https://www.mikrocontroller.net/articles/Drehgeber#Solide_L%C3%B6sung:_Beispielcode_in_C
 * 
 * angepasst an Arduino-Stil, fast 100% portierbar
 * nur die Timer-ISR muss manuell an nicht-AVR Arduinos angepaßt werden
 * 
 */

#include "entprellung.h"
#include "drehgeber.h"
#include "timer.h"

// Arduino IOs
#define LED0  13
#define LED1  15
#define LED2  16

#define VGND 4    // Hilfsanschluss für GND, nur für den Testaufbau, wird normalerweise nicht benötigt

int drehgerberwert, drehgerberwert_alt; 

void setup() {
  pinMode(LED0, OUTPUT);
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(VGND, OUTPUT);
  digitalWrite(VGND, LOW);  
  init_debounce();
  init_encoder();
  init_timer();
  Serial.begin(9600);
  Serial.println(F("Demo fuer Tastenentprellung und Drehgeberdekodierung."));
}

void loop() {
  if ( get_key_short(KEY0)) digitalWrite(LED0, !digitalRead(LED0));   // Reaktion beim Taste loslassen
  if ( get_key_long(KEY1))  digitalWrite(LED1, !digitalRead(LED1));   // Reaktion nach REPEAT_START Millisekunden
  if ( get_key_press(KEY2)) digitalWrite(LED2, !digitalRead(LED2));   // Reaktion beim Taste drücken
  
  drehgerberwert += read_encoder(4);          // Encoder lesen, 4 elektrische Codes/Rastung
  if (drehgerberwert != drehgerberwert_alt) {
    Serial.println(drehgerberwert);
    drehgerberwert_alt = drehgerberwert;
  }
  delay(100);   // nur für die Demonstration
}
