/************************************************************************/
/*                                                                      */
/*                      Degeberdekodierung                              */
/*                      Ein, zwei, vier Schritte/Rastung unterstützt    */
/*                                                                      */
/*              Author: Peter Dannegger                                 */
/*                                                                      */
/************************************************************************/
#include "Arduino.h"
#include "drehgeber.h"

volatile int8_t enc_delta;          // -128 ... 127
int8_t enc_last;

void init_encoder( void ) {
  int8_t code;

  pinMode(PHASE_A, INPUT_PULLUP);
  pinMode(PHASE_B, INPUT_PULLUP);
  delay(10);  
  code = 0;
  if( digitalRead(PHASE_A) ) code  = 3;
  if( digitalRead(PHASE_B) ) code ^= 1;     // convert gray to binary
  enc_last = code;                          // power on state
  enc_delta = 0;
}

// read 1, 2, or 4 step encoders
int8_t read_encoder( uint8_t step )    { 
  int8_t val;

  // atomic access to enc_delta
  cli();
  val = enc_delta;
  switch (step) {
    case  2: enc_delta = val & 1; val >>= 1; break;
    case  4: enc_delta = val & 3; val >>= 2; break;
    default: enc_delta = 0; break;
  }
  sei();
  return val;                   // counts since last call
}
