#include "Arduino.h"
#include <avr/interrupt.h>
#include <util/atomic.h>
#include "entprellung.h"

volatile uint8_t key_state;
volatile uint8_t key_press;
volatile uint8_t key_rpt;

void init_debounce(void) {
  
#ifdef KEY0_IN    
  pinMode(KEY0_IN, INPUT_PULLUP);
#endif
#ifdef KEY1_IN    
  pinMode(KEY1_IN, INPUT_PULLUP);
#endif
#ifdef KEY2_IN    
  pinMode(KEY2_IN, INPUT_PULLUP);
#endif
#ifdef KEY3_IN    
  pinMode(KEY3_IN, INPUT_PULLUP);
#endif
#ifdef KEY4_IN    
  pinMode(KEY4_IN, INPUT_PULLUP);
#endif
#ifdef KEY5_IN    
  pinMode(KEY5_IN, INPUT_PULLUP);
#endif
#ifdef KEY6_IN    
  pinMode(KEY6_IN, INPUT_PULLUP);
#endif
#ifdef KEY7_IN    
  pinMode(KEY7_IN, INPUT_PULLUP);
#endif
}

/*
 * check if a key has been pressed. Each pressed key is reported
 * only once
 */

uint8_t get_key_press( uint8_t key_mask ) {
  ATOMIC_BLOCK(ATOMIC_RESTORESTATE) {
    key_mask &= key_press;                          // read key(s)
    key_press ^= key_mask;                          // clear key(s)
  }
  return key_mask;
}

/*
 * check if a key has been pressed long enough such that the
 * key repeat functionality kicks in. After a small setup delay
 * the key is reported being pressed in subsequent calls
 * to this function. This simulates the user repeatedly
 * pressing and releasing the key.
 */

uint8_t get_key_rpt( uint8_t key_mask ) {
  ATOMIC_BLOCK(ATOMIC_RESTORESTATE) {
    key_mask &= key_rpt;                            // read key(s)
    key_rpt ^= key_mask;                            // clear key(s)
  }
  return key_mask;
}

/*
 * check if a key is pressed right now
 */
 
uint8_t get_key_state( uint8_t key_mask ) {
  key_mask &= key_state;
  return key_mask;
}

/*
 * Get short key press
 */
 
uint8_t get_key_short( uint8_t key_mask ) {
  uint8_t i;
  ATOMIC_BLOCK(ATOMIC_RESTORESTATE) {
    i = get_key_press( ~key_state & key_mask );
  }
  return i;
}

/*
 * Get long key press
 */

uint8_t get_key_long( uint8_t key_mask ) {
  return get_key_press( get_key_rpt( key_mask ));
}
