uint8_t get_key_press( uint8_t key_mask );      // debounced key press, rising edge (pressed)
uint8_t get_key_rpt( uint8_t key_mask );        // continously pressed key, 1 pulse every REPEAT_NEXT ms
uint8_t get_key_state( uint8_t key_mask );      // current state
uint8_t get_key_short( uint8_t key_mask );      // short key press, falling edge (released)
uint8_t get_key_long( uint8_t key_mask );       // long key press (after REPEAT_START ms)
void init_debounce(void);

// Arduino IOs
// Tasten sind elektrisch low aktiv und schalten gegen GND
// interne Pull-Up Widerstände aktiv
// bis zu 8 Tasten nutzbar, unbenutzte Tasten auskommentieren
#define KEY0_IN         2
#define KEY1_IN         9
#define KEY2_IN        10
//#define KEY3_IN        10
//#define KEY4_IN        10
//#define KEY5_IN        10
//#define KEY6_IN        10
//#define KEY7_IN        10

// Bitmuster
#define KEY0            (1<<0)
#define KEY1            (1<<1)
#define KEY2            (1<<2)
#define KEY3            (1<<3)
#define KEY4            (1<<4)
#define KEY5            (1<<5)
#define KEY6            (1<<6)
#define KEY7            (1<<7)

#define ALL_KEYS        (KEY0 | KEY1 | KEY2)
#define REPEAT_MASK     (KEY1 | KEY2)       // repeat: key1, key2
#define REPEAT_START    50                  // after 500ms
#define REPEAT_NEXT     20                  // every 200ms

// logische Tasten sind high aktiv, bit = 1: Taste gedrückt 
extern volatile uint8_t key_state;    // debounced and inverted key state                                   
extern volatile uint8_t key_press;    // key press detect
extern volatile uint8_t key_rpt;      // key long press and repeat
