#include "Arduino.h"
#include <avr/interrupt.h>
#include "entprellung.h"
#include "drehgeber.h"
#include "timer.h"

// F_TIMER ISR, muss an Nicht-AVR Arduinos angepasst werden

void init_timer(void) {
 
  // Timer 1, CTC mode 4, prescaler 256  
  TCCR1A  = 0;
  TCCR1B  = (1<<WGM12) | (1<<CS12);
  OCR1A   = (F_CPU / (256L * F_TIMER1))-1;
  TIMSK1 |= (1<<OCIE1A);                   // enable timer interrupt
}

ISR( TIMER1_COMPA_vect ) {
  static uint8_t ct0 = 0xFF, ct1 = 0xFF, rpt, cnt10ms;
  uint8_t i, keys=0;

  cnt10ms++;
  if ( cnt10ms == 10) {
    cnt10ms = 0;
      
// Tasten einlesen und entprellen
// nur mit 10ms Zeitraster, das reicht

#ifdef KEY0_IN  
    if (!digitalRead(KEY0_IN)) keys |= KEY0;
#endif
#ifdef KEY1_IN  
    if (!digitalRead(KEY1_IN)) keys |= KEY1;
#endif
#ifdef KEY2_IN  
    if (!digitalRead(KEY2_IN)) keys |= KEY2;
#endif
#ifdef KEY3_IN  
    if (!digitalRead(KEY3_IN)) keys |= KEY3;
#endif
#ifdef KEY4_IN  
    if (!digitalRead(KEY4_IN)) keys |= KEY4;
#endif
#ifdef KEY5_IN  
    if (!digitalRead(KEY5_IN)) keys |= KEY5;
#endif
#ifdef KEY6_IN  
    if (!digitalRead(KEY6_IN)) keys |= KEY6;
#endif
#ifdef KEY7_IN  
    if (!digitalRead(KEY7_IN)) keys |= KEY7;
#endif

    i = key_state ^ keys;                           // key changed ?
    ct0 = ~( ct0 & i );                             // reset or count ct0
    ct1 = ct0 ^ (ct1 & i);                          // reset or count ct1
    i &= ct0 & ct1;                                 // count until roll over ?
    key_state ^= i;                                 // then toggle debounced state
    key_press |= key_state & i;                     // 0->1: key press detect
    
    if ( (key_state & REPEAT_MASK) == 0 ) {          // check repeat function
       rpt = REPEAT_START;                          // start delay
    }
    if ( --rpt == 0 ) {
      rpt = REPEAT_NEXT;                            // repeat delay
      key_rpt |= key_state & REPEAT_MASK;
    }
  }
  
// Drehgeber mit 1kHz dekodieren ist sinnvoll

  int8_t code, diff;

  code = 0;
  if( digitalRead(PHASE_A) ) code  = 3;
  if( digitalRead(PHASE_B) ) code ^= 1;     // convert gray to binary
  diff = enc_last - code;           // difference last - new
  if( diff & 1 ) {                  // bit 0 = 1?
    enc_last = code;                // store new as next last
    enc_delta += (diff & 2) - 1;    // bit 1 = direction (+/-)
  }
}
