; File:		timer-m48-lc204\definitions.inc
; Device:	ATmega48
; Created:	2023-10-09
; Version:	2023-10-24
; Author:	Johannes Fechner
;			https://www.mikrocontroller.net/user/show/jofe

; == Hardware definitions ==
; === CPU clock frequency ===
.equ F_CPU = 4_000_000 ; Hz

; === LED 7-segment display ===
; ==== Segments ====
.equ LED_S_DDR = DDRD
.equ LED_S_PORT = PORTD

; ==== Common cathodes ====
.equ LED_C_DDR = DDRB
.equ LED_C_PORT = PORTB
.equ LED_C_DIGIT0 = PB0		; rightmost (least significant) digit
.equ LED_C_DIGIT1 = PB1
.equ LED_C_DIGIT2 = PB2
.equ LED_C_DIGIT3 = PB3		; leftmost (most significant) digit
.equ LED_C_DOTS = PB4		; dots on LED display

; === Relay ===
.equ RELAY_DDR = DDRC
.equ RELAY_PORT = PORTC
.equ RELAY = PC4

; === IR receiver ===
.equ IR_RX_PIN = PINC
.equ IR_RX = PC5

; == Register definitions ==
; === General registers ===
.def reg00  = r2
;.def regFF = r3
.def temp0 = r16
.def temp1 = r17
.def temp2 = r18

; === Clock registers ===
.def seconds = r19
.def minutes = r20
.def digit0 = r6			; Contains 7-segment code of rightmost (least significant) digit.
.def digit1 = r7			; These digit registers (digit0..3) and dots are directly applied to LED_S_PORT.
.def digit2 = r8
.def digit3 = r9			; Contains 7-segment code of leftmost (most significant) digit.
.def dots = r10				; Contains dots code.
.def timerState = r21
.def displayState = r22
.def displayMode = r23

; === IR receiver registers ===
.def ir_status = r11
.def ir_intrCntrL = r12
.def ir_intrCntrH = r13
.def ir_pulseCntr = r24

; == RAM usage of ir_intr ==
.dseg
.org SRAM_START
ir_data:			.byte 4 ; the received data (address and command)
.if IR_DEBUG
ir_disc_code:		.byte 1 ; the reason why reception was discarded (see "Debug message codes" above)
ir_disc_intrCntrL:	.byte 1 ; copy of ir_intrCntrL value when reception was discarded
ir_disc_intrCntrH:	.byte 1 ; copy of ir_intrCntrH value when reception was discarded
ir_disc_pulseCntr:	.byte 1 ; copy of ir_pulseCntr value when reception was discarded
.endif
.cseg

; == EEPROM usage ==
.eseg
.org 0
ee_seconds:			.byte 1
ee_minutes:			.byte 1
.cseg
