; File:		timer-m48-lc204\ir-rx-pulse-dist.config.asm
; Device:	ATmega48
; Created:	2023-10-09
; Version:	2023-10-20
; Author:	Johannes Fechner
;			https://www.mikrocontroller.net/user/show/jofe

; === Device selection ===
.equ TINY_1_SERIES = 0

; == Implemented IR codes ==
; Currently implemented IR codes, values following https://www.mikrocontroller.net/articles/IRMP :
.equ IR_NEC = 2
.equ IR_SAMSUNG32 = 10

; == Configuration ==
; Choose the IR protocol to be received:
.equ IR_PROTOCOL = IR_NEC

; Choose whether to recognize repetition frames, resulting in the IR_STATUS_REPETITION flag being set.
; Only available if the chosen protocol uses them.
; Set the following symbol to 0 in order to disable the recognition of repetition frames:
.equ IR_RECOGNIZE_REPETITION = 0

; Choose whether the IR_STATUS_DISCARDED flag is to be set when a reception was discarded.
; Set the following symbol to 0 in order to disable that:
.equ IR_DEBUG = 0

; Set the admissible time tolerance in %:
.equ IR_TOLERANCE = 30

; Set the IR interrupt frequency in Hz = interrupts per second:
.equ IR_INTR_FREQ = 20_000

; Set the denominator of the IR timer prescaler:
.equ IR_TIMER_PRESC = 1

; Set the timeout (after which a transmission is considered to have ended) in milliseconds:
.equ IR_TIMEOUT_MS = 12
