; File:			remote-control-noname-defs.asm
; Version:		2023-10-09
; Description:	This file defines a table in ROM which associates each byte
;				value (0..255) with an ID which specifies the button meaning,
;				or RC_COMMANDS (the count of IDs) in case the byte is not
;				sent by any button of the remote control.

; The address sent by the remote control:
.equ RC_ADDRESS = 0x00
; Total count of buttons (commands):
.equ RC_COMMANDS = 20

rcCmdIdTable:
.db 20, 20, 20, 20, 20, 20, 20, 15,  4, 17, 20, 20,  1, 19, 20, 20
.db 20, 20, 20, 20, 20, 16,  0, 20,  2, 18, 20, 20,  5, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 13, 20,  7, 14, 12, 10, 20, 11, 20, 20,  9, 20, 20, 20, 20, 20
.db 20, 20,  8, 20, 20, 20, 20, 20, 20, 20,  6, 20, 20, 20,  3, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20
.db 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20

; Buttons "0".."9" -> 0..9.
.equ RC_CMD_POWER = 10
.equ RC_CMD_MENU = 11
.equ RC_CMD_TEST = 12
.equ RC_CMD_PLUS = 13
.equ RC_CMD_BACK = 14
.equ RC_CMD_SKIP_LEFT = 15
.equ RC_CMD_PLAY = 16
.equ RC_CMD_SKIP_RIGHT = 17
.equ RC_CMD_MINUS = 18
.equ RC_CMD_CANCEL = 19
