#![no_std]
#![no_main]
#![feature(core_intrinsics)]
#![feature(abi_avr_interrupt)]
// #![allow(non_snake_case)] // for ISRs

use attiny_hal::{
    clock::{self, Clock},
    delay,
    prelude::*,
};
mod usiuart;

#[no_mangle]
pub extern "C" fn main() {
    let mut delay = delay::Delay::<clock::MHz1>::new();

    // https://docs.rs/svd2rust/0.28.0/svd2rust/#peripheral-api
    let peripherals = attiny_hal::Peripherals::take().unwrap();

    let exint = peripherals.EXINT;
    let timer0 = peripherals.TC0;
    let usi = peripherals.USI;
    let pins = attiny_hal::pins!(peripherals);
    let mut usiuart_pins = usiuart::Pins {
        tx: pins.pb1.into_output(),        // do
        rx: pins.pb0.into_pull_up_input(), // di
        rw: pins.pb3.into_output(),
        yellow: pins.pb2.into_output(),
    };

    usiuart_pins.rw.set_low();

    usiuart_pins.yellow.set_low();
    delay.delay_ms(1u16);
    usiuart_pins.yellow.toggle();
    delay.delay_ms(1u16);
    usiuart_pins.yellow.toggle();

    usiuart::init(
        exint,
        timer0,
        usi,
        usiuart_pins,
        <clock::MHz1 as Clock>::FREQ,
        usiuart::Baudrate::_9600,
        usiuart::StopBits::_1,
    );

    unsafe { avr_device::interrupt::enable() };

    let loop_delay = 1u16;
    loop {
        delay.delay_ms(loop_delay);
        usiuart::send_byte(0x45); //0b0100_0101
        delay.delay_ms(loop_delay);
        usiuart::send_byte(0x00);
        delay.delay_ms(loop_delay);
        usiuart::send_byte(0xFF);
    }
}

#[panic_handler]
fn my_panic(_info: &core::panic::PanicInfo) -> ! {
    loop {}
}
