/* -------------------------------------------------------------
                        my_time.h

     Eigene Zeitberechnung, aehnlich time.h der
     Standardbibliothek, diese jedoch abgespeckt.

     Es werden die Sekunden gezaehlt, die seit dem
     01.01.1970  (angegeben in yearofs) vergangen
     sind.

     Mittels der Struktur < mydate_time > kann das
     Datum fuer Jahr, Monat, Tag, Stunde, Minude und
     Sekunde angegeben werden und daraus ein Zeit-
     stempel errechnet werden.

     Zudem kann "rueckwaerts" aus einem Zeitstempel
     das Datum berechnet werden

     01.07.2024 R. Seelig
   ------------------------------------------------------------- */

#ifndef in_my_time
  #define in_my_time

  #define yearofs        1970                   // Jahr, auf das sich alle vergangenen Sekunden
                                                // beziehen

  #define sec_per_min    60
  #define sec_per_hour   3600
  #define sec_per_day    86400ul
  #define sec_per_year   (sec_per_day * 365)


  struct MYDATE_TIME
  {
    uint16_t year;
    uint8_t  month;
    uint8_t  day;
    uint8_t  hour;
    uint8_t  min;
    uint8_t  sec;
  };

  typedef struct MYDATE_TIME  mydate_time;

  extern mydate_time mydate;

/* -------------------------------------------------------------
     Prototypen
   ------------------------------------------------------------- */
  uint8_t month_len(int year, uint8_t month);
  void mydate_get(uint32_t stamp);
  uint32_t mydate_getstamp(void);
  char mydate_getwtag(void);


#endif
