# LTspice Benchmark Script
#
# E. Sims 3/29/2020
# Udo Krebelder <udo.krebelder@gmx.at> 10/02/2022
#

$ErrorActionPreference = "Stop"

# List of LTspice test files
$files = @( 'mux8.cir',
            'mike2.cir',
            'bjtff.cir',
            'AzurAmp2.asc',
            'MonteCarlo.asc',
            'SettleTime.asc',
            'OscillatorQuadrature2.asc'
            #,
            #'LT3845_TA01.asc',
            #'BuckBoost.asc',
            #'Electrometer.asc',
            #'AudioChannels16.asc'
            )

# LTspice executable, user defined location
#$LTspice = "Set to your preferred LTspice version"
$LTspice = "C:\Program Files\ADI\LTspice_v24.0.12\LTspice.exe"

if (!(Test-Path $LTspice)) {
    # LTspice executable, standard location from registry
    $key = 'HKLM:\SOFTWARE\Analog Devices Inc.\LTspice'
    $LTspicePath = (Get-ItemProperty -Path $key -Name Path).Path
    $LTspice = (Join-Path $LTspicePath 'LTspice.exe')
}

if (!(Test-Path $LTspice)) {
    # LTspice, alternate location
    $LTspice = "C:\Program Files\LTC\LTspice\LTspice.exe"
}

if (!(Test-Path $LTspice)) {
    # LTspice, alternate location
    $LTspice = "C:\Program Files\LTspice\LTspice.exe"

}

if (!(Test-Path $LTspice)) {
    # LTspice, alternate location
    $LTspice = "C:\Program Files\LTC\LTspiceXVII\XVIIx64.exe"
}

if (!(Test-Path $LTspice)) {
    # LTspice, alternate location
    $LTspice = "C:\Program Files\LTspiceXVII\XVIIx64.exe"

}

if (!(Test-Path $LTspice)) {
    # Give up
    Write-Error "Cannot find LTspice executable" -ErrorAction Stop
}

#Write-Output ('LTspice: ' + $LTspice)

$ver = [Diagnostics.FileVersionInfo]::GetVersionInfo($LTspice)

$date = date
Write-Output ("$LTspice Benchmark")
Write-Output ''
Write-Output ("$ver.ProductVersion")
Write-Output ''
Write-Output 'CPU Info...'
$proc = Get-WmiObject -Class Win32_Processor | Select-Object -Property Name, NumberOfCores, NumberOfLogicalProcessors
($proc | Out-String).Trim() | Write-Output
Write-Output ''

$runs = @()
$totaltime = 0

foreach($file in $files)
{
    Write-Output ('Running ' + $file + ': ')

    $b = (Get-Item $file).basename
    $l = $b + '.log'
    if (Test-Path $l) { Remove-Item $l }

    # time2 is the execution time
    #$time2 = (Measure-Command {cmd /c 'XVIIx64.exe' -b -run $file}).TotalSeconds
    Start-Process -NoNewWindow -Wait -FilePath $LTspice -ArgumentList "-b -run $file"

    # time is the simulation time from the log file
    $f = (Select-String -path $l -pattern "Total elapsed time:")
    $a = @($f -split ' ')
    $time = $a[3]

    $runs += [pscustomobject]@{'File'=$file;'ExecTime'=[math]::Round($time,1)}

    $totaltime += $time
    Write-Output ('  ' + [math]::Round($time,1) + ' seconds')
    Write-Output ''
    Start-Sleep -m 100

    $f = $b + '.net'
    if (Test-Path $f) { Remove-Item $f }

    $f = $b + '.raw'
    if (Test-Path $f) { Remove-Item $f }

    $f = $b + '.op.raw'
    if (Test-Path $f) { Remove-Item $f }
}

Write-Output ('Total time: ' + [math]::Round($totaltime,0) + ' seconds')
Write-Output ''

$logfile = '2_LTspiceBenchmarkReport.txt'

if (!(Test-Path $logfile)) { New-Item -Path . -Name $logfile -ItemType "file" }

Add-Content -Path $logfile '********************************************************************************'
Add-Content -Path $logfile ("LTspice " + $ver.ProductVersion + " Benchmark")
Add-Content -Path $logfile ($env:computername + ' ' + $date)
Add-Content -Path $logfile ''

($proc | Out-String).Trim() | Out-File $logfile -Append -Encoding ASCII
Add-Content -Path $logfile ''

($runs | Select-Object -Property File,ExecTime | Out-String).Trim() | Out-File $logfile -Append -Encoding ASCII
Add-Content -Path $logfile ''

Add-Content -Path $logfile ('Total time: ' + [math]::Round($totaltime,0) + ' seconds')
Add-Content -Path $logfile ''
Add-Content -Path $logfile ''

#pause
