# QSpice Benchmark Script
#
# Udo Krebelder <udo.krebelder@gmx.at> 09/04/2025
#

$ErrorActionPreference = "Stop"

# List of QSpice test files
$files = @( 'mux8.cir',
            'mike2.cir',
            'bjtff.cir',
            'AzurAmp2.cir',
            'MonteCarlo.cir',
            'SettleTime.cir',
            'OscillatorQuadrature2.cir'
            )

# QSpice executable, user defined location
#$QSpice = "Set to your preferred QSpice version"
$QSpice = "C:\Program Files\QSPICE\QSPICE64.exe"

if (!(Test-Path $QSpice)) {
    Write-Error "Cannot find QSpice executable" -ErrorAction Stop
}

#Write-Output ('QSpice: ' + $QSpice)

$ver = [Diagnostics.FileVersionInfo]::GetVersionInfo($QSpice)

$date = date
Write-Output ("$QSpice Benchmark")
Write-Output ''
Write-Output ("$ver.ProductVersion")
Write-Output ''
Write-Output 'CPU Info...'
$proc = Get-WmiObject -Class Win32_Processor | Select-Object -Property Name, NumberOfCores, NumberOfLogicalProcessors
($proc | Out-String).Trim() | Write-Output
Write-Output ''

$runs = @()
$totaltime = 0

foreach($file in $files)
{
    Write-Output ('Running ' + $file + ': ')

    $b = (Get-Item $file).basename
    $l = $b + '.log'
    if (Test-Path $l) { Remove-Item $l }

    # time2 is the execution time
    #Start-Process -FilePath $QSpice -Wait -ArgumentList "-b -run $file"
    #$time2 = $sw.Elapsed
    #$time2 = (Measure-Command -Expression { Start-Process -NoNewWindow -Wait -FilePath $QSpice -ArgumentList "$file" } ).TotalSeconds

    Start-Process -NoNewWindow -Wait -FilePath $QSpice -ArgumentList "$file" -RedirectStandardError $l

    # time is the simulation time from the log file
    $f = (Select-String -path $l -pattern "Total elapsed time:")
    $a = @($f -split ' ')
    $time = $a[3]

    #Write-Output ('x10: ' + $time)

    $runs += [pscustomobject]@{'File'=$file;'ExecTime'=[math]::Round($time,1)}

    $totaltime += $time
    Write-Output ('  ' + [math]::Round($time,1) + ' seconds')
    Write-Output ''
    Start-Sleep -m 100

    $f = $b + '.qraw'
    if (Test-Path $f) { Remove-Item $f }

    $f = $b + '.op.qraw'
    if (Test-Path $f) { Remove-Item $f }
}

Write-Output ('Total time: ' + [math]::Round($totaltime,0) + ' seconds')
Write-Output ''

$logfile = '5_QSpiceBenchmarkReport.txt'

if (!(Test-Path $logfile)) { New-Item -Path . -Name $logfile -ItemType "file" }

Add-Content -Path $logfile '********************************************************************************'
Add-Content -Path $logfile ("QSpice " + $ver.ProductVersion + " Benchmark")
Add-Content -Path $logfile ($env:computername + ' ' + $date)
Add-Content -Path $logfile ''

($proc | Out-String).Trim() | Out-File $logfile -Append -Encoding ASCII
Add-Content -Path $logfile ''

($runs | Select-Object -Property File,ExecTime | Out-String).Trim() | Out-File $logfile -Append -Encoding ASCII
Add-Content -Path $logfile ''

Add-Content -Path $logfile ('Total time: ' + [math]::Round($totaltime,0) + ' seconds')
Add-Content -Path $logfile ''
Add-Content -Path $logfile ''

#pause
