/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			04.01.2008
 Latest version generated:	11.01.2010
 Filename:					3SlacesMasterMain.c
 Description:    			Main routine for testing
 							3SlacesMasterMain.c
 ********************************************************/
#include <stdio.h>
#include <avr/interrupt.h>

#include "General.h"
#include "RS232.h"
#include "Delay.h"
#include "TWI_Master.h"
/*
** This main programm demonstrates how to use the 
** implemented TWI master functions. These are:
**	TWIM_Init
**	TWIM_ReadAck
**	TWIM_ReadNack
**	TWIM_Write
**	TWIM_Stop
**
** Connect the two TWI lines properly (don't forget to also
** connect GND between Master and Slave!)
**
** Used uC for Master is ATMega8
*/
int main (void)
	{
	uint8_t		i;
	uint8_t		j=0;
	uint8_t		SlaveAddress1 = 15;	// The address for the first controller
	uint8_t		SlaveAddress2 = 16;	// The address for the second controller
	uint8_t		SlaveAddress3 = 17;	// The address for the third controller
/*
** Clear any interrupt
*/
	cli ();
/*
** Wait 1 second for POR
*/
	Delay_ms (1000);
/*
** Initiate RS232
*/
	RS232_Init ();
	printf ("Hello world...\n");
/*
** Initiate TWI Master Interface with bitrate of 100000 Hz
*/
	if (!TWIM_Init (100000))
		{
		printf ("Error in initiating TWI interface\n");
		while (1);
		}
/*
** Endless loop
*/
	while (1)
		{
/*
** Write byte(s) to the slave 1.
** It is implicitely assumed, that the slave will
** accepts 8 bytes
*/
    	if (!TWIM_Start (SlaveAddress1, TWIM_WRITE))
			{
			TWIM_Stop ();
			printf ("Could not start TWI Bus for WRITE\n");
	    	}
		else
			{
			for (i=0;i<8;i++)
				{
	        	TWIM_Write (j++);
				printf ("Byte %d sent: %d\n", i, j);
				}
			TWIM_Stop ();
			Delay_ms (1000);
			}


/*
** Write byte(s) to the slave 2.
** It is implicitely assumed, that the slave will
** accepts 8 bytes
*/
    	if (!TWIM_Start (SlaveAddress2, TWIM_WRITE))
			{
			TWIM_Stop ();
			printf ("Could not start TWI Bus for WRITE\n");
	    	}
		else
			{
			for (i=0;i<8;i++)
				{
	        	TWIM_Write (j++);
				printf ("Byte %d sent: %d\n", i, j);
				}
			TWIM_Stop ();
			Delay_ms (1000);
			}

/*
** Write byte(s) to the slave 3.
** It is implicitely assumed, that the slave will
** accepts 8 bytes
*/
    	if (!TWIM_Start (SlaveAddress3, TWIM_WRITE))
			{
			TWIM_Stop ();
			printf ("Could not start TWI Bus for WRITE\n");
	    	}
		else
			{
			for (i=0;i<8;i++)
				{
	        	TWIM_Write (j++);
				printf ("Byte %d sent: %d\n", i, j);
				}
			TWIM_Stop ();
			Delay_ms (1000);
			}

/*
** Do something else
*/
		i++;
		}

	return 0;
	}

